/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.omnis.network.packets;

import com.sammy.omnis.network.PacketEffects;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class ParticlePacket {
    int type;
    double posX;
    double posY;
    double posZ;

    public ParticlePacket(typeEnum type, double posX, double posY, double posZ) {
        this.type = type.type;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
    }

    public ParticlePacket(int type, double posX, double posY, double posZ) {
        this.type = type;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
    }

    public static ParticlePacket decode(PacketBuffer buf) {
        int strength = buf.readInt();
        double posX = buf.readDouble();
        double posY = buf.readDouble();
        double posZ = buf.readDouble();
        return new ParticlePacket(strength, posX, posY, posZ);
    }

    public void encode(PacketBuffer buf) {
        buf.writeInt(this.type);
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
    }

    public void whenThisPacketIsReceived(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> PacketEffects.particles(this.type, this.posX, this.posY, this.posZ));
        context.get().setPacketHandled(true);
    }

    public static enum typeEnum {
        spellBlade(0),
        vindicatorAxe(1);

        int type;

        private typeEnum(int type) {
            this.type = type;
        }
    }
}

