/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.opticmanager;

import com.creativemd.opticmanager.OpticManager;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class OpticEventHandler {
    public static final long vanillaDuration = 24000L;
    public static final long vanillaHalfDuration = 12000L;
    public long lastWorldTime = -1L;
    public long lastTotalWorldTime = -1L;
    public long realWorldTime;
    @SideOnly(value=Side.CLIENT)
    public long lastWorldTimeClient;
    @SideOnly(value=Side.CLIENT)
    public long lastTotalWorldTimeClient;
    @SideOnly(value=Side.CLIENT)
    public long realWorldTimeClient;
    public static float defaultGammaSetting;

    public OpticEventHandler() {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.initClient();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void initClient() {
        this.lastWorldTimeClient = -1L;
        this.lastTotalWorldTimeClient = -1L;
    }

    public void assignTime(long worldTime) {
        long days = worldTime / 24000L;
        this.realWorldTime = days * (long)OpticManager.CONFIG.getTotalDayDuration();
        this.realWorldTime = this.isDayVanilla(worldTime) ? (this.realWorldTime += (long)((float)(worldTime % 24000L) / 12000.0f * (float)OpticManager.CONFIG.dayDuration)) : (this.realWorldTime += (long)((float)(worldTime % 24000L - 12000L) / 12000.0f * (float)OpticManager.CONFIG.nightDuration + (float)OpticManager.CONFIG.dayDuration));
    }

    public boolean isDayVanilla(long time) {
        return this.isDay(time, 12000L, 12000L);
    }

    public boolean isDay(long time, long dayDuration, long nightDuration) {
        return time % (dayDuration + nightDuration) <= dayDuration;
    }

    public boolean shouldAffectWorld(World world) {
        return world.field_73011_w.getDimension() == 0 && world.func_82736_K().func_82766_b("doDaylightCycle");
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void tick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.END && mc.field_71441_e != null) {
            this.changeTick((World)mc.field_71441_e);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void assignTimeClient(long worldTime) {
        long days = worldTime / 24000L;
        this.realWorldTimeClient = days * (long)OpticManager.CONFIG.getTotalDayDuration();
        this.realWorldTimeClient = this.isDayVanilla(worldTime) ? (this.realWorldTimeClient += (long)((float)(worldTime % 24000L) / 12000.0f * (float)OpticManager.CONFIG.dayDuration)) : (this.realWorldTimeClient += (long)((float)(worldTime % 24000L - 12000L) / 12000.0f * (float)OpticManager.CONFIG.nightDuration + (float)OpticManager.CONFIG.dayDuration));
    }

    @SideOnly(value=Side.CLIENT)
    public void changeTick(World world) {
        if (!this.shouldAffectWorld(world)) {
            return;
        }
        long expectedWorldTime = this.lastWorldTimeClient + 1L;
        if (expectedWorldTime == world.func_72820_D()) {
            ++this.realWorldTimeClient;
            int days = (int)(this.realWorldTimeClient / (long)OpticManager.CONFIG.getTotalDayDuration());
            if (this.isDay(this.realWorldTimeClient, OpticManager.CONFIG.dayDuration, OpticManager.CONFIG.nightDuration)) {
                world.func_72877_b((long)days * 24000L + (long)((float)(this.realWorldTimeClient % (long)OpticManager.CONFIG.getTotalDayDuration()) / (float)OpticManager.CONFIG.dayDuration * 12000.0f));
            } else {
                world.func_72877_b((long)((float)((long)days * 24000L) + (float)(this.realWorldTimeClient % (long)OpticManager.CONFIG.getTotalDayDuration() - (long)OpticManager.CONFIG.dayDuration) / (float)OpticManager.CONFIG.nightDuration * 12000.0f + 12000.0f));
            }
            world.func_82738_a(world.func_82737_E() + expectedWorldTime - world.func_72820_D());
        } else {
            this.assignTimeClient(world.func_72820_D());
        }
        this.lastWorldTimeClient = world.func_72820_D();
        this.lastTotalWorldTimeClient = world.func_82737_E();
    }

    @SubscribeEvent
    public void tick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            World world = event.world;
            if (!this.shouldAffectWorld(world)) {
                return;
            }
            long expectedWorldTime = this.lastWorldTime + 1L;
            if (expectedWorldTime == world.func_72820_D()) {
                ++this.realWorldTime;
                int days = (int)(this.realWorldTime / (long)OpticManager.CONFIG.getTotalDayDuration());
                if (this.isDay(this.realWorldTime, OpticManager.CONFIG.dayDuration, OpticManager.CONFIG.nightDuration)) {
                    world.func_72877_b((long)days * 24000L + (long)((float)(this.realWorldTime % (long)OpticManager.CONFIG.getTotalDayDuration()) / (float)OpticManager.CONFIG.dayDuration * 12000.0f));
                } else {
                    world.func_72877_b((long)((float)((long)days * 24000L) + (float)(this.realWorldTime % (long)OpticManager.CONFIG.getTotalDayDuration() - (long)OpticManager.CONFIG.dayDuration) / (float)OpticManager.CONFIG.nightDuration * 12000.0f + 12000.0f));
                }
            } else {
                this.assignTime(world.func_72820_D());
            }
            this.lastWorldTime = world.func_72820_D();
            this.lastTotalWorldTime = world.func_82737_E();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRenderNameTag(RenderLivingEvent.Specials.Pre event) {
        if (!OpticManager.CONFIG.renderPlayerNameTag && event.getEntity() instanceof EntityPlayer) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void renderTick(TickEvent.RenderTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (OpticManager.CONFIG.overrideBrightness) {
            if (event.phase == TickEvent.Phase.START) {
                defaultGammaSetting = mc.field_71474_y.field_74333_Y;
                mc.field_71474_y.field_74333_Y = OpticManager.CONFIG.getRealBrightness();
            } else {
                mc.field_71474_y.field_74333_Y = defaultGammaSetting;
            }
        }
        if (event.phase == TickEvent.Phase.END) {
            mc.field_71474_y.field_74343_n = OpticManager.CONFIG.visibility;
        }
    }
}

