/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.opticmanager;

import com.creativemd.igcm.api.ConfigBranch;
import com.creativemd.igcm.api.ConfigElement;
import com.creativemd.igcm.api.segments.BooleanSegment;
import com.creativemd.igcm.api.segments.FloatSliderSegment;
import com.creativemd.igcm.api.segments.IntegerSegment;
import com.creativemd.igcm.api.segments.SelectSegment;
import com.creativemd.opticmanager.OpticManager;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class OpticManagerBranch
extends ConfigBranch {
    public OpticManagerBranch() {
        super("Optic", new ItemStack(Items.field_151113_aN));
    }

    @SideOnly(value=Side.CLIENT)
    public void receiveClient() {
        Minecraft.func_71410_x().field_71474_y.field_74343_n = EntityPlayer.EnumChatVisibility.func_151426_a((int)OpticManager.visibility);
    }

    public void createChildren() {
        this.registerElement("nametag", (ConfigElement)new BooleanSegment("Show Player Nametag", Boolean.valueOf(false)));
        this.registerElement("overrideBrightness", (ConfigElement)new BooleanSegment("Override Brightness", Boolean.valueOf(true)));
        this.registerElement("brightness", (ConfigElement)new FloatSliderSegment("Brightness", Float.valueOf(0.0f), -1.0f, 1.0f));
        this.registerElement("chat", (ConfigElement)new SelectSegment("Chat Visibilty", 0, new String[]{"Shown", "Only Commands", "Hidden"}));
        this.registerElement("dayDuration", (ConfigElement)new IntegerSegment("Day duration", Integer.valueOf(12000), 1, Integer.MAX_VALUE));
        this.registerElement("nightDuration", (ConfigElement)new IntegerSegment("Night duration", Integer.valueOf(12000), 1, Integer.MAX_VALUE));
        this.registerElement("dayBrightness", (ConfigElement)new FloatSliderSegment("Sunlight Factor", Float.valueOf(1.0f), 0.0f, 1.0f).setToolTip(new String[]{"Will be used in calculating light value.", "Will effect monster spawning."}));
        this.registerElement("nightBrightness", (ConfigElement)new FloatSliderSegment("Moonlight Factor", Float.valueOf(0.0f), 0.0f, 1.0f).setToolTip(new String[]{"Will be used in calculating light value.", "Will effect monster spawning."}));
        this.registerElement("dayBrightnessClient", (ConfigElement)new FloatSliderSegment("Sunlight Brightness", Float.valueOf(1.0f), 0.0f, 1.0f).setToolTip(new String[]{"Client side only", "Does not effect monster spawning."}));
        this.registerElement("nightBrightnessClient", (ConfigElement)new FloatSliderSegment("Moonlight Brightness", Float.valueOf(0.2f), 0.0f, 1.0f).setToolTip(new String[]{"Client side only", "Does not effect monster spawning."}));
    }

    public boolean requiresSynchronization() {
        return true;
    }

    public void onRecieveFrom(Side side) {
        OpticManager.renderPlayerNameTag = (Boolean)this.getValue("nametag");
        OpticManager.overrideBrightness = (Boolean)this.getValue("overrideBrightness");
        OpticManager.brightness = ((Float)this.getValue("brightness")).floatValue();
        if (OpticManager.brightness > 0.0f) {
            OpticManager.brightness += 1.0f;
        }
        OpticManager.visibility = ((SelectSegment)this.getChildByKey("chat")).getIndex();
        OpticManager.setDuration((int)((Integer)this.getValue("dayDuration")), (int)((Integer)this.getValue("nightDuration")));
        OpticManager.dayBrightness = ((Float)this.getValue("dayBrightness")).floatValue();
        OpticManager.nightBrightness = ((Float)this.getValue("nightBrightness")).floatValue();
        OpticManager.dayBrightnessClient = ((Float)this.getValue("dayBrightnessClient")).floatValue();
        OpticManager.nightBrightnessClient = ((Float)this.getValue("nightBrightnessClient")).floatValue();
        if (side.isClient()) {
            this.receiveClient();
        }
    }

    public void loadExtra(NBTTagCompound nbt) {
    }

    public void saveExtra(NBTTagCompound nbt) {
    }
}

