/*
 * Decompiled with CFR 0.152.
 */
package team.creative.opticmanager;

import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.world.DimensionType;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import team.creative.opticmanager.OpticManager;

public class OpticEventHandler {
    public static final long vanillaDuration = 24000L;
    public static final long vanillaHalfDuration = 12000L;
    public long lastWorldTime = -1L;
    public long lastTotalWorldTime = -1L;
    public long realWorldTime;
    @OnlyIn(value=Dist.CLIENT)
    public long lastWorldTimeClient;
    @OnlyIn(value=Dist.CLIENT)
    public long lastTotalWorldTimeClient;
    @OnlyIn(value=Dist.CLIENT)
    public long realWorldTimeClient;
    public static double defaultGammaSetting;

    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        this.lastWorldTimeClient = -1L;
        this.lastTotalWorldTimeClient = -1L;
    }

    public void assignTime(long worldTime) {
        long days = worldTime / 24000L;
        this.realWorldTime = days * (long)OpticManager.CONFIG.getTotalDayDuration();
        this.realWorldTime = this.isDayVanilla(worldTime) ? (this.realWorldTime += (long)((float)(worldTime % 24000L) / 12000.0f * (float)OpticManager.CONFIG.dayDuration)) : (this.realWorldTime += (long)((float)(worldTime % 24000L - 12000L) / 12000.0f * (float)OpticManager.CONFIG.nightDuration + (float)OpticManager.CONFIG.dayDuration));
    }

    public boolean isDayVanilla(long time) {
        return this.isDay(time, 12000L, 12000L);
    }

    public boolean isDay(long time, long dayDuration, long nightDuration) {
        return time % (dayDuration + nightDuration) <= dayDuration;
    }

    public boolean shouldAffectWorld(World world) {
        return world.func_234923_W_().func_240901_a_().equals((Object)DimensionType.field_235999_c_.func_240901_a_()) && world.func_82736_K().func_223586_b(GameRules.field_223607_j);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void tick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.END && mc.field_71441_e != null) {
            this.changeTick((World)mc.field_71441_e);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void assignTimeClient(long worldTime) {
        long days = worldTime / 24000L;
        this.realWorldTimeClient = days * (long)OpticManager.CONFIG.getTotalDayDuration();
        this.realWorldTimeClient = this.isDayVanilla(worldTime) ? (this.realWorldTimeClient += (long)((float)(worldTime % 24000L) / 12000.0f * (float)OpticManager.CONFIG.dayDuration)) : (this.realWorldTimeClient += (long)((float)(worldTime % 24000L - 12000L) / 12000.0f * (float)OpticManager.CONFIG.nightDuration + (float)OpticManager.CONFIG.dayDuration));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void changeTick(World world) {
        if (!this.shouldAffectWorld(world)) {
            return;
        }
        long expectedWorldTime = this.lastWorldTimeClient + 1L;
        if (expectedWorldTime == world.func_72820_D()) {
            ++this.realWorldTimeClient;
            int days = (int)(this.realWorldTimeClient / (long)OpticManager.CONFIG.getTotalDayDuration());
            if (this.isDay(this.realWorldTimeClient, OpticManager.CONFIG.dayDuration, OpticManager.CONFIG.nightDuration)) {
                ((ClientWorld)world).func_72877_b((long)days * 24000L + (long)((float)(this.realWorldTimeClient % (long)OpticManager.CONFIG.getTotalDayDuration()) / (float)OpticManager.CONFIG.dayDuration * 12000.0f));
            } else {
                ((ClientWorld)world).func_72877_b((long)((float)((long)days * 24000L) + (float)(this.realWorldTimeClient % (long)OpticManager.CONFIG.getTotalDayDuration() - (long)OpticManager.CONFIG.dayDuration) / (float)OpticManager.CONFIG.nightDuration * 12000.0f + 12000.0f));
            }
            ((ClientWorld)world).func_239134_a_(world.func_82737_E() + expectedWorldTime - world.func_72820_D());
        } else {
            this.assignTimeClient(world.func_72820_D());
        }
        this.lastWorldTimeClient = world.func_72820_D();
        this.lastTotalWorldTimeClient = world.func_82737_E();
    }

    @SubscribeEvent
    public void tick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            World world = event.world;
            if (!this.shouldAffectWorld(world)) {
                return;
            }
            long expectedWorldTime = this.lastWorldTime + 1L;
            if (expectedWorldTime == world.func_72820_D()) {
                ++this.realWorldTime;
                int days = (int)(this.realWorldTime / (long)OpticManager.CONFIG.getTotalDayDuration());
                if (this.isDay(this.realWorldTime, OpticManager.CONFIG.dayDuration, OpticManager.CONFIG.nightDuration)) {
                    ((ServerWorld)world).func_241114_a_((long)days * 24000L + (long)((float)(this.realWorldTime % (long)OpticManager.CONFIG.getTotalDayDuration()) / (float)OpticManager.CONFIG.dayDuration * 12000.0f));
                } else {
                    ((ServerWorld)world).func_241114_a_((long)((float)((long)days * 24000L) + (float)(this.realWorldTime % (long)OpticManager.CONFIG.getTotalDayDuration() - (long)OpticManager.CONFIG.dayDuration) / (float)OpticManager.CONFIG.nightDuration * 12000.0f + 12000.0f));
                }
            } else {
                this.assignTime(world.func_72820_D());
            }
            this.lastWorldTime = world.func_72820_D();
            this.lastTotalWorldTime = world.func_82737_E();
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void renderTick(TickEvent.RenderTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (OpticManager.CONFIG.overrideBrightness) {
            if (event.phase == TickEvent.Phase.START) {
                defaultGammaSetting = mc.field_71474_y.field_74333_Y;
                mc.field_71474_y.field_74333_Y = OpticManager.CONFIG.getRealBrightness();
            } else {
                mc.field_71474_y.field_74333_Y = defaultGammaSetting;
            }
        }
        if (event.phase == TickEvent.Phase.END) {
            mc.field_71474_y.field_74343_n = OpticManager.CONFIG.visibility;
        }
    }

    public static boolean shouldHideNames(Entity entity) {
        return !OpticManager.CONFIG.renderPlayerNameTag && entity instanceof PlayerEntity;
    }
}

