/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.pickletweaks.feature.crafting;

import com.blakebr0.pickletweaks.PickleTweaks;
import com.blakebr0.pickletweaks.config.ModConfigs;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class GridRepairOverrides {
    private static final List<Override> OVERRIDES = new ArrayList<Override>();

    public static void onCommonSetup() {
        List values = (List)ModConfigs.GRID_REPAIR_OVERRIDES.get();
        for (String value : values) {
            ItemStack mat;
            String[] parts = value.split("=");
            if (parts.length != 2) {
                PickleTweaks.LOGGER.error("Invalid repair material syntax: {}", (Object)value);
                continue;
            }
            double multi = 1.0;
            String[] toolName = parts[0].split(":");
            if (toolName.length != 2) {
                PickleTweaks.LOGGER.error("Invalid repair material syntax: {}", (Object)value);
                continue;
            }
            Item toolItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(toolName[0], toolName[1]));
            if (toolItem == null) {
                PickleTweaks.LOGGER.error("Invalid repair material syntax, tool item is null: {}", (Object)value);
                continue;
            }
            ItemStack tool = new ItemStack((ItemLike)toolItem);
            String[] matName = parts[1].split(":");
            if (matName.length == 3) {
                if (matName[2].contains("@")) {
                    matParts = matName[2].split("@");
                    try {
                        multi = Double.parseDouble(matParts[1]);
                    }
                    catch (NumberFormatException e) {
                        PickleTweaks.LOGGER.error("Invalid repair material multiplier: {}", (Object)value);
                        continue;
                    }
                }
                if (parts[1].startsWith("tag:")) {
                    String tag = parts[1].substring(4).split("@")[0];
                    OVERRIDES.add(new Override(tool, tag, multi));
                    continue;
                }
                matItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(parts[1].split("@")[0]));
                if (matItem == null) {
                    PickleTweaks.LOGGER.error("Invalid repair material syntax, material item is null: {}", (Object)value);
                    continue;
                }
                mat = new ItemStack((ItemLike)matItem, 1);
            } else if (matName.length == 2) {
                if (parts[1].contains("@")) {
                    matParts = parts[1].split("@");
                    try {
                        multi = Double.parseDouble(matParts[1]);
                    }
                    catch (NumberFormatException e) {
                        PickleTweaks.LOGGER.error("Invalid repair material multiplier: {}", (Object)value);
                        continue;
                    }
                }
                if ((matItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(parts[1].split("@")[0]))) == null) {
                    PickleTweaks.LOGGER.error("Invalid repair material syntax, material item is null: {}", (Object)value);
                    continue;
                }
                mat = new ItemStack((ItemLike)matItem);
            } else {
                PickleTweaks.LOGGER.error("Invalid repair material syntax, material item is invalid: {}", (Object)value);
                continue;
            }
            OVERRIDES.add(new Override(tool, mat, multi));
        }
    }

    public static Override getOverride(ItemStack tool, ItemStack material) {
        for (Override entry : OVERRIDES) {
            String tagId;
            TagKey tag;
            if (!entry.tool.m_150930_(tool.m_41720_())) continue;
            Object object = entry.material;
            if (object instanceof ItemStack) {
                ItemStack stack = (ItemStack)object;
                if (!stack.m_150930_(material.m_41720_())) continue;
                return entry;
            }
            object = entry.material;
            if (!(object instanceof String) || !material.m_204117_(tag = ItemTags.create((ResourceLocation)new ResourceLocation(tagId = (String)object)))) continue;
            return entry;
        }
        return null;
    }

    public static boolean hasToolOverride(ItemStack tool) {
        return OVERRIDES.stream().anyMatch(o -> o.tool.m_150930_(tool.m_41720_()));
    }

    public static class Override {
        public ItemStack tool;
        public Object material;
        public double multi;

        public Override(ItemStack tool, Object material) {
            this(tool, material, 1.0);
        }

        public Override(ItemStack tool, Object material, double multi) {
            this.tool = tool;
            this.material = material;
            this.multi = multi;
        }
    }
}

