/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.pickletweaks.feature.item;

import com.blakebr0.cucumber.helper.NBTHelper;
import com.blakebr0.cucumber.item.BaseItem;
import com.blakebr0.cucumber.util.Utils;
import com.blakebr0.pickletweaks.config.ModConfigs;
import com.blakebr0.pickletweaks.lib.ModTooltips;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.FakePlayer;

public class WateringCanItem
extends BaseItem {
    protected final int range;
    protected final double chance;

    public WateringCanItem(int range, double chance) {
        super(p -> p.m_41487_(1));
        this.range = range;
        this.chance = chance;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.NONE;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        FluidState fluid;
        ItemStack stack = player.m_21120_(hand);
        if (NBTHelper.getBoolean((ItemStack)stack, (String)"Water")) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        BlockHitResult trace = WateringCanItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (trace.m_6662_() != HitResult.Type.BLOCK) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        BlockPos pos = trace.m_82425_();
        Direction direction = trace.m_82434_();
        if (level.m_7966_(player, pos) && player.m_36204_(pos.m_121945_(direction), direction, stack) && (fluid = level.m_6425_(pos)).m_205070_(FluidTags.f_13131_)) {
            NBTHelper.setString((ItemStack)stack, (String)"ID", (String)UUID.randomUUID().toString());
            NBTHelper.setBoolean((ItemStack)stack, (String)"Water", (boolean)true);
            player.m_5496_(SoundEvents.f_11781_, 1.0f, 1.0f);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Direction direction;
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        if (!player.m_36204_(pos.m_121945_(direction = context.m_43719_()), direction, stack)) {
            return InteractionResult.FAIL;
        }
        if (!NBTHelper.getBoolean((ItemStack)stack, (String)"Water")) {
            return InteractionResult.PASS;
        }
        return this.doWater(stack, level, player, pos, direction);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag advanced) {
        if (NBTHelper.getBoolean((ItemStack)stack, (String)"Water")) {
            tooltip.add((Component)ModTooltips.FILLED.build());
        } else {
            tooltip.add((Component)ModTooltips.EMPTY.build());
        }
    }

    protected InteractionResult doWater(ItemStack stack, Level level, Player player, BlockPos pos, Direction direction) {
        if (player == null) {
            return InteractionResult.FAIL;
        }
        if (!player.m_36204_(pos.m_121945_(direction), direction, stack)) {
            return InteractionResult.FAIL;
        }
        if (!NBTHelper.getBoolean((ItemStack)stack, (String)"Water")) {
            return InteractionResult.PASS;
        }
        if (!((Boolean)ModConfigs.FAKE_PLAYER_WATERING.get()).booleanValue() && player instanceof FakePlayer) {
            return InteractionResult.PASS;
        }
        if (!level.m_5776_()) {
            Item item;
            ItemCooldowns cooldowns = player.m_36335_();
            if (!cooldowns.m_41519_(item = stack.m_41720_())) {
                cooldowns.m_41524_(item, WateringCanItem.getThrottleTicks(player));
            } else {
                return InteractionResult.PASS;
            }
        }
        int range = (this.range - 1) / 2;
        Stream blocks = BlockPos.m_121990_((BlockPos)pos.m_7918_(-range, -range, -range), (BlockPos)pos.m_7918_(range, range, range));
        blocks.forEach(aoePos -> {
            int moisture;
            BlockState aoeState = level.m_8055_(aoePos);
            if (aoeState.m_60734_() instanceof FarmBlock && (moisture = ((Integer)aoeState.m_61143_((Property)FarmBlock.f_53243_)).intValue()) < 7) {
                level.m_7731_(aoePos, (BlockState)aoeState.m_61124_((Property)FarmBlock.f_53243_, (Comparable)Integer.valueOf(7)), 3);
            }
        });
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                double d0 = (float)pos.m_7918_(x, 0, z).m_123341_() + level.m_213780_().m_188501_();
                double d1 = (double)pos.m_7918_(x, 0, z).m_123342_() + 1.0;
                double d2 = (float)pos.m_7918_(x, 0, z).m_123343_() + level.m_213780_().m_188501_();
                BlockState state = level.m_8055_(pos);
                if (state.m_60815_() || state.m_60734_() instanceof FarmBlock) {
                    d1 += 0.3;
                }
                level.m_7106_((ParticleOptions)ParticleTypes.f_123761_, d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
        if (!level.m_5776_() && Math.random() <= this.chance) {
            blocks = BlockPos.m_121990_((BlockPos)pos.m_7918_(-range, -range, -range), (BlockPos)pos.m_7918_(range, range, range));
            blocks.forEach(aoePos -> {
                BlockState state = level.m_8055_(aoePos);
                Block plantBlock = state.m_60734_();
                if (plantBlock instanceof BonemealableBlock || plantBlock instanceof IPlantable || plantBlock == Blocks.f_50195_ || plantBlock == Blocks.f_50491_) {
                    state.m_222972_((ServerLevel)level, aoePos, Utils.RANDOM);
                }
            });
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    private static int getThrottleTicks(Player player) {
        return player instanceof FakePlayer ? 10 : 5;
    }
}

