/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.block.AdvancedBeehive;
import cy.jdkdigital.productivebees.common.crafting.conditions.FluidTagEmptyCondition;
import cy.jdkdigital.productivebees.common.item.BeeCage;
import cy.jdkdigital.productivebees.handler.bee.CapabilityBee;
import cy.jdkdigital.productivebees.init.ModAdvancements;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModContainerTypes;
import cy.jdkdigital.productivebees.init.ModEntities;
import cy.jdkdigital.productivebees.init.ModFeatures;
import cy.jdkdigital.productivebees.init.ModFluids;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModParticles;
import cy.jdkdigital.productivebees.init.ModPointOfInterestTypes;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import cy.jdkdigital.productivebees.init.ModTileEntityTypes;
import cy.jdkdigital.productivebees.integrations.top.TopPlugin;
import cy.jdkdigital.productivebees.network.PacketHandler;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import cy.jdkdigital.productivebees.setup.ClientProxy;
import cy.jdkdigital.productivebees.setup.ClientSetup;
import cy.jdkdigital.productivebees.setup.IProxy;
import cy.jdkdigital.productivebees.setup.ServerProxy;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.dispenser.OptionalDispenseBehavior;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.ReplaceBlockConfig;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="productivebees")
@Mod.EventBusSubscriber(modid="productivebees")
public final class ProductiveBees {
    public static final String MODID = "productivebees";
    public static final Random rand = new Random();
    public static final IProxy proxy = (IProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> ServerProxy::new);
    public static final Logger LOGGER = LogManager.getLogger();

    public ProductiveBees() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.addListener(this::onServerStarting);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModPointOfInterestTypes.POINT_OF_INTEREST_TYPES.register(modEventBus);
        ModFluids.FLUIDS.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        ModBlocks.BLOCKS.register(modEventBus);
        ModEntities.HIVE_BEES.register(modEventBus);
        ModEntities.SOLITARY_BEES.register(modEventBus);
        ModEntities.ENTITIES.register(modEventBus);
        ModTileEntityTypes.TILE_ENTITY_TYPES.register(modEventBus);
        ModContainerTypes.CONTAINER_TYPES.register(modEventBus);
        ModFeatures.FEATURES.register(modEventBus);
        ModRecipeTypes.RECIPE_SERIALIZERS.register(modEventBus);
        ModParticles.PARTICLE_TYPES.register(modEventBus);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            modEventBus.addListener(ClientSetup::init);
            modEventBus.addListener(EventPriority.LOWEST, ClientSetup::registerItemColors);
            modEventBus.addListener(EventPriority.LOWEST, ClientSetup::registerBlockColors);
            modEventBus.addListener(EventPriority.LOWEST, ClientSetup::registerParticles);
        });
        modEventBus.addListener(this::onInterModEnqueue);
        modEventBus.addListener(this::onCommonSetup);
        modEventBus.addListener(this::onLoadComplete);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, ProductiveBeesConfig.SERVER_CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, ProductiveBeesConfig.CLIENT_CONFIG);
        CraftingHelper.register((IConditionSerializer)FluidTagEmptyCondition.Serializer.INSTANCE);
    }

    public void onInterModEnqueue(InterModEnqueueEvent event) {
        if (ModList.get().isLoaded("theoneprobe")) {
            InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", TopPlugin::new);
        }
    }

    public void onServerStarting(FMLServerAboutToStartEvent event) {
        IReloadableResourceManager manager = event.getServer().func_195570_aG();
        manager.func_219534_a((IFutureReloadListener)BeeReloadListener.INSTANCE);
    }

    public void onCommonSetup(FMLCommonSetupEvent event) {
        CapabilityBee.register();
        PacketHandler.init();
        ModAdvancements.register();
        OptionalDispenseBehavior cageDispensebehavior = new OptionalDispenseBehavior(){
            private final DefaultDispenseItemBehavior fallbackDispenseBehavior = new DefaultDispenseItemBehavior();

            public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                if (stack.func_77973_b() instanceof BeeCage && BeeCage.isFilled(stack)) {
                    Direction direction = (Direction)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a);
                    BeeEntity entity = BeeCage.getEntityFromStack(stack, source.func_197524_h(), true);
                    if (entity != null) {
                        entity.field_226369_bI_ = null;
                        BlockPos spawnPos = source.func_180699_d().func_177972_a(direction);
                        entity.func_70080_a((double)spawnPos.func_177958_n() + 0.5, (double)spawnPos.func_177956_o(), (double)spawnPos.func_177952_p() + 0.5, 0.0f, 0.0f);
                        if (source.func_197524_h().func_217376_c((Entity)entity) && stack.func_77973_b().equals(ModItems.BEE_CAGE.get())) {
                            stack.func_190918_g(1);
                        }
                        return stack;
                    }
                }
                return this.fallbackDispenseBehavior.dispense(source, stack);
            }
        };
        DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)ModItems.BEE_CAGE.get()), (IDispenseItemBehavior)cageDispensebehavior);
        DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)ModItems.STURDY_BEE_CAGE.get()), (IDispenseItemBehavior)cageDispensebehavior);
        this.fixPOI(event);
    }

    public void onLoadComplete(FMLLoadCompleteEvent event) {
        DeferredWorkQueue.runLater(() -> {
            for (Biome biome : ForgeRegistries.BIOMES) {
                Biome.Category category = biome.func_201856_r();
                if (category.equals((Object)Biome.Category.DESERT)) {
                    biome.func_203611_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, ((Feature)ModFeatures.SAND_NEST.get()).func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_150354_m.func_176223_P(), ((Block)ModBlocks.SAND_NEST.get()).func_176223_P())));
                } else if (category.equals((Object)Biome.Category.SAVANNA) || category.equals((Object)Biome.Category.TAIGA)) {
                    biome.func_203611_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, ((Feature)ModFeatures.COARSE_DIRT_NEST.get()).func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_196660_k.func_176223_P(), ((Block)ModBlocks.COARSE_DIRT_NEST.get()).func_176223_P())));
                    biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((Feature)ModFeatures.SPRUCE_WOOD_NEST_FEATURE.get()).func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_196618_L.func_176223_P(), ((Block)ModBlocks.SPRUCE_WOOD_NEST.get()).func_176223_P())));
                    biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((Feature)ModFeatures.ACACIA_WOOD_NEST_FEATURE.get()).func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_196621_O.func_176223_P(), ((Block)ModBlocks.ACACIA_WOOD_NEST.get()).func_176223_P())));
                } else if (category.equals((Object)Biome.Category.JUNGLE)) {
                    biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((Feature)ModFeatures.JUNGLE_WOOD_NEST_FEATURE.get()).func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_196620_N.func_176223_P(), ((Block)ModBlocks.JUNGLE_WOOD_NEST.get()).func_176223_P())));
                } else if (category.equals((Object)Biome.Category.FOREST)) {
                    biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((Feature)ModFeatures.OAK_WOOD_NEST_FEATURE.get()).func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_196617_K.func_176223_P(), ((Block)ModBlocks.OAK_WOOD_NEST.get()).func_176223_P())));
                    biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((Feature)ModFeatures.DARK_OAK_WOOD_NEST_FEATURE.get()).func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_196623_P.func_176223_P(), ((Block)ModBlocks.DARK_OAK_WOOD_NEST.get()).func_176223_P())));
                    biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((Feature)ModFeatures.BIRCH_WOOD_NEST_FEATURE.get()).func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_196619_M.func_176223_P(), ((Block)ModBlocks.BIRCH_WOOD_NEST.get()).func_176223_P())));
                } else if (category.equals((Object)Biome.Category.EXTREME_HILLS)) {
                    biome.func_203611_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, ((Feature)ModFeatures.STONE_NEST.get()).func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_150348_b.func_176223_P(), ((Block)ModBlocks.STONE_NEST.get()).func_176223_P())));
                    biome.func_203611_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, ((Feature)ModFeatures.SNOW_NEST.get()).func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_150433_aE.func_176223_P(), ((Block)ModBlocks.SNOW_NEST.get()).func_176223_P())));
                    biome.func_203611_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, ((Feature)ModFeatures.SNOW_NEST.get()).func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_196604_cC.func_176223_P(), ((Block)ModBlocks.SNOW_NEST.get()).func_176223_P())));
                } else if (category.equals((Object)Biome.Category.SWAMP)) {
                    biome.func_203611_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, ((Feature)ModFeatures.SLIMY_NEST.get()).func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_196658_i.func_176223_P(), ((Block)ModBlocks.SLIMY_NEST.get()).func_176223_P())));
                } else if (category.equals((Object)Biome.Category.PLAINS)) {
                    biome.func_203611_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, ((Feature)ModFeatures.BUMBLE_BEE_NEST.get()).func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_196658_i.func_176223_P(), ((Block)ModBlocks.BUMBLEBEE_NEST.get()).func_176223_P())));
                } else if (category.equals((Object)Biome.Category.NETHER)) {
                    biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, ((Feature)ModFeatures.GLOWSTONE_NEST.get()).func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_150426_aN.func_176223_P(), ((Block)ModBlocks.GLOWSTONE_NEST.get()).func_176223_P())));
                    biome.func_203611_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, ((Feature)ModFeatures.NETHER_QUARTZ_NEST.get()).func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_196766_fg.func_176223_P(), ((Block)ModBlocks.NETHER_QUARTZ_NEST.get()).func_176223_P())));
                    biome.func_203611_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, ((Feature)ModFeatures.NETHER_QUARTZ_NEST_HIGH.get()).func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_196766_fg.func_176223_P(), ((Block)ModBlocks.NETHER_QUARTZ_NEST.get()).func_176223_P())));
                    biome.func_203611_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, ((Feature)ModFeatures.NETHER_FORTRESS_NEST.get()).func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_196653_dH.func_176223_P(), ((Block)ModBlocks.NETHER_BRICK_NEST.get()).func_176223_P())));
                    biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, ((Feature)ModFeatures.SOUL_SAND_NEST.get()).func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_150425_aM.func_176223_P(), ((Block)ModBlocks.SOUL_SAND_NEST.get()).func_176223_P())));
                } else if (category.equals((Object)Biome.Category.RIVER) || category.equals((Object)Biome.Category.BEACH)) {
                    if (biome.func_150561_m() != Biome.TempCategory.COLD) {
                        biome.func_203611_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, ((Feature)ModFeatures.GRAVEL_NEST.get()).func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_150351_n.func_176223_P(), ((Block)ModBlocks.GRAVEL_NEST.get()).func_176223_P())));
                    }
                } else if (category.equals((Object)Biome.Category.THEEND)) {
                    if (biome == Biomes.field_76779_k) {
                        biome.func_203611_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, ((Feature)ModFeatures.OBSIDIAN_PILLAR_NEST.get()).func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_150343_Z.func_176223_P(), ((Block)ModBlocks.OBSIDIAN_PILLAR_NEST.get()).func_176223_P())));
                    } else {
                        biome.func_203611_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, ((Feature)ModFeatures.END_NEST.get()).func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_150377_bs.func_176223_P(), ((Block)ModBlocks.END_NEST.get()).func_176223_P())));
                    }
                }
                if (category.equals((Object)Biome.Category.THEEND) || category.equals((Object)Biome.Category.NETHER)) continue;
                biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((Feature)ModFeatures.SUGAR_CANE_NEST.get()).func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_196608_cF.func_176223_P(), ((Block)ModBlocks.SUGAR_CANE_NEST.get()).func_176223_P())));
            }
        });
    }

    private void fixPOI(FMLCommonSetupEvent event) {
        for (RegistryObject poi : ModPointOfInterestTypes.POINT_OF_INTEREST_TYPES.getEntries()) {
            ModPointOfInterestTypes.fixPOITypeBlockStates((PointOfInterestType)poi.get());
        }
        PointOfInterestType.field_226356_s_.field_221075_w = this.makePOIStatesMutable(PointOfInterestType.field_226356_s_.field_221075_w);
        ImmutableList BEEHIVES = (ImmutableList)ForgeRegistries.BLOCKS.getValues().stream().filter(block -> block instanceof AdvancedBeehive).collect(ImmutableList.toImmutableList());
        for (Block block2 : BEEHIVES) {
            for (BlockState state : block2.func_176194_O().func_177619_a()) {
                PointOfInterestType.field_221073_u.put(state, PointOfInterestType.field_226356_s_);
                try {
                    PointOfInterestType.field_226356_s_.field_221075_w.add(state);
                }
                catch (Exception e) {
                    LOGGER.warn("Could not add blockstate to beehive POI " + state);
                }
            }
        }
    }

    private Set<BlockState> makePOIStatesMutable(Set<BlockState> toCopy) {
        HashSet copy = Sets.newHashSet();
        copy.addAll(toCopy);
        return copy;
    }
}

