/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.client.render.entity;

import cy.jdkdigital.productivebees.client.render.entity.ProductiveBeeRenderer;
import cy.jdkdigital.productivebees.client.render.entity.model.ProductiveBeeModel;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBeeEntity;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.util.ResourceLocation;

public class DyeBeeRenderer
extends ProductiveBeeRenderer {
    public DyeBeeRenderer(EntityRendererManager renderManagerIn, ProductiveBeeModel<ProductiveBeeEntity> model) {
        super(renderManagerIn, model);
    }

    public DyeBeeRenderer(EntityRendererManager renderManagerIn) {
        this(renderManagerIn, new ProductiveBeeModel<ProductiveBeeEntity>("default"));
    }

    @Override
    @Nonnull
    public ResourceLocation getEntityTexture(ProductiveBeeEntity bee) {
        int num = bee.getRenderStatic() ? 1 : this.sum(bee.func_145782_y(), 3);
        String beeLocation = "textures/entity/bee/" + bee.getBeeName() + "/" + num + "/bee";
        if (bee.func_226427_ez_()) {
            beeLocation = beeLocation + "_angry";
        }
        if (bee.func_226411_eD_()) {
            beeLocation = beeLocation + "_nectar";
        }
        return new ResourceLocation("productivebees", beeLocation + ".png");
    }

    private int sum(int num, int max) {
        double sum = 0.0;
        while (num > 0) {
            sum += (double)(num % 10);
            num /= 10;
        }
        return sum > 9.0 ? this.sum((int)sum, max) : (int)Math.ceil(sum / (double)max);
    }
}

