/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.client.render.entity;

import cy.jdkdigital.productivebees.client.render.entity.layers.BeeBodyLayer;
import cy.jdkdigital.productivebees.client.render.entity.model.ProductiveBeeModel;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBeeEntity;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBeeEntity;
import java.util.Calendar;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;

public class ProductiveBeeRenderer
extends MobRenderer<ProductiveBeeEntity, ProductiveBeeModel<ProductiveBeeEntity>> {
    private boolean isChristmas;

    public ProductiveBeeRenderer(EntityRendererManager renderManagerIn, ProductiveBeeModel<ProductiveBeeEntity> model) {
        super(renderManagerIn, model, 0.7f);
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(2) + 1 == 12 && calendar.get(5) >= 21 && calendar.get(5) <= 26) {
            this.isChristmas = true;
        }
    }

    public ProductiveBeeRenderer(EntityRendererManager renderManagerIn) {
        this(renderManagerIn, new ProductiveBeeModel<ProductiveBeeEntity>());
        this.func_177094_a(new BeeBodyLayer((IEntityRenderer<ProductiveBeeEntity, ProductiveBeeModel<ProductiveBeeEntity>>)this, "thicc", this.isChristmas));
        this.func_177094_a(new BeeBodyLayer((IEntityRenderer<ProductiveBeeEntity, ProductiveBeeModel<ProductiveBeeEntity>>)this, "default", this.isChristmas));
        this.func_177094_a(new BeeBodyLayer((IEntityRenderer<ProductiveBeeEntity, ProductiveBeeModel<ProductiveBeeEntity>>)this, "default_crystal", this.isChristmas));
        this.func_177094_a(new BeeBodyLayer((IEntityRenderer<ProductiveBeeEntity, ProductiveBeeModel<ProductiveBeeEntity>>)this, "default_shell", this.isChristmas));
        this.func_177094_a(new BeeBodyLayer((IEntityRenderer<ProductiveBeeEntity, ProductiveBeeModel<ProductiveBeeEntity>>)this, "default_foliage", this.isChristmas));
        this.func_177094_a(new BeeBodyLayer((IEntityRenderer<ProductiveBeeEntity, ProductiveBeeModel<ProductiveBeeEntity>>)this, "small", this.isChristmas));
        this.func_177094_a(new BeeBodyLayer((IEntityRenderer<ProductiveBeeEntity, ProductiveBeeModel<ProductiveBeeEntity>>)this, "slim", this.isChristmas));
        this.func_177094_a(new BeeBodyLayer((IEntityRenderer<ProductiveBeeEntity, ProductiveBeeModel<ProductiveBeeEntity>>)this, "tiny", this.isChristmas));
        this.func_177094_a(new BeeBodyLayer((IEntityRenderer<ProductiveBeeEntity, ProductiveBeeModel<ProductiveBeeEntity>>)this, "translucent_with_center", this.isChristmas));
    }

    @Nullable
    protected RenderType func_230042_a_(ProductiveBeeEntity bee, boolean b1, boolean b2) {
        if (bee instanceof ConfigurableBeeEntity && ((ConfigurableBeeEntity)bee).isTranslucent()) {
            return RenderType.func_228644_e_((ResourceLocation)this.getEntityTexture(bee));
        }
        return super.func_230042_a_((LivingEntity)bee, b1, b2);
    }

    @Nonnull
    public ResourceLocation getEntityTexture(ProductiveBeeEntity bee) {
        String textureLocation = "productivebees:textures/entity/bee/" + bee.getBeeName() + "/bee";
        if (bee.getColor(0) != null) {
            String modelType = bee.getRenderer();
            textureLocation = "productivebees:textures/entity/bee/base/" + modelType + "/bee";
        }
        if (bee instanceof ConfigurableBeeEntity && ((ConfigurableBeeEntity)bee).hasBeeTexture()) {
            textureLocation = ((ConfigurableBeeEntity)bee).getBeeTexture();
        }
        if (bee.func_226427_ez_()) {
            textureLocation = textureLocation + "_angry";
        }
        if (bee.func_226411_eD_()) {
            textureLocation = textureLocation + "_nectar";
        }
        return new ResourceLocation(textureLocation + ".png");
    }
}

