/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.client.render.entity.layers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import cy.jdkdigital.productivebees.client.render.entity.model.ProductiveBeeModel;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBeeEntity;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBeeEntity;
import cy.jdkdigital.productivebees.common.entity.bee.solitary.BumbleBeeEntity;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;

public class BeeBodyLayer
extends LayerRenderer<ProductiveBeeEntity, ProductiveBeeModel<ProductiveBeeEntity>> {
    private final String modelType;
    private final EntityModel<ProductiveBeeEntity> model;
    private boolean isChristmas;
    private Map<String, ResourceLocation> resLocCache = new HashMap<String, ResourceLocation>();

    public BeeBodyLayer(IEntityRenderer<ProductiveBeeEntity, ProductiveBeeModel<ProductiveBeeEntity>> rendererIn, String modelType, boolean isChristmas) {
        super(rendererIn);
        this.modelType = modelType;
        this.model = new ProductiveBeeModel(modelType);
        this.isChristmas = isChristmas;
    }

    public void render(@Nonnull MatrixStack matrixStackIn, @Nonnull IRenderTypeBuffer bufferIn, int packedLightIn, @Nonnull ProductiveBeeEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity.getRenderer().equals(this.modelType) && !entity.func_82150_aj()) {
            ((ProductiveBeeModel)this.func_215332_c()).func_217111_a(this.model);
            this.model.func_212843_a_((Entity)entity, limbSwing, limbSwingAmount, partialTicks);
            this.model.func_225597_a_((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            if (entity instanceof ConfigurableBeeEntity && ((ConfigurableBeeEntity)entity).isTranslucent()) {
                IVertexBuilder vertexBuilder = bufferIn.getBuffer(RenderType.func_228644_e_((ResourceLocation)this.func_229139_a_((Entity)entity)));
                this.model.func_225598_a_(matrixStackIn, vertexBuilder, packedLightIn, LivingRenderer.func_229117_c_((LivingEntity)entity, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
            } else {
                BeeBodyLayer.func_229141_a_(this.model, (ResourceLocation)this.func_229139_a_((Entity)entity), (MatrixStack)matrixStackIn, (IRenderTypeBuffer)bufferIn, (int)packedLightIn, (LivingEntity)entity, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            if (entity.getColor(0) != null) {
                if (entity instanceof ConfigurableBeeEntity && ((ConfigurableBeeEntity)entity).hasBeeTexture()) {
                    return;
                }
                this.renderColoredLayers(matrixStackIn, bufferIn, packedLightIn, entity);
            }
            if (entity.func_226411_eD_()) {
                this.renderNectarLayer(matrixStackIn, bufferIn, packedLightIn, entity);
            }
            this.renderChristmasHat(matrixStackIn, bufferIn, packedLightIn, entity);
            this.renderSaddle(matrixStackIn, bufferIn, packedLightIn, entity);
        }
    }

    private void renderColoredLayers(@Nonnull MatrixStack matrixStackIn, @Nonnull IRenderTypeBuffer bufferIn, int packedLightIn, @Nonnull ProductiveBeeEntity entity) {
        float[] primaryColor = entity.getColor(0).getComponents(null);
        ResourceLocation location = this.resLoc("textures/entity/bee/base/" + this.modelType + "/primary.png");
        BeeBodyLayer.func_229141_a_(this.model, (ResourceLocation)location, (MatrixStack)matrixStackIn, (IRenderTypeBuffer)bufferIn, (int)packedLightIn, (LivingEntity)entity, (float)primaryColor[0], (float)primaryColor[1], (float)primaryColor[2]);
        float[] secondaryColor = entity.getColor(1).getComponents(null);
        ResourceLocation abdomenLocation = this.resLoc("textures/entity/bee/base/" + this.modelType + "/abdomen.png");
        BeeBodyLayer.func_229141_a_(this.model, (ResourceLocation)abdomenLocation, (MatrixStack)matrixStackIn, (IRenderTypeBuffer)bufferIn, (int)packedLightIn, (LivingEntity)entity, (float)secondaryColor[0], (float)secondaryColor[1], (float)secondaryColor[2]);
        if (this.modelType.equals("default_crystal")) {
            float[] color = primaryColor;
            if (entity instanceof ConfigurableBeeEntity) {
                color = ((ConfigurableBeeEntity)entity).getTertiaryColor();
            }
            ResourceLocation crystalsLocation = this.resLoc("textures/entity/bee/base/" + this.modelType + "/crystals_clear.png");
            BeeBodyLayer.func_229141_a_(this.model, (ResourceLocation)crystalsLocation, (MatrixStack)matrixStackIn, (IRenderTypeBuffer)bufferIn, (int)packedLightIn, (LivingEntity)entity, (float)color[0], (float)color[1], (float)color[2]);
            if (!entity.getRenderStatic()) {
                ResourceLocation crystalsOverlayLocation = this.resLoc("textures/entity/bee/base/" + this.modelType + "/crystals.png");
                IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228652_i_((ResourceLocation)crystalsOverlayLocation));
                this.model.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, color[0], color[1], color[2], 1.0f);
            }
        } else if (this.modelType.equals("default_foliage") || this.modelType.equals("default_shell")) {
            float[] color = primaryColor;
            if (entity instanceof ConfigurableBeeEntity) {
                color = ((ConfigurableBeeEntity)entity).getTertiaryColor();
            }
            ResourceLocation foliageLocation = this.resLoc("textures/entity/bee/base/" + this.modelType + "/crystals.png");
            BeeBodyLayer.func_229141_a_(this.model, (ResourceLocation)foliageLocation, (MatrixStack)matrixStackIn, (IRenderTypeBuffer)bufferIn, (int)packedLightIn, (LivingEntity)entity, (float)color[0], (float)color[1], (float)color[2]);
        }
    }

    private void renderNectarLayer(@Nonnull MatrixStack matrixStackIn, @Nonnull IRenderTypeBuffer bufferIn, int packedLightIn, @Nonnull ProductiveBeeEntity entity) {
        if (entity.getColor(0) != null) {
            float[] colors = new float[]{1.0f, 1.0f, 1.0f};
            if (entity instanceof ConfigurableBeeEntity) {
                if (((ConfigurableBeeEntity)entity).hasBeeTexture()) {
                    return;
                }
                if (((ConfigurableBeeEntity)entity).hasParticleColor()) {
                    colors = ((ConfigurableBeeEntity)entity).getParticleColor();
                }
            }
            ResourceLocation location = this.resLoc("textures/entity/bee/base/" + this.modelType + "/pollen.png");
            BeeBodyLayer.func_229141_a_(this.model, (ResourceLocation)location, (MatrixStack)matrixStackIn, (IRenderTypeBuffer)bufferIn, (int)packedLightIn, (LivingEntity)entity, (float)colors[0], (float)colors[1], (float)colors[2]);
        }
    }

    private void renderChristmasHat(@Nonnull MatrixStack matrixStackIn, @Nonnull IRenderTypeBuffer bufferIn, int packedLightIn, @Nonnull ProductiveBeeEntity entity) {
        if (this.isChristmas && entity.getColor(0) != null && !entity.getRenderStatic()) {
            if (entity instanceof ConfigurableBeeEntity && ((ConfigurableBeeEntity)entity).hasBeeTexture()) {
                return;
            }
            ResourceLocation location = this.resLoc("textures/entity/bee/base/" + this.modelType + "/santa_hat.png");
            BeeBodyLayer.func_229141_a_(this.model, (ResourceLocation)location, (MatrixStack)matrixStackIn, (IRenderTypeBuffer)bufferIn, (int)packedLightIn, (LivingEntity)entity, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private void renderSaddle(@Nonnull MatrixStack matrixStackIn, @Nonnull IRenderTypeBuffer bufferIn, int packedLightIn, @Nonnull ProductiveBeeEntity entity) {
        if (entity instanceof BumbleBeeEntity && ((BumbleBeeEntity)entity).getSaddled()) {
            ResourceLocation location = this.resLoc("textures/entity/bee/bumble/saddle.png");
            BeeBodyLayer.func_229141_a_(this.model, (ResourceLocation)location, (MatrixStack)matrixStackIn, (IRenderTypeBuffer)bufferIn, (int)packedLightIn, (LivingEntity)entity, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private ResourceLocation resLoc(String key) {
        if (!this.resLocCache.containsKey(key)) {
            this.resLocCache.put(key, new ResourceLocation("productivebees", key));
        }
        return this.resLocCache.get(key);
    }
}

