/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.client.render.entity.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import cy.jdkdigital.productivebees.client.render.entity.model.MediumBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.MediumCrystalBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.MediumFoliageBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.MediumShellBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.PartialBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.SlimBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.SlimyBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.SmallBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.ThiccBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.TinyBeeModel;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBeeEntity;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBeeEntity;
import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.client.renderer.entity.model.ModelUtils;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;

public class ProductiveBeeModel<T extends ProductiveBeeEntity>
extends AgeableModel<T> {
    protected float FAKE_PI = (float)Math.PI;
    protected ModelRenderer body;
    protected ModelRenderer torso;
    protected ModelRenderer rightWing;
    protected ModelRenderer leftWing;
    protected ModelRenderer frontLegs;
    protected ModelRenderer middleLegs;
    protected ModelRenderer backLegs;
    protected ModelRenderer stinger;
    protected ModelRenderer leftAntenna;
    protected ModelRenderer rightAntenna;
    protected ModelRenderer crystals;
    protected ModelRenderer innards;
    protected ModelRenderer santaHat;
    protected float bodyPitch;
    public float beeSize = 1.0f;

    public ProductiveBeeModel() {
        this(false, 24.0f, 0.0f);
    }

    public ProductiveBeeModel(boolean isChildHeadScaled, float childHeadOffsetY, float childHeadOffsetZ) {
        super(isChildHeadScaled, childHeadOffsetY, childHeadOffsetZ);
        this.field_78090_t = 64;
        this.field_78089_u = 64;
        this.body = new ModelRenderer((Model)this);
        this.torso = new ModelRenderer((Model)this);
        this.stinger = new ModelRenderer((Model)this);
        this.leftAntenna = new ModelRenderer((Model)this);
        this.rightAntenna = new ModelRenderer((Model)this);
        this.rightWing = new ModelRenderer((Model)this);
        this.leftWing = new ModelRenderer((Model)this);
        this.middleLegs = new ModelRenderer((Model)this);
        this.frontLegs = new ModelRenderer((Model)this);
        this.backLegs = new ModelRenderer((Model)this);
        this.crystals = new ModelRenderer((Model)this);
        this.innards = new ModelRenderer((Model)this);
        this.santaHat = new ModelRenderer((Model)this);
    }

    public ProductiveBeeModel(String modelType) {
        this(false, 24.0f, 0.0f);
        PartialBeeModel partialModel;
        switch (modelType) {
            case "thicc": {
                partialModel = new ThiccBeeModel((Model)this, this.body, this.torso, this.stinger, this.leftAntenna, this.rightAntenna, this.leftWing, this.rightWing, this.middleLegs, this.frontLegs, this.backLegs, this.crystals, this.innards, this.santaHat);
                break;
            }
            case "small": {
                partialModel = new SmallBeeModel((Model)this, this.body, this.torso, this.stinger, this.leftAntenna, this.rightAntenna, this.leftWing, this.rightWing, this.middleLegs, this.frontLegs, this.backLegs, this.crystals, this.innards, this.santaHat);
                break;
            }
            case "slim": {
                partialModel = new SlimBeeModel((Model)this, this.body, this.torso, this.stinger, this.leftAntenna, this.rightAntenna, this.leftWing, this.rightWing, this.middleLegs, this.frontLegs, this.backLegs, this.crystals, this.innards, this.santaHat);
                break;
            }
            case "tiny": {
                partialModel = new TinyBeeModel((Model)this, this.body, this.torso, this.stinger, this.leftAntenna, this.rightAntenna, this.leftWing, this.rightWing, this.middleLegs, this.frontLegs, this.backLegs, this.crystals, this.innards, this.santaHat);
                break;
            }
            case "default_shell": {
                partialModel = new MediumShellBeeModel((Model)this, this.body, this.torso, this.stinger, this.leftAntenna, this.rightAntenna, this.leftWing, this.rightWing, this.middleLegs, this.frontLegs, this.backLegs, this.crystals, this.innards, this.santaHat);
                break;
            }
            case "default_foliage": {
                partialModel = new MediumFoliageBeeModel((Model)this, this.body, this.torso, this.stinger, this.leftAntenna, this.rightAntenna, this.leftWing, this.rightWing, this.middleLegs, this.frontLegs, this.backLegs, this.crystals, this.innards, this.santaHat);
                break;
            }
            case "default_crystal": {
                partialModel = new MediumCrystalBeeModel((Model)this, this.body, this.torso, this.stinger, this.leftAntenna, this.rightAntenna, this.leftWing, this.rightWing, this.middleLegs, this.frontLegs, this.backLegs, this.crystals, this.innards, this.santaHat);
                break;
            }
            case "translucent_with_center": {
                partialModel = new SlimyBeeModel((Model)this, this.body, this.torso, this.stinger, this.leftAntenna, this.rightAntenna, this.leftWing, this.rightWing, this.middleLegs, this.frontLegs, this.backLegs, this.crystals, this.innards, this.santaHat);
                break;
            }
            default: {
                partialModel = new MediumBeeModel((Model)this, this.body, this.torso, this.stinger, this.leftAntenna, this.rightAntenna, this.leftWing, this.rightWing, this.middleLegs, this.frontLegs, this.backLegs, this.crystals, this.innards, this.santaHat);
            }
        }
        partialModel.addBodyParts(true);
    }

    public void setLivingAnimations(T entity, float limbSwing, float limbSwingAmount, float partialTicks) {
        super.func_212843_a_(entity, limbSwing, limbSwingAmount, partialTicks);
        this.bodyPitch = entity.func_226455_v_(partialTicks);
        boolean bl = this.stinger.field_78806_j = !entity.func_226412_eE_();
        if (entity instanceof ConfigurableBeeEntity && ((ConfigurableBeeEntity)entity).isStingless()) {
            this.stinger.field_78806_j = false;
        }
    }

    public void setRotationAngles(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean grounded;
        this.leftAntenna.field_78795_f = 0.0f;
        this.rightAntenna.field_78795_f = 0.0f;
        this.body.field_78795_f = 0.0f;
        this.body.field_78797_d = 19.0f;
        boolean bl = grounded = ((ProductiveBeeEntity)((Object)entity)).field_70122_E && entity.func_213322_ci().func_189985_c() < 1.0E-7;
        if (grounded) {
            this.setRotationAngle(this.rightWing, 0.0f, -0.2618f, 0.0f);
            this.setRotationAngle(this.leftWing, 0.0f, 0.2618f, 0.0f);
            this.frontLegs.field_78795_f = 0.0f;
            this.middleLegs.field_78795_f = 0.0f;
            this.backLegs.field_78795_f = 0.0f;
        } else {
            this.setRotationAngle(this.rightWing, 0.0f, 0.0f, MathHelper.func_76134_b((float)(ageInTicks % 98000.0f * 2.1f)) * this.FAKE_PI * 0.15f);
            this.setRotationAngle(this.leftWing, this.rightWing.field_78795_f, this.rightWing.field_78796_g, -this.rightWing.field_78808_h);
            this.frontLegs.field_78795_f = 0.7853982f;
            this.middleLegs.field_78795_f = 0.7853982f;
            this.backLegs.field_78795_f = 0.7853982f;
            this.setRotationAngle(this.body, 0.0f, 0.0f, 0.0f);
        }
        if (!((ProductiveBeeEntity)((Object)entity)).func_226427_ez_()) {
            this.body.field_78795_f = 0.0f;
            this.body.field_78796_g = 0.0f;
            this.body.field_78808_h = 0.0f;
            if (!grounded) {
                float angle = MathHelper.func_76134_b((float)(ageInTicks * 0.18f));
                this.body.field_78795_f = 0.1f + angle * this.FAKE_PI * 0.025f;
                this.leftAntenna.field_78795_f = angle * this.FAKE_PI * 0.03f;
                this.rightAntenna.field_78795_f = angle * this.FAKE_PI * 0.03f;
                this.frontLegs.field_78795_f = -angle * this.FAKE_PI * 0.1f + 0.3926991f;
                if (!((ProductiveBeeEntity)((Object)entity)).getRenderer().equals("thicc")) {
                    this.backLegs.field_78795_f = -angle * this.FAKE_PI * 0.05f + 0.7853982f;
                }
                this.body.field_78797_d = 19.0f - angle * 0.9f;
            }
        }
        if (this.bodyPitch > 0.0f) {
            this.body.field_78795_f = ModelUtils.func_228283_a_((float)this.body.field_78795_f, (float)3.0915928f, (float)this.bodyPitch);
        }
        this.beeSize = ((ProductiveBeeEntity)((Object)entity)).getSizeModifier();
        if (this.field_217114_e) {
            this.beeSize /= 2.0f;
        }
    }

    public ModelRenderer getBody() {
        return this.body;
    }

    protected Iterable<ModelRenderer> func_225602_a_() {
        return ImmutableList.of();
    }

    protected Iterable<ModelRenderer> func_225600_b_() {
        return ImmutableList.of((Object)this.body);
    }

    public void func_225598_a_(MatrixStack matrixStackIn, IVertexBuilder renderBuffer, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.0, 1.5 - (double)this.beeSize * 1.5, 0.0);
        matrixStackIn.func_227862_a_(this.beeSize, this.beeSize, this.beeSize);
        super.func_225598_a_(matrixStackIn, renderBuffer, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        matrixStackIn.func_227865_b_();
    }

    protected void addBodyParts(boolean withTorso) {
        MediumBeeModel partialModel = new MediumBeeModel((Model)this, this.body, this.torso, this.stinger, this.leftAntenna, this.rightAntenna, this.leftWing, this.rightWing, this.middleLegs, this.frontLegs, this.backLegs, this.crystals, this.innards, this.santaHat);
        partialModel.addBodyParts(withTorso);
    }

    public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }
}

