/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.client.render.ingredient;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBeeEntity;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBeeEntity;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class BeeRenderer {
    private static final Map<Integer, Map<String, Integer>> renderSettings = new HashMap<Integer, Map<String, Integer>>(){
        {
            this.put(0, new HashMap<String, Integer>(){
                {
                    this.put("scale", 128);
                    this.put("iconX", 14);
                    this.put("iconY", 14);
                    this.put("iconU", 20);
                    this.put("iconV", 20);
                }
            });
            this.put(1, new HashMap<String, Integer>(){
                {
                    this.put("scale", 128);
                    this.put("iconX", 12);
                    this.put("iconY", 12);
                    this.put("iconU", 20);
                    this.put("iconV", 20);
                }
            });
        }
    };
    private static HashMap<String, ResourceLocation> beeTextureLocations = new HashMap();
    private static HashMap<String, float[]> colorCache = new HashMap();

    public static void render(int xPosition, int yPosition, BeeIngredient beeIngredient, Minecraft minecraft) {
        if (((Boolean)ProductiveBeesConfig.CLIENT.renderBeeIngredientAsEntity.get()).booleanValue()) {
            BeeEntity bee = beeIngredient.getCachedEntity((World)minecraft.field_71441_e);
            if (minecraft.field_71439_g != null && bee != null) {
                if (bee instanceof ConfigurableBeeEntity) {
                    ((ConfigurableBeeEntity)bee).setBeeType(beeIngredient.getBeeType().toString());
                }
                if (bee instanceof ProductiveBeeEntity) {
                    ((ProductiveBeeEntity)bee).setRenderStatic();
                }
                bee.field_70173_aa = minecraft.field_71439_g.field_70173_aa;
                bee.field_70761_aq = -20.0f;
                float scaledSize = 18.0f;
                MatrixStack matrixStack = new MatrixStack();
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_((double)(7 + xPosition), (double)(12 + yPosition), 1.5);
                matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(190.0f));
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(20.0f));
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(20.0f));
                matrixStack.func_227861_a_(0.0, (double)-0.2f, 1.0);
                matrixStack.func_227862_a_(scaledSize, scaledSize, scaledSize);
                EntityRendererManager entityrenderermanager = minecraft.func_175598_ae();
                IRenderTypeBuffer.Impl buffer = minecraft.func_228019_au_().func_228487_b_();
                entityrenderermanager.func_229084_a_((Entity)bee, 0.0, 0.0, 0.0, minecraft.func_184121_ak(), 1.0f, matrixStack, (IRenderTypeBuffer)buffer, 0xF000F0);
                buffer.func_228461_a_();
                matrixStack.func_227865_b_();
            }
        } else {
            BeeRenderer.renderBeeFace(xPosition, yPosition, beeIngredient, (World)minecraft.field_71441_e);
        }
    }

    private static void renderBeeFace(int xPosition, int yPosition, BeeIngredient beeIngredient, World world) {
        RenderSystem.enableBlend();
        RenderSystem.enableAlphaTest();
        ResourceLocation resLocation = BeeRenderer.getBeeTexture(beeIngredient, world);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resLocation);
        Map<String, Integer> iconSettings = renderSettings.get(beeIngredient.getRenderType());
        float[] color = colorCache.get(beeIngredient.getBeeType().toString());
        float scale = 1.0f / (float)iconSettings.get("scale").intValue();
        int iconX = iconSettings.get("iconX");
        int iconY = iconSettings.get("iconY");
        int iconU = iconSettings.get("iconU");
        int iconV = iconSettings.get("iconV");
        if (color == null) {
            color = new float[]{1.0f, 1.0f, 1.0f};
        }
        RenderSystem.color4f((float)color[0], (float)color[1], (float)color[2], (float)1.0f);
        BufferBuilder renderBuffer = Tessellator.func_178181_a().func_178180_c();
        renderBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        renderBuffer.func_225582_a_((double)xPosition, (double)(yPosition + iconY), 0.0).func_225583_a_((float)iconU * scale, (float)(iconV + iconY) * scale).func_227885_a_(color[0], color[1], color[2], 1.0f).func_181675_d();
        renderBuffer.func_225582_a_((double)(xPosition + iconX), (double)(yPosition + iconY), 0.0).func_225583_a_((float)(iconU + iconX) * scale, (float)(iconV + iconY) * scale).func_227885_a_(color[0], color[1], color[2], 1.0f).func_181675_d();
        renderBuffer.func_225582_a_((double)(xPosition + iconX), (double)yPosition, 0.0).func_225583_a_((float)(iconU + iconX) * scale, (float)iconV * scale).func_227885_a_(color[0], color[1], color[2], 1.0f).func_181675_d();
        renderBuffer.func_225582_a_((double)xPosition, (double)yPosition, 0.0).func_225583_a_((float)iconU * scale, (float)iconV * scale).func_227885_a_(color[0], color[1], color[2], 1.0f).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableAlphaTest();
        RenderSystem.disableBlend();
    }

    public static ResourceLocation getBeeTexture(@Nonnull BeeIngredient ingredient, World world) {
        String beeId = ingredient.getBeeType().toString();
        if (beeTextureLocations.get(beeId) != null) {
            return beeTextureLocations.get(beeId);
        }
        Entity bee = ingredient.getBeeEntity().func_200721_a(world);
        if (bee instanceof ConfigurableBeeEntity) {
            ((ConfigurableBeeEntity)bee).setBeeType(ingredient.getBeeType().toString());
            colorCache.put(beeId, ((ConfigurableBeeEntity)bee).getColor(0).getComponents(null));
        }
        EntityRendererManager manager = Minecraft.func_71410_x().func_175598_ae();
        EntityRenderer renderer = manager.func_78713_a(bee);
        ResourceLocation resource = renderer.func_110775_a(bee);
        beeTextureLocations.put(beeId, resource);
        return beeTextureLocations.get(beeId);
    }
}

