/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block;

import cy.jdkdigital.productivebees.block.AdvancedBeehiveAbstract;
import cy.jdkdigital.productivebees.common.block.DragonEggHive;
import cy.jdkdigital.productivebees.common.block.ExpansionBox;
import cy.jdkdigital.productivebees.common.tileentity.AdvancedBeehiveTileEntity;
import cy.jdkdigital.productivebees.init.ModTileEntityTypes;
import cy.jdkdigital.productivebees.state.properties.VerticalHive;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class AdvancedBeehive
extends AdvancedBeehiveAbstract {
    public static final EnumProperty<VerticalHive> EXPANDED = EnumProperty.func_177709_a((String)"expanded", VerticalHive.class);

    public AdvancedBeehive(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)BeehiveBlock.field_226872_b_, (Comparable)Direction.NORTH)).func_206870_a(EXPANDED, (Comparable)((Object)VerticalHive.NONE))).func_206870_a((IProperty)BeehiveBlock.field_226873_c_, (Comparable)Integer.valueOf(0)));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)ModTileEntityTypes.ADVANCED_BEEHIVE.get()).func_200968_a();
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader world) {
        return new AdvancedBeehiveTileEntity();
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)BeehiveBlock.field_226872_b_, (Comparable)context.func_195992_f().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{EXPANDED, BeehiveBlock.field_226873_c_, BeehiveBlock.field_226872_b_});
    }

    public void updateState(World world, BlockPos pos, BlockState state, boolean isRemoved) {
        if (this instanceof DragonEggHive) {
            return;
        }
        Pair<Pair<BlockPos, Direction>, BlockState> pair = AdvancedBeehive.getAdjacentBox(world, pos);
        if (pair != null) {
            Pair posAndDirection = (Pair)pair.getLeft();
            BlockPos boxPos = (BlockPos)posAndDirection.getLeft();
            VerticalHive directionProperty = AdvancedBeehive.calculateExpandedDirection(world, pos, isRemoved);
            if (!isRemoved) {
                this.updateStateWithDirection(world, pos, state, directionProperty);
            }
            ((ExpansionBox)((BlockState)pair.getRight()).func_177230_c()).updateStateWithDirection(world, boxPos, (BlockState)pair.getRight(), directionProperty);
        }
    }

    public void updateStateWithDirection(World world, BlockPos pos, BlockState state, VerticalHive directionProperty) {
        world.func_180501_a(pos, (BlockState)state.func_206870_a(EXPANDED, (Comparable)((Object)directionProperty)), 3);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof AdvancedBeehiveTileEntity) {
            int n = ((AdvancedBeehiveTileEntity)te).MAX_BEES = world.func_180495_p(pos).func_177229_b(EXPANDED) != VerticalHive.NONE ? 5 : 3;
            if (directionProperty.equals((Object)VerticalHive.NONE)) {
                ((AdvancedBeehiveTileEntity)te).getUpgradeHandler().ifPresent(handler -> {
                    for (int slot = 0; slot < handler.getSlots(); ++slot) {
                        InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)handler.getStackInSlot(slot));
                    }
                });
            }
        }
    }

    public static Pair<Pair<BlockPos, Direction>, BlockState> getAdjacentBox(World world, BlockPos pos) {
        for (Direction direction : BlockStateProperties.field_208155_H.func_177700_c()) {
            BlockPos newPos;
            BlockState blockStateAtPos;
            Block blockAtPos;
            if (direction == Direction.DOWN || !((blockAtPos = (blockStateAtPos = world.func_180495_p(newPos = pos.func_177972_a(direction))).func_177230_c()) instanceof ExpansionBox)) continue;
            return Pair.of((Object)Pair.of((Object)newPos, (Object)direction), (Object)blockStateAtPos);
        }
        return null;
    }

    public static VerticalHive calculateExpandedDirection(World world, BlockPos pos, boolean isRemoved) {
        Pair<Pair<BlockPos, Direction>, BlockState> pair = AdvancedBeehive.getAdjacentBox(world, pos);
        VerticalHive directionProperty = VerticalHive.NONE;
        if (!isRemoved && pair != null) {
            boolean isValidExpandedPos;
            BlockState state = world.func_180495_p(pos);
            Direction hiveDirection = (Direction)state.func_177229_b((IProperty)BeehiveBlock.field_226872_b_);
            Direction boxDirection = (Direction)((Pair)pair.getLeft()).getRight();
            Pair posAndDirection = (Pair)pair.getLeft();
            BlockPos boxPos = (BlockPos)posAndDirection.getLeft();
            boolean bl = isValidExpandedPos = pos.func_177956_o() != boxPos.func_177956_o();
            if (!(isValidExpandedPos || hiveDirection != Direction.NORTH && hiveDirection != Direction.SOUTH)) {
                isValidExpandedPos = boxDirection == Direction.WEST || boxDirection == Direction.EAST;
            } else if (!(isValidExpandedPos || hiveDirection != Direction.WEST && hiveDirection != Direction.EAST)) {
                boolean bl2 = isValidExpandedPos = boxDirection == Direction.SOUTH || boxDirection == Direction.NORTH;
            }
            if (isValidExpandedPos) {
                directionProperty = pos.func_177956_o() != boxPos.func_177956_o() ? VerticalHive.UP : (pos.func_177958_n() < boxPos.func_177958_n() || pos.func_177952_p() < boxPos.func_177952_p() ? (hiveDirection == Direction.NORTH || hiveDirection == Direction.EAST ? VerticalHive.LEFT : VerticalHive.RIGHT) : (pos.func_177958_n() > boxPos.func_177958_n() || pos.func_177952_p() > boxPos.func_177952_p() ? (hiveDirection == Direction.NORTH || hiveDirection == Direction.EAST ? VerticalHive.RIGHT : VerticalHive.LEFT) : VerticalHive.NONE));
            }
        }
        return directionProperty;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        if (!world.func_201670_d()) {
            this.updateState(world, pos, state, false);
        }
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, IFluidState fluid) {
        boolean removed = super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
        if (!world.func_201670_d()) {
            this.updateState(world, pos, state, true);
        }
        return removed;
    }

    public void func_196243_a(BlockState oldState, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tileEntity;
        if (oldState.func_177230_c() != newState.func_177230_c() && (tileEntity = worldIn.func_175625_s(pos)) instanceof AdvancedBeehiveTileEntity) {
            tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
                for (int slot = 0; slot < handler.getSlots(); ++slot) {
                    InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)handler.getStackInSlot(slot));
                }
            });
            ((AdvancedBeehiveTileEntity)tileEntity).getUpgradeHandler().ifPresent(handler -> {
                for (int slot = 0; slot < handler.getSlots(); ++slot) {
                    InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)handler.getStackInSlot(slot));
                }
            });
        }
        super.func_196243_a(oldState, worldIn, pos, newState, isMoving);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileEntity tileEntity;
        ItemStack heldItem = player.func_184586_b(hand);
        int honeyLevel = (Integer)state.func_177229_b((IProperty)BeehiveBlock.field_226873_c_);
        boolean itemUsed = false;
        if (honeyLevel >= this.getMaxHoneyLevel()) {
            if (heldItem.func_77973_b() == Items.field_151097_aZ) {
                world.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_226133_ah_, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                BeehiveBlock.func_226878_a_((World)world, (BlockPos)pos);
                heldItem.func_222118_a(1, (LivingEntity)player, entity -> entity.func_213334_d(hand));
                itemUsed = true;
            } else if (heldItem.func_77973_b() == Items.field_151069_bo) {
                heldItem.func_190918_g(1);
                world.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187615_H, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                if (heldItem.func_190926_b()) {
                    player.func_184611_a(hand, new ItemStack((IItemProvider)Items.field_226638_pX_));
                } else if (!player.field_71071_by.func_70441_a(new ItemStack((IItemProvider)Items.field_226638_pX_))) {
                    player.func_71019_a(new ItemStack((IItemProvider)Items.field_226638_pX_), false);
                }
                itemUsed = true;
            }
        }
        if (itemUsed) {
            this.takeHoney(world, state, pos);
            if (player instanceof ServerPlayerEntity) {
                CriteriaTriggers.field_229863_J_.func_226695_a_((ServerPlayerEntity)player, pos, heldItem.func_77946_l());
            }
        } else if (!world.func_201670_d() && (tileEntity = world.func_175625_s(pos)) instanceof AdvancedBeehiveTileEntity) {
            this.updateState(world, pos, state, false);
            world.func_184138_a(pos, state, state, 3);
            this.openGui((ServerPlayerEntity)player, (AdvancedBeehiveTileEntity)tileEntity);
        }
        return ActionResultType.SUCCESS;
    }

    public void openGui(ServerPlayerEntity player, AdvancedBeehiveTileEntity tileEntity) {
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)tileEntity, packetBuffer -> packetBuffer.func_179255_a(tileEntity.func_174877_v()));
    }
}

