/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.block.AdvancedBeehiveAbstract;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBeeEntity;
import cy.jdkdigital.productivebees.common.tileentity.SolitaryNestTileEntity;
import cy.jdkdigital.productivebees.init.ModAdvancements;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModTileEntityTypes;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.recipe.BeeSpawningBigRecipe;
import cy.jdkdigital.productivebees.recipe.BeeSpawningRecipe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;

public class SolitaryNest
extends AdvancedBeehiveAbstract {
    List<BeeSpawningRecipe> recipes = new ArrayList<BeeSpawningRecipe>();

    public SolitaryNest(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)Direction.NORTH));
    }

    @Override
    public int getMaxHoneyLevel() {
        return 0;
    }

    public BeeEntity getNestingBeeType(World world, Biome biome) {
        List<BeeSpawningRecipe> spawningRecipes = this.getSpawningRecipes(world, biome);
        if (!spawningRecipes.isEmpty()) {
            BeeSpawningRecipe spawningRecipe = spawningRecipes.get(ProductiveBees.rand.nextInt(spawningRecipes.size()));
            BeeIngredient beeIngredient = (BeeIngredient)spawningRecipe.output.get(world.field_73012_v.nextInt(spawningRecipe.output.size())).get();
            BeeEntity bee = (BeeEntity)beeIngredient.getBeeEntity().func_200721_a(world.func_201672_e());
            if (bee instanceof ConfigurableBeeEntity) {
                ((ConfigurableBeeEntity)bee).setBeeType(beeIngredient.getBeeType().toString());
                ((ConfigurableBeeEntity)bee).setAttributes();
            }
            return bee;
        }
        return null;
    }

    public List<BeeSpawningRecipe> getSpawningRecipes(World world, Biome biome) {
        if (this.recipes.isEmpty()) {
            HashMap allRecipes = new HashMap();
            allRecipes.putAll(world.func_199532_z().func_215366_a(BeeSpawningBigRecipe.BEE_SPAWNING));
            allRecipes.putAll(world.func_199532_z().func_215366_a(BeeSpawningRecipe.BEE_SPAWNING));
            ItemStack nestItem = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(this.getRegistryName()));
            for (Map.Entry entry : allRecipes.entrySet()) {
                BeeSpawningRecipe recipe = (BeeSpawningRecipe)entry.getValue();
                if (!recipe.matches(nestItem)) continue;
                this.recipes.add(recipe);
            }
        }
        ArrayList<BeeSpawningRecipe> spawningRecipes = new ArrayList<BeeSpawningRecipe>();
        if (!this.recipes.isEmpty()) {
            for (BeeSpawningRecipe recipe : this.recipes) {
                if (((!recipe.biomes.isEmpty() || !world.func_201675_m().func_76569_d()) && !recipe.biomes.contains(biome.func_201856_r().func_222352_a()) || !recipe.temperature.equals("any")) && !recipe.temperature.equals(biome.func_150561_m().func_222357_a())) continue;
                spawningRecipes.add(recipe);
            }
        }
        return spawningRecipes;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)ModTileEntityTypes.SOLITARY_NEST.get()).func_200968_a();
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader world) {
        return new SolitaryNestTileEntity();
    }

    public BlockState func_196258_a(BlockItemUseContext itemUseContext) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)itemUseContext.func_196010_d().func_176734_d());
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        return (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)rotation.func_185831_a((Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208155_H)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208155_H)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{BlockStateProperties.field_208155_H});
    }

    public boolean canRepopulateIn(World world, Biome biome) {
        return !this.getSpawningRecipes(world, biome).isEmpty();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (!world.func_201670_d()) {
            SolitaryNestTileEntity tileEntity = (SolitaryNestTileEntity)world.func_175625_s(pos);
            ItemStack heldItem = player.func_184586_b(hand);
            if (tileEntity != null && heldItem.func_77973_b().equals(ModItems.HONEY_TREAT.get())) {
                boolean itemUse = false;
                int currentCooldown = tileEntity.getNestTickCooldown();
                if (currentCooldown <= 0) {
                    if (tileEntity.canRepopulate()) {
                        tileEntity.setNestCooldown(tileEntity.getRepopulationCooldown(state.func_177230_c()));
                        itemUse = true;
                    }
                } else {
                    tileEntity.setNestCooldown((int)((double)currentCooldown * 0.9));
                    itemUse = true;
                }
                if (itemUse) {
                    world.func_217379_c(2005, pos, 0);
                    ModAdvancements.RIGHT_CLICK_BLOCK_WITH_ITEM.func_226695_a_((ServerPlayerEntity)player, pos, heldItem);
                }
                if (!player.func_184812_l_()) {
                    heldItem.func_190918_g(1);
                }
            }
        }
        return super.func_225533_a_(state, world, pos, player, hand, hit);
    }
}

