/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.entity.bee;

import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.block.Feeder;
import cy.jdkdigital.productivebees.common.entity.bee.hive.RancherBeeEntity;
import cy.jdkdigital.productivebees.common.tileentity.FeederTileEntity;
import cy.jdkdigital.productivebees.init.ModPointOfInterestTypes;
import cy.jdkdigital.productivebees.util.BeeAttribute;
import cy.jdkdigital.productivebees.util.BeeAttributes;
import cy.jdkdigital.productivebees.util.BeeEffect;
import cy.jdkdigital.productivebees.util.BeeHelper;
import java.awt.Color;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.village.PointOfInterest;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class ProductiveBeeEntity
extends BeeEntity {
    protected Map<BeeAttribute<?>, Object> beeAttributes = new HashMap();
    protected Predicate<PointOfInterestType> beehiveInterests = poiType -> poiType == PointOfInterestType.field_226356_s_ || poiType == ModPointOfInterestTypes.SOLITARY_HIVE.get() || poiType == ModPointOfInterestTypes.SOLITARY_NEST.get();
    private Color primaryColor = null;
    private Color secondaryColor = null;
    private boolean renderStatic;
    protected FollowParentGoal followParentGoal;
    protected BreedGoal breedGoal;
    protected BeeEntity.EnterBeehiveGoal enterHiveGoal;

    public ProductiveBeeEntity(EntityType<? extends BeeEntity> entityType, World world) {
        super(entityType, world);
        this.setAttributeValue(BeeAttributes.PRODUCTIVITY, world.field_73012_v.nextInt(3));
        this.setAttributeValue(BeeAttributes.TEMPER, 1);
        this.setAttributeValue(BeeAttributes.ENDURANCE, world.field_73012_v.nextInt(4));
        this.setAttributeValue(BeeAttributes.BEHAVIOR, 0);
        this.setAttributeValue(BeeAttributes.WEATHER_TOLERANCE, 0);
        this.setAttributeValue(BeeAttributes.TYPE, "hive");
        this.setAttributeValue(BeeAttributes.APHRODISIACS, ItemTags.field_226159_I_);
        this.field_70714_bg.func_75776_a(3, (Goal)new ProductiveTemptGoal((CreatureEntity)this, 1.25));
    }

    protected void func_184651_r() {
        this.registerBaseGoals();
        this.field_226370_bJ_ = new PollinateGoal();
        this.field_70714_bg.func_75776_a(4, (Goal)this.field_226370_bJ_);
        this.field_226372_bL_ = new BeeEntity.FindFlowerGoal((BeeEntity)this);
        this.field_70714_bg.func_75776_a(6, (Goal)this.field_226372_bL_);
        this.field_70714_bg.func_75776_a(7, (Goal)new BeeEntity.FindPollinationTargetGoal((BeeEntity)this));
    }

    protected void registerBaseGoals() {
        this.field_70714_bg.func_75776_a(0, (Goal)new BeeEntity.StingGoal((BeeEntity)this, (CreatureEntity)this, 1.4, true));
        this.enterHiveGoal = new BeeEntity.EnterBeehiveGoal((BeeEntity)this);
        this.field_70714_bg.func_75776_a(1, (Goal)this.enterHiveGoal);
        this.breedGoal = new BreedGoal((AnimalEntity)this, 1.0, ProductiveBeeEntity.class);
        this.field_70714_bg.func_75776_a(2, (Goal)this.breedGoal);
        this.followParentGoal = new FollowParentGoal((AnimalEntity)this, 1.25);
        this.field_70714_bg.func_75776_a(5, (Goal)this.followParentGoal);
        this.field_70714_bg.func_75776_a(5, (Goal)new UpdateNestGoal());
        this.field_226371_bK_ = new FindNestGoal();
        this.field_70714_bg.func_75776_a(5, (Goal)this.field_226371_bK_);
        this.field_70714_bg.func_75776_a(8, (Goal)new BeeEntity.WanderGoal((BeeEntity)this));
        this.field_70714_bg.func_75776_a(9, (Goal)new SwimGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new BeeEntity.AngerGoal((BeeEntity)this, (BeeEntity)this).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new BeeEntity.AttackPlayerGoal((BeeEntity)this));
        this.field_226370_bJ_ = new EmptyPollinateGoal();
        this.field_226372_bL_ = new EmptyFindFlowerGoal();
    }

    public void func_70636_d() {
        List players;
        BeeEffect effect;
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % (Integer)ProductiveBeesConfig.BEE_ATTRIBUTES.effectTicks.get() == 0 && (effect = this.getBeeEffect()) != null && effect.getEffects().size() > 0 && (players = this.field_70170_p.func_217357_a(PlayerEntity.class, new AxisAlignedBB(new BlockPos((Entity)this)).func_72314_b(8.0, 6.0, 8.0))).size() > 0) {
            players.forEach(playerEntity -> effect.getEffects().forEach((potionEffect, duration) -> playerEntity.func_195064_c(new EffectInstance(potionEffect, duration.intValue()))));
        }
        if (!this.field_70170_p.field_72995_K && this.func_110167_bD() && this.field_70173_aa % (Integer)ProductiveBeesConfig.BEE_ATTRIBUTES.leashedTicks.get() == 0) {
            boolean isInDanger;
            int behavior;
            int tolerance = this.getAttributeValue(BeeAttributes.WEATHER_TOLERANCE);
            if (tolerance < 2 && (double)this.field_70170_p.field_73012_v.nextFloat() < (Double)ProductiveBeesConfig.BEE_ATTRIBUTES.toleranceChance.get() && (tolerance < 1 && this.field_70170_p.func_72896_J() || this.field_70170_p.func_72911_I())) {
                this.beeAttributes.put(BeeAttributes.WEATHER_TOLERANCE, tolerance + 1);
            }
            if ((behavior = this.getAttributeValue(BeeAttributes.BEHAVIOR).intValue()) < 2 && (double)this.field_70170_p.field_73012_v.nextFloat() < (Double)ProductiveBeesConfig.BEE_ATTRIBUTES.behaviorChance.get()) {
                if (behavior < 1 && this.field_70170_p.func_226690_K_()) {
                    this.beeAttributes.put(BeeAttributes.BEHAVIOR, this.field_70170_p.field_73012_v.nextFloat() < 0.85f ? 1 : 2);
                } else if (behavior == 1 && !this.field_70170_p.func_226690_K_()) {
                    this.beeAttributes.put(BeeAttributes.BEHAVIOR, this.field_70170_p.field_73012_v.nextFloat() < 0.85f ? 2 : 0);
                }
            }
            boolean bl = isInDanger = tolerance < 1 && this.field_70170_p.func_72896_J() || behavior < 1 && this.field_70170_p.func_226690_K_();
            if (isInDanger && (double)this.field_70170_p.field_73012_v.nextFloat() < (Double)ProductiveBeesConfig.BEE_ATTRIBUTES.damageChance.get()) {
                this.func_70606_j(this.func_110143_aJ() - this.func_110138_aP() / 3.0f - 1.0f);
            }
        }
    }

    @Nonnull
    public EntitySize func_213305_a(Pose poseIn) {
        return super.func_213305_a(poseIn).func_220313_a(this.getSizeModifier());
    }

    public float getSizeModifier() {
        return 1.0f;
    }

    public boolean func_226427_ez_() {
        return super.func_226427_ez_() && this.getAttributeValue(BeeAttributes.TEMPER) > 0;
    }

    public boolean func_226439_k_(BlockPos pos) {
        if (!this.field_70170_p.func_195588_v(pos)) {
            return false;
        }
        Block flowerBlock = this.field_70170_p.func_180495_p(pos).func_177230_c();
        return flowerBlock.func_203417_a(this.getFlowerTag()) || flowerBlock instanceof Feeder && ProductiveBeeEntity.isValidFeeder(this.field_70170_p.func_175625_s(pos), this.getFlowerTag());
    }

    public static boolean isValidFeeder(TileEntity tile, Tag<Block> flowerTag) {
        AtomicBoolean hasValidBlock = new AtomicBoolean(false);
        if (tile instanceof FeederTileEntity) {
            tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
                for (int slot = 0; slot < handler.getSlots(); ++slot) {
                    Item slotItem = handler.getStackInSlot(slot).func_77973_b();
                    if (!(slotItem instanceof BlockItem) || !((BlockItem)slotItem).func_179223_d().func_203417_a(flowerTag)) continue;
                    hasValidBlock.set(true);
                }
            });
        }
        return hasValidBlock.get();
    }

    public boolean func_226415_eI_() {
        if (this.field_226364_bD_ <= 0 && !this.field_226370_bJ_.func_226503_k_() && !this.func_226412_eE_()) {
            boolean shouldReturnToHive = this.func_226414_eH_() || this.func_226411_eD_() || this.field_70170_p.func_226690_K_() && !this.canOperateDuringNight() || this.field_70170_p.func_72896_J() && !this.canOperateDuringRain();
            return shouldReturnToHive && !this.func_226417_eK_();
        }
        return false;
    }

    public void func_226449_s_(boolean hasStung) {
        if (hasStung && this.getAttributeValue(BeeAttributes.ENDURANCE) == 2) {
            hasStung = this.field_70170_p.field_73012_v.nextBoolean();
        }
        if (hasStung && this.getAttributeValue(BeeAttributes.ENDURANCE) == 3) {
            hasStung = (double)this.field_70170_p.field_73012_v.nextFloat() < 0.2;
        }
        super.func_226449_s_(hasStung);
    }

    public boolean func_70877_b(ItemStack itemStack) {
        return itemStack.func_77973_b().func_206844_a(this.getAttributeValue(BeeAttributes.APHRODISIACS));
    }

    public String getBeeName() {
        return this.getBeeName(true);
    }

    public String getBeeName(boolean stripName) {
        String[] types = this.func_70022_Q().split("[:]");
        String type = types[0];
        if (types.length > 1) {
            type = types[1];
        }
        return stripName ? type.replace("_bee", "") : type;
    }

    public String getRenderer() {
        return "default";
    }

    public <T> T getAttributeValue(BeeAttribute<T> parameter) {
        return (T)this.beeAttributes.get(parameter);
    }

    public void setAttributeValue(BeeAttribute<?> parameter, Integer value) {
        if (((Object)parameter).equals(BeeAttributes.ENDURANCE)) {
            AttributeModifier mod;
            IAttributeInstance healthMod = this.func_110148_a(SharedMonsterAttributes.field_111267_a);
            if (value != 1 && !healthMod.func_180374_a(mod = BeeAttributes.HEALTH_MODS.get(value))) {
                healthMod.func_188479_b(BeeAttributes.HEALTH_MOD_ID_WEAK);
                healthMod.func_188479_b(BeeAttributes.HEALTH_MOD_ID_MEDIUM);
                healthMod.func_188479_b(BeeAttributes.HEALTH_MOD_ID_STRONG);
                healthMod.func_111121_a(BeeAttributes.HEALTH_MODS.get(value));
            }
        }
        this.beeAttributes.put(parameter, value);
    }

    public void setAttributeValue(BeeAttribute<?> parameter, Object value) {
        this.beeAttributes.put(parameter, value);
    }

    public Map<BeeAttribute<?>, Object> getBeeAttributes() {
        return this.beeAttributes;
    }

    public boolean canOperateDuringNight() {
        return this.getAttributeValue(BeeAttributes.BEHAVIOR) > 0;
    }

    boolean canOperateDuringRain() {
        return this.getAttributeValue(BeeAttributes.WEATHER_TOLERANCE) == 1;
    }

    boolean canOperateDuringThunder() {
        return this.getAttributeValue(BeeAttributes.WEATHER_TOLERANCE) == 2;
    }

    public void setRenderStatic() {
        this.renderStatic = true;
    }

    public boolean getRenderStatic() {
        return this.renderStatic;
    }

    public boolean func_180431_b(DamageSource source) {
        return source.equals(DamageSource.field_76368_d) || source.equals(DamageSource.field_220302_v) || super.func_180431_b(source);
    }

    @Nonnull
    protected PathNavigator func_175447_b(@Nonnull World worldIn) {
        PathNavigator navigator = super.func_175447_b(this.field_70170_p);
        if (navigator instanceof FlyingPathNavigator) {
            navigator.func_212239_d(false);
            ((FlyingPathNavigator)navigator).func_192878_b(false);
        }
        return navigator;
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74768_a("bee_productivity", this.getAttributeValue(BeeAttributes.PRODUCTIVITY).intValue());
        tag.func_74768_a("bee_endurance", this.getAttributeValue(BeeAttributes.ENDURANCE).intValue());
        tag.func_74768_a("bee_temper", this.getAttributeValue(BeeAttributes.TEMPER).intValue());
        tag.func_74768_a("bee_behavior", this.getAttributeValue(BeeAttributes.BEHAVIOR).intValue());
        tag.func_74768_a("bee_weather_tolerance", this.getAttributeValue(BeeAttributes.WEATHER_TOLERANCE).intValue());
        tag.func_74778_a("bee_type", this.getAttributeValue(BeeAttributes.TYPE));
        tag.func_74778_a("bee_aphrodisiac", this.getAttributeValue(BeeAttributes.APHRODISIACS).func_199886_b().toString());
        tag.func_74776_a("MaxHealth", this.func_110138_aP());
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("bee_productivity")) {
            this.beeAttributes.clear();
            this.setAttributeValue(BeeAttributes.PRODUCTIVITY, tag.func_74762_e("bee_productivity"));
            this.setAttributeValue(BeeAttributes.ENDURANCE, tag.func_74764_b("bee_endurance") ? tag.func_74762_e("bee_endurance") : 1);
            this.setAttributeValue(BeeAttributes.TEMPER, tag.func_74762_e("bee_temper"));
            this.setAttributeValue(BeeAttributes.BEHAVIOR, tag.func_74762_e("bee_behavior"));
            this.setAttributeValue(BeeAttributes.WEATHER_TOLERANCE, tag.func_74762_e("bee_weather_tolerance"));
            this.setAttributeValue(BeeAttributes.TYPE, tag.func_74779_i("bee_type"));
            this.setAttributeValue(BeeAttributes.APHRODISIACS, new ItemTags.Wrapper(new ResourceLocation(tag.func_74779_i("bee_aphrodisiac"))));
        }
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("productivebees", "spawn_egg_" + this.getBeeName(false)));
        return new ItemStack((IItemProvider)item);
    }

    protected void func_175500_n() {
        super.func_175500_n();
        if (!this.func_70631_g_()) {
            BlockPos pos = this.func_180425_c();
            if (this.field_70170_p.func_175623_d(pos)) {
                this.func_70634_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            } else if (this.field_70170_p.func_175623_d(pos.func_177977_b())) {
                pos = pos.func_177977_b();
                this.func_70634_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        }
    }

    public BeeEntity func_90011_a(AgeableEntity targetEntity) {
        BeeEntity newBee = BeeHelper.getBreedingResult(this, targetEntity, this.field_70170_p);
        if (newBee instanceof ProductiveBeeEntity) {
            BeeHelper.setOffspringAttributes((ProductiveBeeEntity)newBee, this, targetEntity);
        }
        return newBee;
    }

    public boolean func_70878_b(@Nonnull AnimalEntity otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (!(otherAnimal instanceof BeeEntity)) {
            return false;
        }
        return this.func_70880_s() && otherAnimal.func_70880_s() && (BeeHelper.getRandomBreedingRecipe(this, (AgeableEntity)otherAnimal, this.field_70170_p) != null || this.canSelfBreed() || !(otherAnimal instanceof ProductiveBeeEntity));
    }

    public boolean canSelfBreed() {
        return true;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return this.func_70631_g_() ? sizeIn.field_220316_b * 0.25f : sizeIn.field_220316_b * 0.5f;
    }

    public void setColor(Color primary, Color secondary) {
        this.primaryColor = primary;
        this.secondaryColor = secondary;
    }

    public Color getColor(int tintIndex) {
        return tintIndex == 0 ? this.primaryColor : this.secondaryColor;
    }

    public Tag<Block> getFlowerTag() {
        return BlockTags.field_226149_I_;
    }

    public Tag<Block> getNestingTag() {
        return BlockTags.field_226151_aa_;
    }

    public BeeEffect getBeeEffect() {
        return null;
    }

    public class EmptyFindFlowerGoal
    extends BeeEntity.FindFlowerGoal {
        public EmptyFindFlowerGoal() {
            super((BeeEntity)ProductiveBeeEntity.this);
        }

        public boolean func_75250_a() {
            return false;
        }
    }

    public class EmptyPollinateGoal
    extends PollinateGoal {
        @Override
        public boolean func_75250_a() {
            return false;
        }
    }

    public class ProductiveTemptGoal
    extends TemptGoal {
        public ProductiveTemptGoal(CreatureEntity entity, double speed) {
            super(entity, speed, false, Ingredient.func_199805_a(ProductiveBeeEntity.this.getAttributeValue(BeeAttributes.APHRODISIACS)));
        }
    }

    public class UpdateNestGoal
    extends BeeEntity.UpdateBeehiveGoal {
        public UpdateNestGoal() {
            super((BeeEntity)ProductiveBeeEntity.this);
        }

        public void func_75249_e() {
            ProductiveBeeEntity.this.field_226366_bF_ = 200;
            List<BlockPos> nearbyNests = this.getNearbyFreeNests();
            if (!nearbyNests.isEmpty()) {
                BlockPos blockPos;
                Iterator<BlockPos> iterator = nearbyNests.iterator();
                do {
                    if (iterator.hasNext()) continue;
                    ProductiveBeeEntity.this.field_226371_bK_.func_226477_j_();
                    ProductiveBeeEntity.this.field_226369_bI_ = nearbyNests.get(0);
                    return;
                } while (ProductiveBeeEntity.this.field_226371_bK_.func_226473_b_(blockPos = iterator.next()));
                ProductiveBeeEntity.this.field_226369_bI_ = blockPos;
            }
        }

        private List<BlockPos> getNearbyFreeNests() {
            BlockPos pos = new BlockPos((Entity)ProductiveBeeEntity.this);
            PointOfInterestManager poiManager = ((ServerWorld)ProductiveBeeEntity.this.field_70170_p).func_217443_B();
            Stream stream = poiManager.func_219146_b(ProductiveBeeEntity.this.beehiveInterests, pos, 30, PointOfInterestManager.Status.ANY);
            return stream.map(PointOfInterest::func_218261_f).filter(arg_0 -> ((ProductiveBeeEntity)ProductiveBeeEntity.this).func_226435_i_(arg_0)).sorted(Comparator.comparingDouble(vec -> vec.func_177951_i((Vec3i)pos))).collect(Collectors.toList());
        }
    }

    public class FindNestGoal
    extends BeeEntity.FindBeehiveGoal {
        public FindNestGoal() {
            super((BeeEntity)ProductiveBeeEntity.this);
        }

        public boolean func_225506_g_() {
            if (!ProductiveBeeEntity.this.func_226409_eA_()) {
                return false;
            }
            Tag<Block> nestTag = ProductiveBeeEntity.this.getNestingTag();
            if (nestTag == null || nestTag.func_199885_a().size() == 0) {
                return false;
            }
            return !ProductiveBeeEntity.this.func_213394_dL() && ProductiveBeeEntity.this.func_226415_eI_() && !this.isCloseEnough(ProductiveBeeEntity.this.field_226369_bI_) && ProductiveBeeEntity.this.field_70170_p.func_180495_p(ProductiveBeeEntity.this.field_226369_bI_).func_203425_a(nestTag);
        }

        private boolean isCloseEnough(BlockPos pos) {
            if (ProductiveBeeEntity.this.func_226401_b_(pos, 2)) {
                return true;
            }
            Path path = ProductiveBeeEntity.this.field_70699_by.func_75505_d();
            return path != null && path.func_224770_k().equals((Object)pos) && path.func_224771_h() && path.func_75879_b();
        }

        protected void func_226475_c_(BlockPos pos) {
            TileEntity tileEntity = ProductiveBeeEntity.this.field_70170_p.func_175625_s(pos);
            Tag<Block> nestTag = ProductiveBeeEntity.this.getNestingTag();
            if (tileEntity != null && tileEntity.func_195044_w().func_203425_a(nestTag)) {
                this.field_226469_d_.add(pos);
                while (this.field_226469_d_.size() > 3) {
                    this.field_226469_d_.remove(0);
                }
            }
        }
    }

    public class PollinateGoal
    extends BeeEntity.PollinateGoal {
        public Predicate<BlockPos> field_226492_c_;
        private MutableBoundingBox box;

        public PollinateGoal() {
            super((BeeEntity)ProductiveBeeEntity.this);
            this.field_226492_c_ = blockPos -> {
                boolean isInterested;
                BlockState blockState = ProductiveBeeEntity.this.field_70170_p.func_180495_p(blockPos);
                Tag<Block> interests = ProductiveBeeEntity.this.getFlowerTag();
                if (blockState.func_177230_c() instanceof Feeder) {
                    isInterested = ProductiveBeeEntity.isValidFeeder(ProductiveBeeEntity.this.field_70170_p.func_175625_s(blockPos), ProductiveBeeEntity.this.getFlowerTag());
                } else {
                    isInterested = blockState.func_203425_a(interests);
                    if (isInterested && blockState.func_203425_a(BlockTags.field_226148_H_) && blockState.func_177230_c() == Blocks.field_196800_gd) {
                        isInterested = blockState.func_177229_b((IProperty)DoublePlantBlock.field_176492_b) == DoubleBlockHalf.UPPER;
                    }
                }
                return isInterested;
            };
            this.box = null;
        }

        public boolean func_225506_g_() {
            if (ProductiveBeeEntity.this.field_226367_bG_ > 0) {
                return false;
            }
            if (ProductiveBeeEntity.this.func_226411_eD_()) {
                return false;
            }
            if (ProductiveBeeEntity.this.field_70170_p.func_72896_J() && !ProductiveBeeEntity.this.canOperateDuringRain()) {
                return false;
            }
            if (ProductiveBeeEntity.this.field_70170_p.func_72911_I() && !ProductiveBeeEntity.this.canOperateDuringThunder()) {
                return false;
            }
            if (ProductiveBeeEntity.this.field_70146_Z.nextFloat() <= 0.7f) {
                return false;
            }
            Optional<BlockPos> optional = this.func_226507_o_();
            if (optional.isPresent()) {
                ProductiveBeeEntity.this.field_226368_bH_ = optional.get();
                ProductiveBeeEntity.this.field_70699_by.func_75492_a((double)ProductiveBeeEntity.this.field_226368_bH_.func_177958_n() + 0.5, (double)ProductiveBeeEntity.this.field_226368_bH_.func_177956_o() + 0.5, (double)ProductiveBeeEntity.this.field_226368_bH_.func_177952_p() + 0.5, (double)1.2f);
                return true;
            }
            ProductiveBeeEntity.this.field_226367_bG_ = 70 + ProductiveBeeEntity.this.field_70170_p.field_73012_v.nextInt(50);
            return false;
        }

        @Nonnull
        public Optional<BlockPos> func_226507_o_() {
            if (ProductiveBeeEntity.this instanceof RancherBeeEntity) {
                return this.findEntities(RancherBeeEntity.predicate, 5.0);
            }
            return this.findFlower(this.field_226492_c_, 5);
        }

        private Optional<BlockPos> findFlower(Predicate<BlockPos> predicate, int distance) {
            BlockPos blockpos = new BlockPos((Entity)ProductiveBeeEntity.this);
            BlockPos.Mutable mutableBlockPos = new BlockPos.Mutable(0, 0, 0);
            if (this.box == null) {
                this.box = MutableBoundingBox.func_175899_a((int)(blockpos.func_177958_n() + distance), (int)(blockpos.func_177956_o() + distance), (int)(blockpos.func_177952_p() + distance), (int)(blockpos.func_177958_n() - distance), (int)(blockpos.func_177956_o() - distance), (int)(blockpos.func_177952_p() - distance));
            } else {
                this.box.field_78893_d = blockpos.func_177958_n() + distance;
                this.box.field_78894_e = blockpos.func_177956_o() + distance;
                this.box.field_78892_f = blockpos.func_177952_p() + distance;
                this.box.field_78897_a = blockpos.func_177958_n() - distance;
                this.box.field_78895_b = blockpos.func_177956_o() - distance;
                this.box.field_78896_c = blockpos.func_177952_p() - distance;
            }
            AtomicReference<Double> lastDistance = new AtomicReference<Double>(100.0);
            BlockPos.func_229383_a_((MutableBoundingBox)this.box).filter(predicate).forEach(blockPos -> {
                double currDistance = blockpos.func_177951_i((Vec3i)blockPos);
                if (currDistance < (Double)lastDistance.get()) {
                    lastDistance.set(currDistance);
                    mutableBlockPos.func_189533_g((Vec3i)blockPos);
                }
            });
            if (lastDistance.get() < 100.0) {
                return Optional.of(mutableBlockPos);
            }
            return Optional.empty();
        }

        private Optional<BlockPos> findEntities(Predicate<Entity> predicate, double distance) {
            BlockPos blockpos = new BlockPos((Entity)ProductiveBeeEntity.this);
            BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
            List ranchables = ProductiveBeeEntity.this.field_70170_p.func_175674_a((Entity)ProductiveBeeEntity.this, new AxisAlignedBB(blockpos).func_72314_b(distance, distance, distance), predicate);
            if (ranchables.size() > 0) {
                CreatureEntity entity = (CreatureEntity)ranchables.get(0);
                entity.func_70661_as().func_75489_a(0.0);
                blockpos$mutable.func_189535_a((Entity)entity);
                return Optional.of(blockpos$mutable);
            }
            return Optional.empty();
        }
    }
}

