/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.entity.bee.hive;

import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBeeEntity;
import cy.jdkdigital.productivebees.util.BeeAttributes;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class CupidBeeEntity
extends ProductiveBeeEntity {
    public AnimalEntity targetEntity = null;
    private int animalsBredSincePollination;
    private SetLoveModeGoal loveGoal;
    public static Predicate<Entity> predicate = entity -> {
        if (entity instanceof AnimalEntity) {
            return !((AnimalEntity)entity).func_70880_s() && !((AnimalEntity)entity).func_70631_g_();
        }
        return false;
    };

    public CupidBeeEntity(EntityType<? extends BeeEntity> entityType, World world) {
        super(entityType, world);
        this.beeAttributes.put(BeeAttributes.WEATHER_TOLERANCE, 1);
    }

    @Override
    public boolean canSelfBreed() {
        return false;
    }

    @Override
    protected void func_184651_r() {
        this.registerBaseGoals();
        this.field_70714_bg.func_85156_a((Goal)this.breedGoal);
        this.field_226370_bJ_ = new ProductiveBeeEntity.PollinateGoal(this);
        this.field_70714_bg.func_75776_a(4, (Goal)this.field_226370_bJ_);
        this.field_226372_bL_ = new BeeEntity.FindFlowerGoal((BeeEntity)this);
        this.field_70714_bg.func_75776_a(6, (Goal)this.field_226372_bL_);
        this.field_70714_bg.func_75776_a(2, (Goal)new GoToBreedableGoal());
        this.loveGoal = new SetLoveModeGoal();
        this.field_70714_bg.func_75776_a(3, (Goal)this.loveGoal);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70173_aa % 20 == 0 && this.func_226411_eD_()) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197633_z, this.func_226282_d_(1.0), this.func_226279_cv_() + 0.5, this.func_226287_g_(1.0), d0, d1, d2);
        }
    }

    private int getAnimalsBredSincePollination() {
        return this.animalsBredSincePollination;
    }

    private void resetBreedCounter() {
        this.animalsBredSincePollination = 0;
    }

    private void addBreedCounter() {
        ++this.animalsBredSincePollination;
    }

    @Override
    public boolean func_226415_eI_() {
        return super.func_226415_eI_() && !this.loveGoal.isRunning();
    }

    public void func_226413_eG_() {
        super.func_226413_eG_();
        this.resetBreedCounter();
    }

    public List<Entity> findNearbyBreedables(float distance) {
        BlockPos pos = this.func_180425_c();
        return this.field_70170_p.func_175674_a((Entity)this, new AxisAlignedBB(pos).func_72314_b((double)distance, (double)distance, (double)distance), predicate);
    }

    public class SetLoveModeGoal
    extends Goal {
        private int ticks = 0;
        private boolean running;

        public boolean func_75250_a() {
            List<Entity> breedablesNearby;
            if (!CupidBeeEntity.this.func_226427_ez_() && CupidBeeEntity.this.func_226411_eD_() && CupidBeeEntity.this.getAnimalsBredSincePollination() <= (Integer)ProductiveBeesConfig.BEES.cupidBeeAnimalsPerPollination.get() && !(breedablesNearby = CupidBeeEntity.this.findNearbyBreedables(5.0f)).isEmpty() && breedablesNearby.size() < (Integer)ProductiveBeesConfig.BEES.cupidBeeAnimalDensity.get()) {
                BlockPos beePos = CupidBeeEntity.this.func_180425_c();
                AnimalEntity nearest = null;
                double nearestDistance = 0.0;
                for (Entity entity : breedablesNearby) {
                    if (!(entity instanceof AnimalEntity)) continue;
                    BlockPos pos = entity.func_180425_c();
                    double distance = pos.func_177951_i((Vec3i)beePos);
                    if (nearestDistance != 0.0 && !(distance < nearestDistance)) continue;
                    nearestDistance = distance;
                    nearest = (AnimalEntity)entity;
                }
                CupidBeeEntity.this.targetEntity = nearest;
                return true;
            }
            return false;
        }

        public boolean func_75253_b() {
            if (!this.running) {
                return false;
            }
            return CupidBeeEntity.this.targetEntity != null && CupidBeeEntity.this.func_226411_eD_() && !CupidBeeEntity.this.func_226427_ez_();
        }

        public boolean isRunning() {
            return this.running;
        }

        public void func_75249_e() {
            this.ticks = 0;
            this.running = true;
        }

        public void func_75251_c() {
            this.running = false;
        }

        public void func_75246_d() {
            ++this.ticks;
            if (CupidBeeEntity.this.targetEntity != null) {
                if (this.ticks > 600) {
                    CupidBeeEntity.this.targetEntity = null;
                } else {
                    Vec3d vec3d = new Vec3d((Vec3i)CupidBeeEntity.this.targetEntity.func_180425_c()).func_72441_c(0.5, (double)0.6f, 0.5);
                    double distanceToTarget = vec3d.func_72438_d(CupidBeeEntity.this.func_213303_ch());
                    if (distanceToTarget > 1.0) {
                        this.moveToNextTarget(vec3d);
                    } else if (distanceToTarget > 0.1 && this.ticks > 600) {
                        CupidBeeEntity.this.targetEntity = null;
                    } else {
                        Entity target;
                        List<Entity> breedablesNearby = CupidBeeEntity.this.findNearbyBreedables(1.0f);
                        if (!breedablesNearby.isEmpty() && (target = breedablesNearby.iterator().next()) instanceof AnimalEntity) {
                            if (!((AnimalEntity)target).func_70631_g_() && ((AnimalEntity)target).func_204701_dC()) {
                                ((AnimalEntity)target).func_204700_e(600);
                                CupidBeeEntity.this.addBreedCounter();
                            }
                            CupidBeeEntity.this.func_184185_a(SoundEvents.field_226129_ad_, 1.0f, 1.0f);
                        }
                    }
                }
            }
        }

        private void moveToNextTarget(Vec3d target) {
            CupidBeeEntity.this.func_70605_aq().func_75642_a(target.func_82615_a(), target.func_82617_b(), target.func_82616_c(), 1.0);
        }
    }

    public class GoToBreedableGoal
    extends Goal {
        private int ticks = 0;

        public boolean func_75250_a() {
            return !CupidBeeEntity.this.func_226427_ez_() && CupidBeeEntity.this.func_226411_eD_() && CupidBeeEntity.this.targetEntity != null;
        }

        public void func_75249_e() {
            this.ticks = 0;
        }

        public void func_75246_d() {
            if (CupidBeeEntity.this.targetEntity != null) {
                ++this.ticks;
                if (this.ticks > 600) {
                    CupidBeeEntity.this.targetEntity = null;
                } else if (!CupidBeeEntity.this.field_70699_by.func_226337_n_() || this.ticks % 100 == 0) {
                    BlockPos blockPos = CupidBeeEntity.this.targetEntity.func_180425_c();
                    CupidBeeEntity.this.field_70699_by.func_75492_a((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), 1.0);
                }
            }
        }
    }
}

