/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.entity.bee.hive;

import com.mojang.authlib.GameProfile;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBeeEntity;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.block.CropsBlock;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.ModList;

public class FarmerBeeEntity
extends ProductiveBeeEntity {
    public static final UUID FARMER_BEE_UUID = UUID.nameUUIDFromBytes("pb_farmer_bee".getBytes(StandardCharsets.UTF_8));
    private BlockPos targetHarvestPos = null;

    public FarmerBeeEntity(EntityType<? extends BeeEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    public boolean canSelfBreed() {
        return false;
    }

    @Override
    protected void func_184651_r() {
        this.registerBaseGoals();
        this.field_70714_bg.func_75776_a(4, (Goal)new HarvestCropGoal());
        this.field_70714_bg.func_75776_a(6, (Goal)new LocateCropGoal());
    }

    public List<BlockPos> findHarvestablesNearby(double distance) {
        return this.findHarvestablesNearby(this.func_180425_c(), distance);
    }

    public List<BlockPos> findHarvestablesNearby(BlockPos pos, double distance) {
        List<BlockPos> list = BlockPos.func_218281_b((BlockPos)pos.func_177963_a(-distance, -distance + 2.0, -distance), (BlockPos)pos.func_177963_a(distance, distance - 2.0, distance)).map(BlockPos::func_185334_h).collect(Collectors.toList());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            BlockPos blockPos = (BlockPos)iterator.next();
            BlockState state = this.field_70170_p.func_180495_p(blockPos);
            if (state.func_177230_c() instanceof CropsBlock && !((CropsBlock)state.func_177230_c()).func_176473_a((IBlockReader)this.field_70170_p, blockPos, state, false)) continue;
            iterator.remove();
        }
        return list;
    }

    public class LocateCropGoal
    extends Goal {
        private int ticks = 0;

        public boolean func_75250_a() {
            if (!FarmerBeeEntity.this.func_226427_ez_()) {
                List<BlockPos> harvestablesNearby = FarmerBeeEntity.this.findHarvestablesNearby(10.0);
                Collections.shuffle(harvestablesNearby);
                if (!harvestablesNearby.isEmpty()) {
                    BlockPos nearest = null;
                    double nearestDistance = 0.0;
                    for (BlockPos pos : harvestablesNearby) {
                        double distance = pos.func_177951_i((Vec3i)FarmerBeeEntity.this.func_180425_c());
                        if (nearestDistance != 0.0 && !(distance <= nearestDistance)) continue;
                        nearestDistance = distance;
                        nearest = pos;
                    }
                    FarmerBeeEntity.this.targetHarvestPos = nearest;
                    return true;
                }
            }
            return false;
        }

        public boolean func_75253_b() {
            return FarmerBeeEntity.this.targetHarvestPos != null && FarmerBeeEntity.this.func_226409_eA_() && !FarmerBeeEntity.this.func_226427_ez_();
        }

        public void func_75249_e() {
            this.ticks = 0;
        }

        public void func_75246_d() {
            ++this.ticks;
            if (FarmerBeeEntity.this.targetHarvestPos != null) {
                if (this.ticks > 600) {
                    FarmerBeeEntity.this.targetHarvestPos = null;
                } else {
                    Vec3d vec3d = new Vec3d((Vec3i)FarmerBeeEntity.this.targetHarvestPos).func_72441_c(0.5, (double)0.6f, 0.5);
                    double distanceToTarget = vec3d.func_72438_d(FarmerBeeEntity.this.func_213303_ch());
                    if (distanceToTarget > 1.0) {
                        this.moveToNextTarget(vec3d);
                    } else if (distanceToTarget > 0.1 && this.ticks > 600) {
                        FarmerBeeEntity.this.targetHarvestPos = null;
                    } else {
                        List<BlockPos> harvestablesNearby = FarmerBeeEntity.this.findHarvestablesNearby(0.0);
                        if (!harvestablesNearby.isEmpty()) {
                            BlockPos pos = harvestablesNearby.iterator().next();
                            if ((ModList.get().isLoaded("quark") || ModList.get().isLoaded("pamhc2crops") || ModList.get().isLoaded("simplefarming") || ModList.get().isLoaded("reap")) && FarmerBeeEntity.this.field_70170_p instanceof ServerWorld) {
                                FakePlayer fakePlayer = FakePlayerFactory.get((ServerWorld)((ServerWorld)FarmerBeeEntity.this.field_70170_p), (GameProfile)new GameProfile(FARMER_BEE_UUID, "farmer_bee"));
                                ForgeHooks.onRightClickBlock((PlayerEntity)fakePlayer, (Hand)Hand.MAIN_HAND, (BlockPos)pos, (Direction)FarmerBeeEntity.this.func_184172_bi());
                            } else {
                                FarmerBeeEntity.this.field_70170_p.func_175655_b(pos, true);
                            }
                            FarmerBeeEntity.this.targetHarvestPos = null;
                            FarmerBeeEntity.this.func_184185_a(SoundEvents.field_226129_ad_, 1.0f, 1.0f);
                        }
                    }
                }
            }
        }

        private void moveToNextTarget(Vec3d nextTarget) {
            FarmerBeeEntity.this.func_70605_aq().func_75642_a(nextTarget.func_82615_a(), nextTarget.func_82617_b(), nextTarget.func_82616_c(), 1.0);
        }
    }

    public class HarvestCropGoal
    extends Goal {
        private int ticks = 0;

        public boolean func_75250_a() {
            if (FarmerBeeEntity.this.targetHarvestPos != null && !this.positionIsHarvestable(FarmerBeeEntity.this.targetHarvestPos)) {
                FarmerBeeEntity.this.targetHarvestPos = null;
            }
            return FarmerBeeEntity.this.targetHarvestPos != null && !FarmerBeeEntity.this.func_226427_ez_() && !FarmerBeeEntity.this.func_226401_b_(FarmerBeeEntity.this.targetHarvestPos, 2);
        }

        public void func_75249_e() {
            this.ticks = 0;
        }

        public void func_75246_d() {
            if (FarmerBeeEntity.this.targetHarvestPos != null) {
                ++this.ticks;
                if (this.ticks > 600) {
                    FarmerBeeEntity.this.targetHarvestPos = null;
                } else if (!FarmerBeeEntity.this.field_70699_by.func_226337_n_()) {
                    BlockPos blockPos = FarmerBeeEntity.this.targetHarvestPos;
                    FarmerBeeEntity.this.field_70699_by.func_75492_a((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), 1.0);
                }
            }
        }

        private boolean positionIsHarvestable(BlockPos pos) {
            return !FarmerBeeEntity.this.findHarvestablesNearby(pos, 0.0).isEmpty();
        }
    }
}

