/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.entity.bee.hive;

import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBeeEntity;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class HoarderBeeEntity
extends ProductiveBeeEntity {
    protected static final DataParameter<Byte> PEEK_TICK = EntityDataManager.func_187226_a(HoarderBeeEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private float prevPeekAmount;
    private float peekAmount = 1.0f;
    public BlockPos targetItemPos = null;
    private final Inventory inventory = new Inventory(1);

    public HoarderBeeEntity(EntityType<? extends BeeEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    public boolean canSelfBreed() {
        return false;
    }

    @Override
    protected void func_184651_r() {
        this.registerBaseGoals();
        this.field_70714_bg.func_85156_a((Goal)this.breedGoal);
        this.field_70714_bg.func_75776_a(4, (Goal)new PickupItemGoal());
        this.field_70714_bg.func_75776_a(6, (Goal)new LocateItemGoal());
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PEEK_TICK, (Object)100);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        float f1 = (float)this.getPeekTick() * 0.01f;
        this.prevPeekAmount = this.peekAmount;
        if (this.peekAmount > f1) {
            this.peekAmount = MathHelper.func_76131_a((float)(this.peekAmount - 0.05f), (float)f1, (float)1.0f);
        } else if (this.peekAmount < f1) {
            this.peekAmount = MathHelper.func_76131_a((float)(this.peekAmount + 0.05f), (float)0.0f, (float)f1);
        }
    }

    public int getPeekTick() {
        return ((Byte)this.field_70180_af.func_187225_a(PEEK_TICK)).byteValue();
    }

    public float getClientPeekAmount(float p_184688_1_) {
        return MathHelper.func_219799_g((float)p_184688_1_, (float)this.prevPeekAmount, (float)this.peekAmount);
    }

    @Override
    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        this.field_70180_af.func_187227_b(PEEK_TICK, (Object)tag.func_74771_c("Peek"));
        if (tag.func_74764_b("targetItemPos")) {
            this.targetItemPos = NBTUtil.func_186861_c((CompoundNBT)tag.func_74775_l("targetItemPos"));
        }
        if (tag.func_74764_b("inventory")) {
            ListNBT listnbt = tag.func_150295_c("inventory", 10);
            for (int i = 0; i < listnbt.size(); ++i) {
                ItemStack itemstack = ItemStack.func_199557_a((CompoundNBT)listnbt.func_150305_b(i));
                if (itemstack.func_190926_b()) continue;
                this.inventory.func_174894_a(itemstack);
            }
            tag.func_82580_o("inventory");
        }
    }

    @Override
    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74774_a("Peek", ((Byte)this.field_70180_af.func_187225_a(PEEK_TICK)).byteValue());
        if (this.targetItemPos != null) {
            tag.func_218657_a("targetItemPos", (INBT)NBTUtil.func_186859_a((BlockPos)this.targetItemPos));
        }
        if (!this.inventory.func_191420_l()) {
            ListNBT listnbt = new ListNBT();
            for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
                ItemStack itemstack = this.inventory.func_70301_a(i);
                if (itemstack.func_190926_b()) continue;
                listnbt.add((Object)itemstack.func_77955_b(new CompoundNBT()));
            }
            tag.func_218657_a("inventory", (INBT)listnbt);
        }
    }

    public void openAbdomen() {
        this.field_70180_af.func_187227_b(PEEK_TICK, (Object)0);
    }

    public void closeAbdomen() {
        this.field_70180_af.func_187227_b(PEEK_TICK, (Object)100);
    }

    public boolean holdsItem() {
        return !this.inventory.func_191420_l();
    }

    public ItemStack getItem() {
        return this.inventory.func_70301_a(0);
    }

    public void clearInventory() {
        this.inventory.func_174888_l();
    }

    @Override
    public boolean func_226415_eI_() {
        return this.holdsItem() || super.func_226415_eI_();
    }

    public void func_70645_a(@Nonnull DamageSource damageSource) {
        super.func_70645_a(damageSource);
        if (this.holdsItem()) {
            InventoryHelper.func_180175_a((World)this.field_70170_p, (BlockPos)this.func_180425_c(), (IInventory)this.inventory);
        }
    }

    public List<ItemEntity> getItemsNearby(double distance) {
        return this.getItemsNearby(this.func_180425_c(), distance);
    }

    public List<ItemEntity> getItemsNearby(BlockPos pos, double distance) {
        return this.field_70170_p.func_217357_a(ItemEntity.class, new AxisAlignedBB(pos).func_72314_b(distance, distance, distance));
    }

    public class LocateItemGoal
    extends Goal {
        private int ticks = 0;

        public boolean func_75250_a() {
            List<ItemEntity> items;
            boolean canStart;
            boolean bl = canStart = !HoarderBeeEntity.this.holdsItem() && !HoarderBeeEntity.this.func_226427_ez_();
            if (canStart && !(items = HoarderBeeEntity.this.getItemsNearby(10.0)).isEmpty()) {
                ItemEntity nearestItem = null;
                double nearestItemDistance = 0.0;
                int i = 0;
                for (ItemEntity item : items) {
                    double distance = item.func_180425_c().func_177951_i((Vec3i)HoarderBeeEntity.this.func_180425_c());
                    if (nearestItemDistance == 0.0 || distance < nearestItemDistance) {
                        nearestItemDistance = distance;
                        nearestItem = item;
                    }
                    if (++i <= 10) continue;
                    break;
                }
                HoarderBeeEntity.this.targetItemPos = nearestItem.func_180425_c();
                return true;
            }
            return false;
        }

        public boolean func_75253_b() {
            return HoarderBeeEntity.this.targetItemPos != null && HoarderBeeEntity.this.func_226409_eA_() && !HoarderBeeEntity.this.holdsItem() && !HoarderBeeEntity.this.func_226427_ez_();
        }

        public void func_75249_e() {
            this.ticks = 0;
        }

        public void func_75251_c() {
            this.ticks = 0;
            HoarderBeeEntity.this.closeAbdomen();
        }

        public void func_75246_d() {
            ++this.ticks;
            if (HoarderBeeEntity.this.targetItemPos != null) {
                if (this.ticks > 600) {
                    HoarderBeeEntity.this.targetItemPos = null;
                } else {
                    Vec3d vec3d = new Vec3d((Vec3i)HoarderBeeEntity.this.targetItemPos).func_72441_c(0.5, (double)0.6f, 0.5);
                    double distanceToTarget = vec3d.func_72438_d(HoarderBeeEntity.this.func_213303_ch());
                    if (distanceToTarget < 2.0 && distanceToTarget > 0.2) {
                        HoarderBeeEntity.this.openAbdomen();
                    }
                    if (distanceToTarget > 1.0) {
                        this.moveToNextTarget(vec3d);
                    } else if (distanceToTarget > 0.1 && this.ticks > 600) {
                        HoarderBeeEntity.this.targetItemPos = null;
                    } else {
                        List<ItemEntity> items = HoarderBeeEntity.this.getItemsNearby(0.0);
                        if (!items.isEmpty()) {
                            ItemEntity item = items.iterator().next();
                            ItemStack itemstack = item.func_92059_d().func_77946_l();
                            ItemStack remaining = HoarderBeeEntity.this.inventory.func_174894_a(itemstack);
                            if (remaining.func_190926_b()) {
                                item.func_70106_y();
                            } else {
                                item.func_92058_a(remaining);
                            }
                            HoarderBeeEntity.this.closeAbdomen();
                            HoarderBeeEntity.this.func_184185_a(SoundEvents.field_226129_ad_, 1.0f, 1.0f);
                        }
                    }
                }
            }
        }

        private void moveToNextTarget(Vec3d nextTarget) {
            HoarderBeeEntity.this.func_70605_aq().func_75642_a(nextTarget.func_82615_a(), nextTarget.func_82617_b(), nextTarget.func_82616_c(), 1.0);
        }
    }

    public class PickupItemGoal
    extends Goal {
        private int ticks = 0;

        public boolean func_75250_a() {
            if (HoarderBeeEntity.this.targetItemPos != null && !this.positionHasItemEntity(HoarderBeeEntity.this.targetItemPos)) {
                HoarderBeeEntity.this.targetItemPos = null;
            }
            return HoarderBeeEntity.this.targetItemPos != null && !HoarderBeeEntity.this.holdsItem() && !HoarderBeeEntity.this.func_226427_ez_() && !HoarderBeeEntity.this.func_226401_b_(HoarderBeeEntity.this.targetItemPos, 2);
        }

        public boolean func_75253_b() {
            return this.func_75250_a();
        }

        public void func_75249_e() {
            this.ticks = 0;
            super.func_75249_e();
        }

        public void func_75246_d() {
            if (HoarderBeeEntity.this.targetItemPos != null) {
                ++this.ticks;
                if (this.ticks > 600) {
                    HoarderBeeEntity.this.targetItemPos = null;
                } else if (!HoarderBeeEntity.this.field_70699_by.func_226337_n_()) {
                    BlockPos itemPos = HoarderBeeEntity.this.targetItemPos;
                    HoarderBeeEntity.this.field_70699_by.func_75492_a((double)itemPos.func_177958_n(), (double)itemPos.func_177956_o(), (double)itemPos.func_177952_p(), 1.0);
                }
            }
        }

        private boolean positionHasItemEntity(BlockPos pos) {
            return !HoarderBeeEntity.this.getItemsNearby(pos, 0.0).isEmpty();
        }
    }
}

