/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.entity.bee.solitary;

import cy.jdkdigital.productivebees.common.entity.bee.SolitaryBeeEntity;
import cy.jdkdigital.productivebees.init.ModAdvancements;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModPointOfInterestTypes;
import cy.jdkdigital.productivebees.init.ModTags;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tags.Tag;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class BumbleBeeEntity
extends SolitaryBeeEntity {
    private static final DataParameter<Boolean> SADDLED = EntityDataManager.func_187226_a(BumbleBeeEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> BOOST_TIME = EntityDataManager.func_187226_a(BumbleBeeEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private boolean boosting;
    private int boostTime;
    private int totalBoostTime;

    public BumbleBeeEntity(EntityType<? extends BeeEntity> entityType, World world) {
        super(entityType, world);
        this.beehiveInterests = poiType -> poiType == ModPointOfInterestTypes.BUMBLE_BEE_NEST.get();
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(4, (Goal)new TemptGoal((CreatureEntity)this, 1.2, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ModItems.TREAT_ON_A_STICK.get()}), false));
    }

    @Override
    public String getRenderer() {
        return "thicc";
    }

    @Override
    public Tag<Block> getNestingTag() {
        return ModTags.BUMBLE_BEE_NESTS;
    }

    public void func_184206_a(DataParameter<?> dataParameter) {
        if (BOOST_TIME.equals(dataParameter) && this.field_70170_p.field_72995_K) {
            this.boosting = true;
            this.boostTime = 0;
            this.totalBoostTime = (Integer)this.field_70180_af.func_187225_a(BOOST_TIME);
        }
        super.func_184206_a(dataParameter);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SADDLED, (Object)false);
        this.field_70180_af.func_187214_a(BOOST_TIME, (Object)0);
    }

    public void setSaddled(boolean saddled) {
        if (saddled) {
            this.field_70180_af.func_187227_b(SADDLED, (Object)true);
        } else {
            this.field_70180_af.func_187227_b(SADDLED, (Object)false);
        }
    }

    public boolean getSaddled() {
        return (Boolean)this.field_70180_af.func_187225_a(SADDLED);
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        if (super.func_184645_a(player, hand) || player.func_184614_ca().func_77973_b().equals(ModItems.HONEY_TREAT.get())) {
            return true;
        }
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77973_b().equals(Items.field_151057_cb)) {
            return itemstack.func_111282_a(player, (LivingEntity)this, hand);
        }
        if (this.getSaddled() && !this.func_184207_aI()) {
            if (!this.field_70170_p.field_72995_K) {
                player.func_184220_m((Entity)this);
            }
            return true;
        }
        if (itemstack.func_77973_b() == Items.field_151141_av && this.func_70089_S() && !this.getSaddled() && !this.func_70631_g_() && player instanceof ServerPlayerEntity) {
            this.setSaddled(true);
            this.field_70170_p.func_184148_a(player, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187706_dO, SoundCategory.NEUTRAL, 0.5f, 1.0f);
            ModAdvancements.SADDLE_BEE.trigger((ServerPlayerEntity)player, this);
            itemstack.func_190918_g(1);
            return true;
        }
        return false;
    }

    protected void func_213337_cE() {
        super.func_213337_cE();
        if (this.getSaddled()) {
            this.func_199703_a((IItemProvider)Items.field_151141_av);
        }
    }

    public boolean func_82171_bF() {
        Entity entity = this.func_184179_bs();
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity playerentity = (PlayerEntity)entity;
        return playerentity.func_184614_ca().func_77973_b() == ModItems.TREAT_ON_A_STICK.get() || playerentity.func_184592_cb().func_77973_b() == ModItems.TREAT_ON_A_STICK.get();
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    @Override
    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74757_a("Saddle", this.getSaddled());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setSaddled(compound.func_74767_n("Saddle"));
    }

    @Override
    public float getSizeModifier() {
        return 1.25f;
    }

    public void func_213352_e(Vec3d vec3d) {
        if (this.func_70089_S()) {
            Entity rider;
            Entity entity = rider = this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
            if (this.func_184207_aI() && this.func_82171_bF() && rider != null) {
                this.field_70126_B = this.field_70177_z = rider.field_70177_z;
                this.field_70125_A = rider.field_70125_A * 0.5f;
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                this.field_70761_aq = this.field_70177_z;
                this.field_70759_as = this.field_70177_z;
                this.field_70138_W = 2.0f;
                this.field_70747_aH = this.func_70689_ay() * 0.1f;
                if (this.boosting && this.boostTime++ > this.totalBoostTime) {
                    this.boosting = false;
                }
                if (this.func_184186_bw()) {
                    float speed = (float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 0.225f;
                    if (this.boosting) {
                        speed += speed * 6.15f * MathHelper.func_76126_a((float)((float)this.boostTime / (float)this.totalBoostTime * (float)Math.PI));
                    }
                    this.func_70659_e(speed);
                    super.func_213352_e(new Vec3d(0.0, !this.field_70170_p.func_175623_d(this.func_180425_c().func_177979_c(3)) ? 1.0 : (this.field_70170_p.func_175623_d(this.func_180425_c().func_177979_c(1)) ? -1.0 : 0.0), 1.0));
                    this.field_70716_bi = 0;
                } else {
                    this.func_213317_d(Vec3d.field_186680_a);
                }
                this.field_184618_aE = this.field_70721_aZ;
                double lvt_3_2_ = this.func_226277_ct_() - this.field_70169_q;
                double lvt_5_1_ = this.func_226281_cx_() - this.field_70166_s;
                float lvt_7_1_ = MathHelper.func_76133_a((double)(lvt_3_2_ * lvt_3_2_ + lvt_5_1_ * lvt_5_1_)) * 4.0f;
                if (lvt_7_1_ > 1.0f) {
                    lvt_7_1_ = 1.0f;
                }
                this.field_70721_aZ += (lvt_7_1_ - this.field_70721_aZ) * 0.4f;
                this.field_184619_aG += this.field_70721_aZ;
            } else {
                this.field_70138_W = 0.5f;
                this.field_70747_aH = 0.02f;
                super.func_213352_e(vec3d);
            }
        }
    }

    public boolean boost() {
        if (this.boosting) {
            return false;
        }
        this.boosting = true;
        this.boostTime = 0;
        this.totalBoostTime = this.func_70681_au().nextInt(841) + 140;
        this.func_184212_Q().func_187227_b(BOOST_TIME, (Object)this.totalBoostTime);
        return true;
    }
}

