/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.item;

import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBeeEntity;
import cy.jdkdigital.productivebees.init.ModAdvancements;
import cy.jdkdigital.productivebees.util.BeeHelper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.ModList;

public class BeeCage
extends Item {
    public BeeCage(Item.Properties properties) {
        super(properties);
        this.func_185043_a(new ResourceLocation("filled"), (itemStack, world, entity) -> BeeCage.isFilled(itemStack) ? 1.0f : 0.0f);
    }

    public static boolean isFilled(ItemStack itemStack) {
        return !itemStack.func_190926_b() && itemStack.func_196082_o().func_74764_b("entity");
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World playerWorld = context.func_195999_j().func_130014_f_();
        ItemStack stack = context.func_195996_i();
        if (playerWorld.func_201670_d() || !BeeCage.isFilled(stack)) {
            return ActionResultType.FAIL;
        }
        World worldIn = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        BeeEntity entity = BeeCage.getEntityFromStack(stack, worldIn, true);
        if ((entity = BeeHelper.convertToConfigurable(entity)) != null) {
            if (context.func_195999_j() != null && context.func_195999_j().func_225608_bj_()) {
                entity.field_226369_bI_ = null;
            }
            BlockPos blockPos = pos.func_177972_a(context.func_196000_l());
            entity.func_70080_a((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p() + 0.5, 0.0f, 0.0f);
            worldIn.func_217376_c((Entity)entity);
            this.postItemUse(context);
        }
        return ActionResultType.SUCCESS;
    }

    protected void postItemUse(ItemUseContext context) {
        context.func_195999_j().field_71071_by.func_184437_d(context.func_195996_i());
    }

    public boolean func_111207_a(ItemStack itemStack, PlayerEntity player, LivingEntity targetIn, Hand hand) {
        if (targetIn.func_130014_f_().func_201670_d() || !(targetIn instanceof BeeEntity) || !targetIn.func_70089_S() || BeeCage.isFilled(itemStack)) {
            return false;
        }
        BeeEntity target = (BeeEntity)targetIn;
        boolean addToInventory = true;
        ItemStack cageStack = new ItemStack((IItemProvider)itemStack.func_77973_b());
        if (itemStack.func_190916_E() == 1) {
            cageStack = itemStack;
            addToInventory = false;
        }
        BeeCage.captureEntity(target, cageStack);
        if (addToInventory || player.func_184812_l_()) {
            if (!player.field_71071_by.func_70441_a(cageStack)) {
                player.func_71019_a(cageStack, false);
            }
            itemStack.func_190918_g(1);
        }
        player.func_184609_a(hand);
        if (player instanceof ServerPlayerEntity) {
            ModAdvancements.CATCH_BEE.trigger((ServerPlayerEntity)player, cageStack);
        }
        target.remove(true);
        return true;
    }

    public static ItemStack captureEntity(BeeEntity target, ItemStack cageStack) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("entity", EntityType.func_200718_a((EntityType)target.func_200600_R()).toString());
        if (target.func_145818_k_()) {
            nbt.func_74778_a("name", target.func_200201_e().func_150254_d());
        } else {
            nbt.func_74778_a("name", target.func_200200_C_().func_150254_d());
        }
        target.func_189511_e(nbt);
        nbt.func_74757_a("isProductiveBee", target instanceof ProductiveBeeEntity);
        String modId = target.func_200600_R().getRegistryName().func_110624_b();
        String modName = ModList.get().getModObjectById(modId).get().getClass().getSimpleName();
        if (modId.equals("minecraft")) {
            modName = "Minecraft";
        }
        nbt.func_74778_a("mod", modName);
        cageStack.func_77982_d(nbt);
        return cageStack;
    }

    @Nullable
    public static BeeEntity getEntityFromStack(ItemStack stack, World world, boolean withInfo) {
        return BeeCage.getEntityFromStack(stack.func_196082_o(), world, withInfo);
    }

    @Nullable
    public static BeeEntity getEntityFromStack(CompoundNBT tag, World world, boolean withInfo) {
        EntityType type = EntityType.func_220327_a((String)tag.func_74779_i("entity")).orElse(null);
        if (type != null) {
            Entity entity = type.func_200721_a(world);
            if (withInfo) {
                entity.func_70020_e(tag);
            }
            if (entity instanceof BeeEntity) {
                return (BeeEntity)entity;
            }
        }
        return null;
    }

    @Nonnull
    public ITextComponent func_200295_i(ItemStack stack) {
        if (!BeeCage.isFilled(stack)) {
            return new TranslationTextComponent(this.func_77658_a(), new Object[0]);
        }
        String entityId = stack.func_77978_p().func_74779_i("name");
        return new TranslationTextComponent(this.func_77658_a(), new Object[0]).func_150258_a(" (" + entityId + ")");
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(stack, world, list, flag);
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null && !tag.equals((Object)new CompoundNBT())) {
            if (Screen.hasShiftDown()) {
                boolean hasStung = tag.func_74767_n("HasStung");
                if (hasStung) {
                    list.add(new TranslationTextComponent("productivebees.information.health.dying", new Object[0]).func_211708_a(TextFormatting.RED).func_211708_a(TextFormatting.ITALIC));
                }
                BeeHelper.populateBeeInfoFromTag(tag, list);
            } else {
                list.add(new TranslationTextComponent("productivebees.information.hold_shift", new Object[0]).func_211708_a(TextFormatting.WHITE));
            }
        }
    }
}

