/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.item;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.util.BeeAttribute;
import cy.jdkdigital.productivebees.util.BeeAttributes;
import cy.jdkdigital.productivebees.util.ColorUtil;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class Gene
extends Item {
    private static final String ATTRIBUTE_KEY = "productivebees_gene_attribute";
    private static final String VALUE_KEY = "productivebees_gene_value";
    private static final String PURITY_KEY = "productivebees_gene_purity";

    public Gene(Item.Properties properties) {
        super(properties);
    }

    public static ItemStack getStack(BeeAttribute<?> attribute, int value) {
        return Gene.getStack(attribute, value, 1);
    }

    public static ItemStack getStack(BeeAttribute<?> attribute, int value, int count) {
        return Gene.getStack(attribute, value, count, ProductiveBees.rand.nextInt(40) + 15);
    }

    public static ItemStack getStack(BeeAttribute<?> attribute, int value, int count, int purity) {
        return Gene.getStack(attribute.toString(), value, count, purity);
    }

    public static ItemStack getStack(String type, int value) {
        return Gene.getStack(type, 0, 1, value);
    }

    public static ItemStack getStack(String attribute, int value, int count, int purity) {
        ItemStack result = new ItemStack((IItemProvider)ModItems.GENE.get(), count);
        Gene.setAttribute(result, attribute, value, purity);
        return result;
    }

    public static void setAttribute(ItemStack stack, String attributeId, int value, int purity) {
        stack.func_196082_o().func_74778_a(ATTRIBUTE_KEY, attributeId);
        stack.func_196082_o().func_74768_a(VALUE_KEY, value);
        stack.func_196082_o().func_74768_a(PURITY_KEY, purity);
    }

    public static BeeAttribute<?> getAttribute(ItemStack stack) {
        String name = Gene.getAttributeName(stack);
        return BeeAttributes.getAttributeByName(name);
    }

    public static String getAttributeName(ItemStack stack) {
        return stack.func_196082_o().func_74779_i(ATTRIBUTE_KEY);
    }

    public static Integer getValue(ItemStack stack) {
        return stack.func_196082_o().func_74762_e(VALUE_KEY);
    }

    public static Integer getPurity(ItemStack stack) {
        return stack.func_196082_o().func_74762_e(PURITY_KEY);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(stack, world, list, flag);
        Integer value = Gene.getValue(stack);
        BeeAttribute<?> attribute = Gene.getAttribute(stack);
        if (attribute != null) {
            ITextComponent translated_value = new TranslationTextComponent(BeeAttributes.keyMap.get(attribute).get(value), new Object[0]).func_211708_a(ColorUtil.getColor(value));
            list.add(new TranslationTextComponent("productivebees.information.attribute." + Gene.getAttributeName(stack), new Object[]{translated_value}).func_211708_a(TextFormatting.DARK_GRAY).func_150258_a(" (" + Gene.getPurity(stack) + "%)"));
        } else {
            String type = Gene.getAttributeName(stack);
            list.add(new TranslationTextComponent("productivebees.information.attribute.type", new Object[]{type}).func_211708_a(TextFormatting.DARK_GRAY).func_150258_a(" (" + Gene.getPurity(stack) + "%)"));
        }
    }

    public void func_150895_a(@Nonnull ItemGroup group, @Nonnull NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            items.add((Object)Gene.getStack(BeeAttributes.PRODUCTIVITY, 0, 1, 100));
            items.add((Object)Gene.getStack(BeeAttributes.PRODUCTIVITY, 1, 1, 100));
            items.add((Object)Gene.getStack(BeeAttributes.PRODUCTIVITY, 2, 1, 100));
            items.add((Object)Gene.getStack(BeeAttributes.PRODUCTIVITY, 3, 1, 100));
            items.add((Object)Gene.getStack(BeeAttributes.WEATHER_TOLERANCE, 0, 1, 100));
            items.add((Object)Gene.getStack(BeeAttributes.WEATHER_TOLERANCE, 1, 1, 100));
            items.add((Object)Gene.getStack(BeeAttributes.WEATHER_TOLERANCE, 2, 1, 100));
            items.add((Object)Gene.getStack(BeeAttributes.BEHAVIOR, 0, 1, 100));
            items.add((Object)Gene.getStack(BeeAttributes.BEHAVIOR, 1, 1, 100));
            items.add((Object)Gene.getStack(BeeAttributes.BEHAVIOR, 2, 1, 100));
            items.add((Object)Gene.getStack(BeeAttributes.TEMPER, 0, 1, 100));
            items.add((Object)Gene.getStack(BeeAttributes.TEMPER, 1, 1, 100));
            items.add((Object)Gene.getStack(BeeAttributes.TEMPER, 2, 1, 100));
            items.add((Object)Gene.getStack(BeeAttributes.ENDURANCE, 0, 1, 100));
            items.add((Object)Gene.getStack(BeeAttributes.ENDURANCE, 1, 1, 100));
            items.add((Object)Gene.getStack(BeeAttributes.ENDURANCE, 2, 1, 100));
            items.add((Object)Gene.getStack(BeeAttributes.ENDURANCE, 3, 1, 100));
        }
    }
}

