/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.item;

import cy.jdkdigital.productivebees.common.block.AdvancedBeehive;
import cy.jdkdigital.productivebees.common.block.SolitaryNest;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class NestLocator
extends Item {
    private static final String KEY = "productivebees_locator_nest";

    public NestLocator(Item.Properties properties) {
        super(properties);
        this.func_185043_a(new ResourceLocation("angle"), new IItemPropertyGetter(){
            private double rotation;
            private double rota;
            private long lastUpdateTick;

            public float call(@Nonnull ItemStack stack, @Nullable World world, @Nullable LivingEntity player) {
                if ((player != null || stack.func_82839_y()) && NestLocator.hasPosition(stack)) {
                    LivingEntity entity;
                    boolean flag = player != null;
                    Object object = entity = flag ? player : stack.func_82836_z();
                    if (world == null) {
                        world = entity.field_70170_p;
                    }
                    double d1 = flag ? (double)entity.field_70177_z : this.getFrameRotation((ItemFrameEntity)entity);
                    d1 = MathHelper.func_191273_b((double)(d1 / 360.0), (double)1.0);
                    double d2 = this.getPositionToAngle(NestLocator.getPosition(stack), (Entity)entity) / 6.2831854820251465;
                    double d0 = 0.5 - (d1 - 0.25 - d2);
                    if (flag) {
                        d0 = this.wobble(world, d0);
                    }
                    return MathHelper.func_188207_b((float)((float)d0), (float)1.0f);
                }
                return 0.0f;
            }

            private double wobble(World worldIn, double amount) {
                if (worldIn.func_82737_E() != this.lastUpdateTick) {
                    this.lastUpdateTick = worldIn.func_82737_E();
                    double d0 = amount - this.rotation;
                    d0 = MathHelper.func_191273_b((double)(d0 + 0.5), (double)1.0) - 0.5;
                    this.rota += d0 * 0.1;
                    this.rota *= 0.8;
                    this.rotation = MathHelper.func_191273_b((double)(this.rotation + this.rota), (double)1.0);
                }
                return this.rotation;
            }

            private double getFrameRotation(ItemFrameEntity frameEntity) {
                return MathHelper.func_188209_b((int)(180 + frameEntity.func_174811_aO().func_176736_b() * 90));
            }

            private double getPositionToAngle(BlockPos blockpos, Entity entityIn) {
                return Math.atan2((double)blockpos.func_177952_p() - entityIn.func_226281_cx_(), (double)blockpos.func_177958_n() - entityIn.func_226277_ct_());
            }
        });
    }

    public static String getNestName(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o().func_74775_l(KEY);
        return nbt.func_74764_b("nest") ? nbt.func_74779_i("nest") : null;
    }

    public static Block getNestBlock(ItemStack stack) {
        String nestName = NestLocator.getNestName(stack);
        if (nestName != null) {
            return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nestName));
        }
        return null;
    }

    public static void setNestBlock(ItemStack stack, @Nullable Block nest) {
        CompoundNBT nbt = stack.func_196082_o().func_74775_l(KEY);
        nbt.func_82580_o("nest");
        if (nest != null && nest.getRegistryName() != null) {
            nbt.func_74778_a("nest", nest.getRegistryName().toString());
        }
        stack.func_196082_o().func_218657_a(KEY, (INBT)nbt);
    }

    public static boolean hasNest(ItemStack stack) {
        return NestLocator.getNestName(stack) != null;
    }

    public static BlockPos getPosition(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o().func_74775_l(KEY);
        return nbt.func_74764_b("position") ? BlockPos.func_218283_e((long)nbt.func_74763_f("position")) : null;
    }

    public static void setPosition(ItemStack stack, @Nullable BlockPos pos) {
        CompoundNBT nbt = stack.func_196082_o().func_74775_l(KEY);
        if (pos != null) {
            nbt.func_74772_a("position", pos.func_218275_a());
        } else {
            nbt.func_82580_o("position");
        }
        stack.func_196082_o().func_218657_a(KEY, (INBT)nbt);
    }

    public static boolean hasPosition(ItemStack stack) {
        return NestLocator.getPosition(stack) != null;
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        if (!world.field_72995_K && context.func_195999_j() != null && context.func_195999_j().func_225608_bj_()) {
            ItemStack stack = context.func_195999_j().func_184586_b(context.func_221531_n());
            BlockState state = world.func_180495_p(context.func_195995_a());
            Block block = state.func_177230_c();
            if (block instanceof BeehiveBlock || block instanceof AdvancedBeehive) {
                NestLocator.setNestBlock(stack, (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("minecraft", "bee_nest")));
            } else if (block instanceof SolitaryNest) {
                NestLocator.setNestBlock(stack, block);
            } else {
                ItemStack in = new ItemStack((IItemProvider)block.func_199767_j());
                block0: for (IRecipe recipe : world.func_199532_z().func_215366_a(IRecipeType.field_222149_a).values()) {
                    for (Ingredient s : recipe.func_192400_c()) {
                        for (ItemStack ss : s.func_193365_a()) {
                            Block foundBlock;
                            if (!ss.func_77973_b().equals(in.func_77973_b())) continue;
                            ItemStack output = recipe.func_77571_b();
                            if (!(output.func_77973_b() instanceof BlockItem) || !((foundBlock = (Block)ForgeRegistries.BLOCKS.getValue(output.func_77973_b().getRegistryName())) instanceof SolitaryNest)) continue block0;
                            NestLocator.setNestBlock(stack, foundBlock);
                            break block0;
                        }
                    }
                }
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_195939_a(context);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        if (!world.field_72995_K) {
            ItemStack stack = player.func_184586_b(hand);
            if (!player.func_225608_bj_()) {
                Map.Entry<Double, BlockPos> nearest;
                Predicate<Block> predicate = o -> o instanceof BeehiveBlock;
                if (NestLocator.hasNest(stack)) {
                    predicate = o -> o.equals(NestLocator.getNestBlock(stack));
                }
                if ((nearest = this.findNearestNest(world, player.func_180425_c(), 16, predicate)) != null) {
                    NestLocator.setPosition(stack, nearest.getValue());
                } else {
                    NestLocator.setPosition(stack, null);
                }
            }
            return ActionResult.func_226248_a_((Object)player.func_184586_b(hand));
        }
        return ActionResult.func_226250_c_((Object)player.func_184586_b(hand));
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, world, tooltip, flagIn);
        if (NestLocator.hasNest(stack)) {
            tooltip.add(new TranslationTextComponent("productivebees.information.nestlocator.configured", new Object[]{NestLocator.getNestName(stack)}).func_211708_a(TextFormatting.GOLD));
        } else {
            tooltip.add(new TranslationTextComponent("productivebees.information.nestlocator.unconfigured", new Object[0]).func_211708_a(TextFormatting.GOLD));
        }
    }

    private Map.Entry<Double, BlockPos> findNearestNest(World world, BlockPos pos, int distance, Predicate<Block> predicate) {
        Vec3d playerPos = new Vec3d((Vec3i)pos);
        TreeMap nearbyNestPositions = new TreeMap();
        long start = System.currentTimeMillis();
        BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-distance, -distance, -distance), (BlockPos)pos.func_177982_a(distance, distance, distance)).forEach(blockPos -> {
            double distanceToNest;
            BlockState state = world.func_180495_p(blockPos);
            if (predicate.test(state.func_177230_c()) && !nearbyNestPositions.containsKey(distanceToNest = playerPos.func_72438_d(new Vec3d((Vec3i)blockPos)))) {
                nearbyNestPositions.put(distanceToNest, new BlockPos((Vec3i)blockPos));
            }
        });
        long finish = System.currentTimeMillis();
        if (!nearbyNestPositions.isEmpty()) {
            return nearbyNestPositions.pollFirstEntry();
        }
        return null;
    }
}

