/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.tileentity;

import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.block.AdvancedBeehive;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBeeEntity;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBeeEntity;
import cy.jdkdigital.productivebees.common.tileentity.AdvancedBeehiveTileEntityAbstract;
import cy.jdkdigital.productivebees.common.tileentity.InventoryHandlerHelper;
import cy.jdkdigital.productivebees.common.tileentity.UpgradeableTileEntity;
import cy.jdkdigital.productivebees.container.AdvancedBeehiveContainer;
import cy.jdkdigital.productivebees.handler.bee.CapabilityBee;
import cy.jdkdigital.productivebees.init.ModEntities;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModTileEntityTypes;
import cy.jdkdigital.productivebees.state.properties.VerticalHive;
import cy.jdkdigital.productivebees.util.BeeAttributes;
import cy.jdkdigital.productivebees.util.BeeHelper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.BeehiveTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class AdvancedBeehiveTileEntity
extends AdvancedBeehiveTileEntityAbstract
implements INamedContainerProvider,
UpgradeableTileEntity {
    protected int tickCounter = 0;
    private int abandonCountdown = 0;
    protected boolean hasTicked = false;
    protected LazyOptional<IItemHandlerModifiable> inventoryHandler = LazyOptional.of(() -> new InventoryHandlerHelper.ItemHandler(11, (TileEntity)this));
    protected LazyOptional<IItemHandlerModifiable> upgradeHandler = LazyOptional.of(() -> new InventoryHandlerHelper.UpgradeHandler(4, (TileEntity)this));

    public AdvancedBeehiveTileEntity(TileEntityType<?> tileEntityType) {
        super(tileEntityType);
    }

    public AdvancedBeehiveTileEntity() {
        this((TileEntityType)ModTileEntityTypes.ADVANCED_BEEHIVE.get());
        this.MAX_BEES = 3;
    }

    @Nonnull
    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity player) {
        return new AdvancedBeehiveContainer(windowId, playerInventory, this);
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(this.func_195044_w().func_177230_c().func_149739_a(), new Object[0]);
    }

    public boolean func_226972_k_() {
        return true;
    }

    @Override
    public void func_73660_a() {
        BlockState blockState;
        World world = this.field_145850_b;
        if (world == null || world.func_201670_d()) {
            return;
        }
        if (!this.hasTicked && ++this.tickCounter > (Integer)ProductiveBeesConfig.GENERAL.hiveTickRate.get()) {
            EntityType beeType;
            ConfigurableBeeEntity newBee;
            this.tickCounter = 0;
            ListNBT beeList = this.getBeeListAsNBTList();
            if (world.func_226690_K_() && ((Boolean)ProductiveBeesConfig.BEES.spawnUndeadBees.get()).booleanValue() && world.field_73012_v.nextDouble() <= (Double)ProductiveBeesConfig.BEES.spawnUndeadBeesChance.get() && beeList.size() + this.beesOutsideHive() == 0 && world.func_201696_r(this.field_174879_c.func_177967_a((Direction)this.func_195044_w().func_177229_b((IProperty)BeehiveBlock.field_226872_b_), 1)) <= 8 && (newBee = (ConfigurableBeeEntity)(beeType = (EntityType)ModEntities.CONFIGURABLE_BEE.get()).func_200721_a(world)) != null) {
                if (world.field_73012_v.nextBoolean()) {
                    newBee.setBeeType("productivebees:skeletal");
                } else {
                    newBee.setBeeType("productivebees:zombie");
                }
                newBee.setAttributes();
                this.func_226961_a_((Entity)newBee, false);
            }
        }
        if (!this.hasTicked && this.tickCounter % 23 == 0 && (blockState = this.func_195044_w()).func_177230_c() instanceof AdvancedBeehive) {
            int honeyLevel = (Integer)blockState.func_177229_b((IProperty)BeehiveBlock.field_226873_c_);
            if (honeyLevel >= 5) {
                int finalHoneyLevel = honeyLevel;
                this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(inv -> {
                    ItemStack filledBottle;
                    boolean addedBottle;
                    ItemStack bottles = inv.getStackInSlot(0);
                    if (!bottles.func_190926_b() && (addedBottle = ((InventoryHandlerHelper.ItemHandler)((Object)inv)).addOutput(filledBottle = new ItemStack((IItemProvider)Items.field_226638_pX_)))) {
                        ((InventoryHandlerHelper.ItemHandler)((Object)inv)).addOutput(new ItemStack((IItemProvider)Items.field_226635_pU_));
                        bottles.func_190918_g(1);
                        world.func_175656_a(this.field_174879_c, (BlockState)blockState.func_206870_a((IProperty)BeehiveBlock.field_226873_c_, (Comparable)Integer.valueOf(finalHoneyLevel - 5)));
                    }
                });
                honeyLevel = (Integer)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BeehiveBlock.field_226873_c_);
            }
            if (blockState.func_177229_b(AdvancedBeehive.EXPANDED) != VerticalHive.NONE && honeyLevel >= AdvancedBeehiveTileEntity.getMaxHoneyLevel(blockState)) {
                ((AdvancedBeehive)blockState.func_177230_c()).updateState(world, this.func_174877_v(), blockState, false);
            }
        }
        if (--this.abandonCountdown < 0) {
            this.abandonCountdown = 0;
        }
        super.func_73660_a();
        this.hasTicked = false;
    }

    @Override
    public LazyOptional<IItemHandlerModifiable> getUpgradeHandler() {
        return this.upgradeHandler;
    }

    @Override
    protected int getTimeInHive(boolean hasNectar, @Nullable BeeEntity beeEntity) {
        double combBlockUpgradeModifier = (double)this.getUpgradeCount((Item)ModItems.UPGRADE_COMB_BLOCK.get()) * (Double)ProductiveBeesConfig.UPGRADES.combBlockTimeModifier.get();
        double timeUpgradeModifier = 1.0 - (double)this.getUpgradeCount((Item)ModItems.UPGRADE_TIME.get()) * (Double)ProductiveBeesConfig.UPGRADES.timeBonus.get();
        return (int)((double)super.getTimeInHive(hasNectar, beeEntity) * Math.max(0.0, timeUpgradeModifier + combBlockUpgradeModifier));
    }

    @Override
    protected void beeReleasePostAction(BeeEntity beeEntity, BlockState state, BeehiveTileEntity.State beeState) {
        List bees;
        int breedingUpgrades;
        super.beeReleasePostAction(beeEntity, state, beeState);
        if (this.field_145850_b != null && beeState == BeehiveTileEntity.State.HONEY_DELIVERED) {
            this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(inv -> BeeHelper.getBeeProduce(this.field_145850_b, beeEntity, this.getUpgradeCount((Item)ModItems.UPGRADE_COMB_BLOCK.get()) > 0).forEach(stackIn -> {
                ItemStack stack = stackIn.func_77946_l();
                if (!stack.func_190926_b()) {
                    int productivityUpgrades;
                    int productivity;
                    if (beeEntity instanceof ProductiveBeeEntity && (productivity = ((ProductiveBeeEntity)beeEntity).getAttributeValue(BeeAttributes.PRODUCTIVITY).intValue()) > 0) {
                        float modifier = (1.0f / ((float)productivity + 2.0f) + ((float)productivity + 1.0f) / 2.0f) * (float)stack.func_190916_E();
                        stack.func_190917_f(Math.round(modifier));
                    }
                    if ((productivityUpgrades = this.getUpgradeCount((Item)ModItems.UPGRADE_PRODUCTIVITY.get())) > 0) {
                        double upgradeMod = (double)stack.func_190916_E() * ((Double)ProductiveBeesConfig.UPGRADES.productivityMultiplier.get() * (double)productivityUpgrades);
                        stack.func_190920_e(Math.round((float)upgradeMod));
                    }
                    ((InventoryHandlerHelper.ItemHandler)((Object)inv)).addOutput(stack);
                }
            }));
        }
        if ((breedingUpgrades = this.getUpgradeCount((Item)ModItems.UPGRADE_BREEDING.get())) > 0 && !beeEntity.func_70631_g_() && this.func_226971_j_() > 0 && (double)this.field_145850_b.field_73012_v.nextFloat() <= (Double)ProductiveBeesConfig.UPGRADES.breedingChance.get() * (double)breedingUpgrades && (bees = this.field_145850_b.func_217357_a(BeeEntity.class, new AxisAlignedBB(this.field_174879_c).func_72314_b(3.0, 3.0, 3.0))).size() < (Integer)ProductiveBeesConfig.UPGRADES.breedingMaxNearbyEntities.get()) {
            AdvancedBeehiveTileEntityAbstract.Inhabitant otherBeeInhabitant = this.getBeeList().get(this.field_145850_b.field_73012_v.nextInt(this.func_226971_j_()));
            BeeEntity otherBee = (BeeEntity)EntityType.func_220335_a((CompoundNBT)otherBeeInhabitant.nbt, (World)this.field_145850_b, spawnedEntity -> spawnedEntity);
            BeeEntity offspring = BeeHelper.getBreedingResult(beeEntity, (AgeableEntity)otherBee, this.field_145850_b);
            if (offspring != null) {
                if (offspring instanceof ProductiveBeeEntity && beeEntity instanceof ProductiveBeeEntity) {
                    BeeHelper.setOffspringAttributes((ProductiveBeeEntity)offspring, (ProductiveBeeEntity)beeEntity, (AgeableEntity)otherBee);
                }
                offspring.func_70873_a(-24000);
                offspring.func_70012_b(beeEntity.func_226277_ct_(), beeEntity.func_226278_cu_(), beeEntity.func_226281_cx_(), 0.0f, 0.0f);
                this.field_145850_b.func_217376_c((Entity)offspring);
            }
        }
        this.abandonCountdown += this.getTimeInHive(true, beeEntity);
    }

    protected int beesOutsideHive() {
        return (int)Math.ceil(this.abandonCountdown % this.getTimeInHive(true, null));
    }

    @Override
    public boolean acceptsUpgrades() {
        return this.func_195044_w().func_177229_b(AdvancedBeehive.EXPANDED) != VerticalHive.NONE;
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        CompoundNBT invTag = tag.func_74775_l("inv");
        this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(inv -> ((INBTSerializable)inv).deserializeNBT((INBT)invTag));
        CompoundNBT upgradesTag = tag.func_74775_l("upgrades");
        this.upgradeHandler.ifPresent(inv -> ((INBTSerializable)inv).deserializeNBT((INBT)upgradesTag));
        this.MAX_BEES = tag.func_74764_b("max_bees") ? tag.func_74762_e("max_bees") : this.MAX_BEES;
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(inv -> {
            CompoundNBT compound = (CompoundNBT)((INBTSerializable)inv).serializeNBT();
            tag.func_218657_a("inv", (INBT)compound);
        });
        this.upgradeHandler.ifPresent(inv -> {
            CompoundNBT compound = (CompoundNBT)((INBTSerializable)inv).serializeNBT();
            tag.func_218657_a("upgrades", (INBT)compound);
        });
        tag.func_74768_a("max_bees", this.MAX_BEES);
        return tag;
    }

    @Override
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a("bees", (INBT)this.getBeeListAsNBTList());
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, tag);
    }

    @Override
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT tag = pkt.func_148857_g();
        if (tag.func_74764_b("bees")) {
            this.getCapability(CapabilityBee.BEE).ifPresent(inhabitantHandler -> inhabitantHandler.setInhabitantsFromListNBT((ListNBT)tag.func_74781_a("bees")));
        }
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryHandler.cast();
        }
        return super.getCapability(cap, side);
    }
}

