/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.tileentity;

import cy.jdkdigital.productivebees.common.item.BeeCage;
import cy.jdkdigital.productivebees.common.tileentity.FluidTankTileEntity;
import cy.jdkdigital.productivebees.common.tileentity.InventoryHandlerHelper;
import cy.jdkdigital.productivebees.common.tileentity.UpgradeableTileEntity;
import cy.jdkdigital.productivebees.container.CatcherContainer;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModTileEntityTypes;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class CatcherTileEntity
extends FluidTankTileEntity
implements INamedContainerProvider,
ITickableTileEntity,
UpgradeableTileEntity {
    protected int tickCounter = 0;
    private LazyOptional<IItemHandlerModifiable> inventoryHandler = LazyOptional.of(() -> new InventoryHandlerHelper.ItemHandler(11, this){

        @Override
        public boolean isBottleItem(Item item) {
            return item == ModItems.BEE_CAGE.get();
        }
    });
    protected LazyOptional<IItemHandlerModifiable> upgradeHandler = LazyOptional.of(() -> new InventoryHandlerHelper.UpgradeHandler(4, this));

    public CatcherTileEntity() {
        super((TileEntityType)ModTileEntityTypes.CATCHER.get());
    }

    @Override
    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && ++this.tickCounter % 69 == 0) {
            this.inventoryHandler.ifPresent(invHandler -> {
                ItemStack invItem;
                if (!invHandler.getStackInSlot(0).func_190926_b() && (invItem = invHandler.getStackInSlot(0)).func_77973_b() instanceof BeeCage && !BeeCage.isFilled(invItem)) {
                    List bees = this.field_145850_b.func_217357_a(BeeEntity.class, this.getBoundingBox());
                    int babeeUpgrades = this.getUpgradeCount((Item)ModItems.UPGRADE_BREEDING.get());
                    for (BeeEntity bee : bees) {
                        if (babeeUpgrades > 0 && !bee.func_70631_g_()) continue;
                        ItemStack cageStack = new ItemStack((IItemProvider)invItem.func_77973_b());
                        BeeCage.captureEntity(bee, cageStack);
                        if (!((InventoryHandlerHelper.ItemHandler)((Object)invHandler)).addOutput(cageStack)) continue;
                        bee.remove(true);
                        invItem.func_190918_g(1);
                    }
                }
            });
        }
        super.func_73660_a();
    }

    private AxisAlignedBB getBoundingBox() {
        int rangeUpgrades = this.getUpgradeCount((Item)ModItems.UPGRADE_RANGE.get());
        return new AxisAlignedBB(this.field_174879_c).func_72314_b((double)rangeUpgrades, 2.0 + (double)rangeUpgrades, (double)rangeUpgrades);
    }

    @Override
    public LazyOptional<IItemHandlerModifiable> getUpgradeHandler() {
        return this.upgradeHandler;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(((Block)ModBlocks.CATCHER.get()).func_149739_a(), new Object[0]);
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity player) {
        return new CatcherContainer(windowId, playerInventory, this);
    }
}

