/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.tileentity;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.block.Centrifuge;
import cy.jdkdigital.productivebees.common.item.Gene;
import cy.jdkdigital.productivebees.common.item.GeneBottle;
import cy.jdkdigital.productivebees.common.tileentity.FluidTankTileEntity;
import cy.jdkdigital.productivebees.common.tileentity.InventoryHandlerHelper;
import cy.jdkdigital.productivebees.common.tileentity.UpgradeableTileEntity;
import cy.jdkdigital.productivebees.container.CentrifugeContainer;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModTileEntityTypes;
import cy.jdkdigital.productivebees.recipe.CentrifugeRecipe;
import cy.jdkdigital.productivebees.util.BeeAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class CentrifugeTileEntity
extends FluidTankTileEntity
implements INamedContainerProvider,
ITickableTileEntity,
UpgradeableTileEntity {
    private CentrifugeRecipe currentRecipe = null;
    public int recipeProgress = 0;
    public int fluidId = 0;
    private int transferCooldown = -1;
    private LazyOptional<IItemHandlerModifiable> inventoryHandler = LazyOptional.of(() -> new InventoryHandlerHelper.ItemHandler(12, this){

        @Override
        public boolean isBottleItem(Item item) {
            return item == Items.field_151069_bo || item == Items.field_151133_ar;
        }

        @Override
        public boolean isInputSlotItem(int slot, Item item) {
            boolean isProcessableItem = item.equals(ModItems.GENE_BOTTLE.get()) || CentrifugeTileEntity.this.canProcessItemStack(new ItemStack((IItemProvider)item));
            return isProcessableItem && slot == 1 || !isProcessableItem && super.isInputSlotItem(slot, item);
        }
    });
    protected LazyOptional<IFluidHandler> fluidInventory = LazyOptional.of(() -> new InventoryHandlerHelper.FluidHandler(10000){

        protected void onContentsChanged() {
            super.onContentsChanged();
            CentrifugeTileEntity.this.fluidId = Registry.field_212619_h.func_148757_b((Object)this.getFluid().getFluid());
            CentrifugeTileEntity.this.func_70296_d();
        }
    });
    protected LazyOptional<IItemHandlerModifiable> upgradeHandler = LazyOptional.of(() -> new InventoryHandlerHelper.UpgradeHandler(4, this));

    public CentrifugeTileEntity() {
        super((TileEntityType)ModTileEntityTypes.CENTRIFUGE.get());
    }

    public CentrifugeTileEntity(TileEntityType<?> type) {
        super(type);
    }

    public int getProcessingTime() {
        return (int)((double)((Integer)ProductiveBeesConfig.GENERAL.centrifugeProcessingTime.get()).intValue() * this.getProcessingTimeModifier());
    }

    protected double getProcessingTimeModifier() {
        double combBlockUpgradeModifier = (double)this.getUpgradeCount((Item)ModItems.UPGRADE_COMB_BLOCK.get()) * (Double)ProductiveBeesConfig.UPGRADES.combBlockTimeModifier.get();
        double timeUpgradeModifier = 1.0 - (double)this.getUpgradeCount((Item)ModItems.UPGRADE_TIME.get()) * (Double)ProductiveBeesConfig.UPGRADES.timeBonus.get();
        return Math.max(0.0, timeUpgradeModifier + combBlockUpgradeModifier);
    }

    @Override
    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.inventoryHandler.ifPresent(invHandler -> {
                if (!invHandler.getStackInSlot(1).func_190926_b() && this.canOperate()) {
                    ItemStack invItem = invHandler.getStackInSlot(1);
                    if (invItem.func_77973_b().equals(ModItems.GENE_BOTTLE.get())) {
                        this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((IProperty)Centrifuge.RUNNING, (Comparable)Boolean.valueOf(true)));
                        int totalTime = this.getProcessingTime();
                        if (++this.recipeProgress >= totalTime) {
                            this.completeGeneProcessing((IItemHandlerModifiable)invHandler);
                            this.recipeProgress = 0;
                            this.func_70296_d();
                        }
                    } else {
                        CentrifugeRecipe recipe = this.getRecipe((IItemHandlerModifiable)invHandler);
                        if (this.canProcessRecipe(recipe, (IItemHandlerModifiable)invHandler)) {
                            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((IProperty)Centrifuge.RUNNING, (Comparable)Boolean.valueOf(true)));
                            int totalTime = this.getProcessingTime();
                            if (++this.recipeProgress >= totalTime) {
                                this.completeRecipeProcessing(recipe, (IItemHandlerModifiable)invHandler);
                                this.recipeProgress = 0;
                                this.func_70296_d();
                            }
                        }
                    }
                } else {
                    this.recipeProgress = 0;
                    this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((IProperty)Centrifuge.RUNNING, (Comparable)Boolean.valueOf(false)));
                }
                if (--this.transferCooldown <= 0) {
                    this.transferCooldown = 20;
                    this.pullItems((IItemHandlerModifiable)invHandler);
                }
            });
        }
        super.func_73660_a();
    }

    private void pullItems(IItemHandlerModifiable invHandler) {
        for (ItemEntity itementity : this.getCaptureItems()) {
            if (!this.canProcessItemStack(itementity.func_92059_d())) continue;
            CentrifugeTileEntity.captureItem(invHandler, itementity);
        }
    }

    private List<ItemEntity> getCaptureItems() {
        assert (this.field_145850_b != null);
        return Centrifuge.COLLECTION_AREA_SHAPE.func_197756_d().stream().flatMap(blockPos -> this.field_145850_b.func_175647_a(ItemEntity.class, blockPos.func_72317_d((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p()), EntityPredicates.field_94557_a).stream()).collect(Collectors.toList());
    }

    private static void captureItem(IItemHandlerModifiable invHandler, ItemEntity itemEntity) {
        ItemStack insertStack = itemEntity.func_92059_d().func_77946_l();
        ItemStack leftoverStack = invHandler.insertItem(1, insertStack, false);
        if (leftoverStack.func_190926_b()) {
            itemEntity.func_70106_y();
        } else {
            itemEntity.func_92058_a(leftoverStack);
        }
    }

    protected boolean canOperate() {
        return true;
    }

    @Override
    public LazyOptional<IItemHandlerModifiable> getUpgradeHandler() {
        return this.upgradeHandler;
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.field_145850_b != null) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
        }
    }

    public boolean canProcessItemStack(ItemStack stack) {
        InventoryHandlerHelper.ItemHandler inv = new InventoryHandlerHelper.ItemHandler(2, null);
        inv.setStackInSlot(1, stack);
        CentrifugeRecipe recipe = this.getRecipe((IItemHandlerModifiable)inv);
        return recipe != null;
    }

    private CentrifugeRecipe getRecipe(IItemHandlerModifiable inputHandler) {
        ItemStack input = inputHandler.getStackInSlot(1);
        if (input.func_190926_b() || input == ItemStack.field_190927_a || this.field_145850_b == null) {
            return null;
        }
        if (this.currentRecipe != null && this.currentRecipe.func_77569_a((IInventory)new RecipeWrapper(inputHandler), this.field_145850_b)) {
            return this.currentRecipe;
        }
        this.currentRecipe = this.field_145850_b.func_199532_z().func_215371_a(CentrifugeRecipe.CENTRIFUGE, (IInventory)new RecipeWrapper(inputHandler), this.field_145850_b).orElse(null);
        Map allRecipes = this.field_145850_b.func_199532_z().func_215366_a(CentrifugeRecipe.CENTRIFUGE);
        RecipeWrapper inv = new RecipeWrapper(inputHandler);
        for (Map.Entry entry : allRecipes.entrySet()) {
            CentrifugeRecipe recipe = (CentrifugeRecipe)entry.getValue();
            if (!recipe.func_77569_a((IInventory)inv, this.field_145850_b)) continue;
            this.currentRecipe = recipe;
            break;
        }
        return this.currentRecipe;
    }

    protected boolean canProcessRecipe(@Nullable CentrifugeRecipe recipe, IItemHandlerModifiable invHandler) {
        if (recipe != null) {
            ArrayList outputList = Lists.newArrayList();
            recipe.getRecipeOutputs().forEach((key, value) -> {
                ItemStack item = new ItemStack((IItemProvider)key.func_77973_b(), value.get(1).func_150287_d());
                outputList.add(item);
            });
            boolean fluidFlag = false;
            Pair<Fluid, Integer> fluidOutput = recipe.getFluidOutputs();
            if (fluidOutput != null) {
                fluidFlag = (Boolean)this.fluidInventory.map(h -> h.getFluidInTank(0).isEmpty() || h.getFluidInTank(0).getFluid().func_207187_a((Fluid)fluidOutput.getFirst())).orElse((Object)false);
            }
            return fluidFlag && ((InventoryHandlerHelper.ItemHandler)invHandler).canFitStacks(outputList);
        }
        return false;
    }

    private void completeRecipeProcessing(CentrifugeRecipe recipe, IItemHandlerModifiable invHandler) {
        if (this.canProcessRecipe(recipe, invHandler)) {
            recipe.getRecipeOutputs().forEach((itemStack, recipeValues) -> {
                if (ProductiveBees.rand.nextInt(100) <= recipeValues.get(2).func_150287_d()) {
                    int count = MathHelper.func_76136_a((Random)ProductiveBees.rand, (int)MathHelper.func_76141_d((float)recipeValues.get(0).func_150287_d()), (int)MathHelper.func_76141_d((float)recipeValues.get(1).func_150287_d()));
                    itemStack.func_190920_e(count);
                    ((InventoryHandlerHelper.ItemHandler)invHandler).addOutput((ItemStack)itemStack);
                }
            });
            invHandler.getStackInSlot(1).func_190918_g(1);
            Pair<Fluid, Integer> fluidOutput = recipe.getFluidOutputs();
            if (fluidOutput != null) {
                this.fluidInventory.ifPresent(fluidHandler -> fluidHandler.fill(new FluidStack((Fluid)fluidOutput.getFirst(), ((Integer)fluidOutput.getSecond()).intValue()), IFluidHandler.FluidAction.EXECUTE));
            }
        }
    }

    private void completeGeneProcessing(IItemHandlerModifiable invHandler) {
        ItemStack geneBottle = invHandler.getStackInSlot(1);
        CompoundNBT entityData = GeneBottle.getGenes(geneBottle);
        if (entityData == null) {
            return;
        }
        ArrayList<String> attributes = new ArrayList<String>(){
            {
                this.add("productivity");
                this.add("weather_tolerance");
                this.add("behavior");
                this.add("endurance");
                this.add("temper");
            }
        };
        double chance = (Double)ProductiveBeesConfig.BEE_ATTRIBUTES.geneExtractChance.get();
        for (String attributeName : attributes) {
            if (!(ProductiveBees.rand.nextDouble() <= chance)) continue;
            int value = entityData.func_74762_e("bee_" + attributeName);
            ((InventoryHandlerHelper.ItemHandler)invHandler).addOutput(Gene.getStack(BeeAttributes.getAttributeByName(attributeName), value));
        }
        if (ProductiveBees.rand.nextDouble() <= chance) {
            ((InventoryHandlerHelper.ItemHandler)invHandler).addOutput(Gene.getStack(entityData.func_74779_i("type"), ProductiveBees.rand.nextInt(10) + 5));
        }
        invHandler.getStackInSlot(1).func_190918_g(1);
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        this.recipeProgress = tag.func_74762_e("RecipeProgress");
        Fluid fluid = (Fluid)this.fluidInventory.map(fluidHandler -> fluidHandler.getFluidInTank(0).getFluid()).orElse((Object)Fluids.field_204541_a);
        this.fluidId = Registry.field_212619_h.func_148757_b((Object)fluid);
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag = super.func_189515_b(tag);
        tag.func_74768_a("RecipeProgress", this.recipeProgress);
        return tag;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryHandler.cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidInventory.cast();
        }
        return super.getCapability(cap, side);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(((Block)ModBlocks.CENTRIFUGE.get()).func_149739_a(), new Object[0]);
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity player) {
        return new CentrifugeContainer(windowId, playerInventory, this);
    }
}

