/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.tileentity;

import cy.jdkdigital.productivebees.common.tileentity.CapabilityTileEntity;
import cy.jdkdigital.productivebees.recipe.BottlerRecipe;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class FluidTankTileEntity
extends CapabilityTileEntity
implements ITickableTileEntity {
    private int tankTick = 0;

    public FluidTankTileEntity(TileEntityType<?> type) {
        super(type);
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && ++this.tankTick > 21) {
            this.tankTick = 0;
            this.tickFluidTank();
        }
    }

    public void tickFluidTank() {
        this.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).ifPresent(fluidHandler -> {
            FluidStack fluidStack = fluidHandler.getFluidInTank(0);
            if (fluidStack.getAmount() >= 0) {
                this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(invHandler -> {
                    ItemStack fluidContainerItem = invHandler.getStackInSlot(0);
                    ItemStack existingOutput = invHandler.getStackInSlot(11);
                    if (fluidContainerItem.func_190916_E() > 0 && (existingOutput.func_190926_b() || existingOutput.func_190916_E() < existingOutput.func_77976_d())) {
                        ArrayList<BottlerRecipe> recipes = new ArrayList<BottlerRecipe>();
                        Map allRecipes = this.field_145850_b.func_199532_z().func_215366_a(BottlerRecipe.BOTTLER);
                        for (Map.Entry entry : allRecipes.entrySet()) {
                            BottlerRecipe recipe = (BottlerRecipe)entry.getValue();
                            if (!recipe.matches(fluidStack, fluidContainerItem)) continue;
                            recipes.add(recipe);
                        }
                        if (recipes.size() > 0) {
                            BottlerRecipe recipe = (BottlerRecipe)recipes.iterator().next();
                            if (existingOutput.func_190926_b() || existingOutput.func_77973_b().equals(recipe.func_77571_b().func_77973_b())) {
                                FluidTankTileEntity.processOutput(fluidHandler, invHandler, recipe.func_77571_b(), (Integer)recipe.fluidInput.getSecond(), true);
                            }
                        } else if (fluidContainerItem.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).isPresent()) {
                            fluidContainerItem.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).ifPresent(h -> {
                                int amount = h.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                                FluidTankTileEntity.processOutput(fluidHandler, invHandler, (ItemStack)(h.getFluidInTank(0).getAmount() == h.getTankCapacity(0) ? fluidContainerItem : null), amount, false);
                            });
                        } else {
                            FluidActionResult fillResult = FluidUtil.tryFillContainer((ItemStack)fluidContainerItem, (IFluidHandler)fluidHandler, (int)Integer.MAX_VALUE, null, (boolean)true);
                            if (fillResult.isSuccess()) {
                                FluidTankTileEntity.processOutput(fluidHandler, invHandler, fillResult.getResult(), 0, true);
                            }
                        }
                    }
                });
            }
        });
    }

    private static void processOutput(IFluidHandler fluidHandler, IItemHandler itemHandler, ItemStack outputItem, int drainedAmount, boolean shrinkInputStack) {
        if (shrinkInputStack) {
            itemHandler.getStackInSlot(0).func_190918_g(1);
        }
        if (outputItem != null) {
            itemHandler.insertItem(11, outputItem, false);
        }
        fluidHandler.drain(drainedAmount, IFluidHandler.FluidAction.EXECUTE);
    }
}

