/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.tileentity;

import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.block.HoneyGenerator;
import cy.jdkdigital.productivebees.common.tileentity.FluidTankTileEntity;
import cy.jdkdigital.productivebees.common.tileentity.InventoryHandlerHelper;
import cy.jdkdigital.productivebees.common.tileentity.UpgradeableTileEntity;
import cy.jdkdigital.productivebees.container.HoneyGeneratorContainer;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModFluids;
import cy.jdkdigital.productivebees.init.ModTags;
import cy.jdkdigital.productivebees.init.ModTileEntityTypes;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class HoneyGeneratorTileEntity
extends FluidTankTileEntity
implements INamedContainerProvider,
ITickableTileEntity,
UpgradeableTileEntity {
    protected int tickCounter = 0;
    private LazyOptional<IItemHandlerModifiable> inventoryHandler = LazyOptional.of(() -> new InventoryHandlerHelper.ItemHandler(2, this){

        @Override
        public boolean isBottleItem(Item item) {
            return item.equals(Items.field_226638_pX_) || item.func_206844_a(ModTags.HONEY_BUCKETS) || item.equals(Items.field_226639_pY_);
        }

        @Override
        public boolean isInputSlot(int slot) {
            return slot == 0;
        }
    });
    protected LazyOptional<IFluidHandler> fluidInventory = LazyOptional.of(() -> new InventoryHandlerHelper.FluidHandler(10000){

        public boolean isFluidValid(FluidStack stack) {
            return stack.getFluid().func_207187_a((Fluid)ModFluids.HONEY.get());
        }

        protected void onContentsChanged() {
            super.onContentsChanged();
            if (this.fluid.getAmount() > 0) {
                HoneyGeneratorTileEntity.this.setFilled(true);
            } else {
                HoneyGeneratorTileEntity.this.setFilled(false);
            }
            HoneyGeneratorTileEntity.this.func_70296_d();
        }
    });
    protected LazyOptional<IItemHandlerModifiable> upgradeHandler = LazyOptional.of(() -> new InventoryHandlerHelper.UpgradeHandler(4, this));
    protected LazyOptional<IEnergyStorage> energyHandler = LazyOptional.of(() -> new EnergyStorage(100000));

    private void setFilled(boolean filled) {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((IProperty)HoneyGenerator.FULL, (Comparable)Boolean.valueOf(filled)));
        }
    }

    private void setOn(boolean filled) {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((IProperty)HoneyGenerator.ON, (Comparable)Boolean.valueOf(filled)));
        }
    }

    public HoneyGeneratorTileEntity() {
        super((TileEntityType)ModTileEntityTypes.HONEY_GENERATOR.get());
    }

    @Override
    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            int inputPowerAmount = (Integer)ProductiveBeesConfig.GENERAL.generatorPowerGen.get();
            int fluidConsumeAmount = (Integer)ProductiveBeesConfig.GENERAL.generatorHoneyUse.get();
            this.fluidInventory.ifPresent(fluidHandler -> this.energyHandler.ifPresent(energyHandler -> {
                if (fluidHandler.getFluidInTank(0).getAmount() >= fluidConsumeAmount && energyHandler.receiveEnergy(inputPowerAmount, true) > 0) {
                    energyHandler.receiveEnergy(inputPowerAmount, false);
                    fluidHandler.drain(fluidConsumeAmount, IFluidHandler.FluidAction.EXECUTE);
                    if (++this.tickCounter % 20 == 0) {
                        this.setOn(true);
                    }
                } else if (++this.tickCounter % 20 == 0) {
                    this.setOn(false);
                }
            }));
        }
        this.sendOutPower();
        super.func_73660_a();
    }

    private void sendOutPower() {
        this.energyHandler.ifPresent(energyHandler -> {
            AtomicInteger capacity = new AtomicInteger(energyHandler.getEnergyStored());
            if (capacity.get() > 0) {
                Direction[] directions;
                for (Direction direction : directions = Direction.values()) {
                    boolean doContinue;
                    TileEntity te;
                    if (this.field_145850_b != null && (te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(direction))) != null && !(doContinue = ((Boolean)te.getCapability(CapabilityEnergy.ENERGY, direction).map(handler -> {
                        if (handler.canReceive()) {
                            int received = handler.receiveEnergy(Math.min(capacity.get(), 100), false);
                            capacity.addAndGet(-received);
                            energyHandler.extractEnergy(received, false);
                            this.func_70296_d();
                            return capacity.get() > 0;
                        }
                        return true;
                    }).orElse((Object)true)).booleanValue())) break;
                }
            }
        });
    }

    @Override
    public void tickFluidTank() {
        this.fluidInventory.ifPresent(fluidHandler -> this.inventoryHandler.ifPresent(invHandler -> {
            int fluidSpace = (Integer)this.fluidInventory.map(h -> h.getTankCapacity(0) - h.getFluidInTank(0).getAmount()).orElse((Object)0);
            if (!invHandler.getStackInSlot(0).func_190926_b()) {
                ItemStack invItem = invHandler.getStackInSlot(0);
                ItemStack outputInvItem = invHandler.getStackInSlot(1);
                ItemStack outputItem = ItemStack.field_190927_a;
                LazyOptional itemFluidHandler = invItem.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
                boolean isHoneyBottle = invItem.func_77973_b().equals(Items.field_226638_pX_);
                boolean isHoneyBlock = invItem.func_77973_b().equals(Items.field_226639_pY_);
                boolean isHoneyBucket = invItem.func_77973_b().func_206844_a(ModTags.HONEY_BUCKETS);
                int addAmount = 0;
                if (isHoneyBottle) {
                    addAmount = 250;
                    outputItem = new ItemStack((IItemProvider)Items.field_151069_bo);
                } else if (isHoneyBlock) {
                    addAmount = 1000;
                } else if (isHoneyBucket) {
                    addAmount = 1000;
                    outputItem = new ItemStack((IItemProvider)Items.field_151133_ar);
                } else if (itemFluidHandler.isPresent()) {
                    addAmount = fluidSpace;
                }
                if (!(outputItem.equals(ItemStack.field_190927_a) || outputInvItem.func_190926_b() || outputInvItem.func_77973_b().equals(outputItem.func_77973_b()) && outputInvItem.func_77976_d() != outputInvItem.func_190916_E())) {
                    return;
                }
                if (itemFluidHandler.isPresent() && ((Boolean)itemFluidHandler.map(h -> h.getFluidInTank(0).isEmpty()).orElse((Object)false)).booleanValue()) {
                    if (outputInvItem.func_190926_b() && !invHandler.insertItem(1, invItem, false).func_190926_b()) {
                        invHandler.setStackInSlot(0, ItemStack.field_190927_a);
                    }
                    return;
                }
                if (addAmount > 0 && addAmount <= fluidSpace) {
                    int fillAmount = fluidHandler.fill(new FluidStack((Fluid)ModFluids.HONEY.get(), addAmount), IFluidHandler.FluidAction.EXECUTE);
                    if (itemFluidHandler.isPresent()) {
                        FluidUtil.tryEmptyContainer((ItemStack)invItem, (IFluidHandler)fluidHandler, (int)fillAmount, null, (boolean)true);
                    } else {
                        invItem.func_190918_g(1);
                        if (!outputItem.equals(ItemStack.field_190927_a)) {
                            if (outputInvItem.func_190926_b()) {
                                invHandler.setStackInSlot(1, outputItem);
                            } else {
                                outputInvItem.func_190917_f(1);
                            }
                        }
                    }
                }
            }
        }));
    }

    @Override
    public LazyOptional<IItemHandlerModifiable> getUpgradeHandler() {
        return this.upgradeHandler;
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.field_145850_b != null) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryHandler.cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidInventory.cast();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(((Block)ModBlocks.HONEY_GENERATOR.get()).func_149739_a(), new Object[0]);
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity player) {
        return new HoneyGeneratorContainer(windowId, playerInventory, this);
    }
}

