/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.tileentity;

import cy.jdkdigital.productivebees.common.item.Gene;
import cy.jdkdigital.productivebees.common.item.UpgradeItem;
import cy.jdkdigital.productivebees.common.item.WoodChip;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class InventoryHandlerHelper {
    public static final int BOTTLE_SLOT = 0;
    public static final int INPUT_SLOT = 1;
    public static final int FLUID_ITEM_OUTPUT_SLOT = 11;
    public static final int[] OUTPUT_SLOTS = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10};

    private static int getAvailableOutputSlot(IItemHandler handler, ItemStack insertStack) {
        return InventoryHandlerHelper.getAvailableOutputSlot(handler, insertStack, new ArrayList<Integer>());
    }

    private static int getAvailableOutputSlot(IItemHandler handler, ItemStack insertStack, List<Integer> blacklistedSlots) {
        int emptySlot = 0;
        for (int slot : OUTPUT_SLOTS) {
            Block block;
            if (blacklistedSlots.contains(slot)) continue;
            ItemStack stack = handler.getStackInSlot(slot);
            if (stack.func_77973_b().equals(insertStack.func_77973_b()) && stack.func_190916_E() + insertStack.func_190916_E() <= stack.func_77976_d() && (WoodChip.getBlock(insertStack) != null ? (block = WoodChip.getBlock(stack)) != null && block.equals(WoodChip.getBlock(insertStack)) : (!Gene.getAttributeName(insertStack).isEmpty() ? Gene.getAttributeName(stack).equals(Gene.getAttributeName(insertStack)) && Gene.getValue(stack).equals(Gene.getValue(insertStack)) && Gene.getPurity(stack).equals(Gene.getPurity(insertStack)) : stack.func_190926_b() || InventoryHandlerHelper.areItemsAndTagsEqual(stack, insertStack)))) {
                return slot;
            }
            if (!stack.func_190926_b() || emptySlot != 0) continue;
            emptySlot = slot;
        }
        return emptySlot;
    }

    public static boolean areItemsAndTagsEqual(ItemStack stack1, ItemStack stack2) {
        return stack1.func_190926_b() && stack2.func_190926_b() || stack1.func_77973_b() == stack2.func_77973_b() && InventoryHandlerHelper.areItemStackTagsEqual(stack1, stack2);
    }

    public static boolean areItemStackTagsEqual(ItemStack stackA, ItemStack stackB) {
        if (stackA.func_190926_b() && stackB.func_190926_b()) {
            return true;
        }
        if (!stackA.func_190926_b() && !stackB.func_190926_b()) {
            CompoundNBT tagA = stackA.func_77978_p();
            CompoundNBT tagB = stackB.func_77978_p();
            if ((tagA == null || tagA.isEmpty()) && tagB != null && !tagB.isEmpty()) {
                return false;
            }
            return (tagA == null || tagA.isEmpty() || tagA.equals((Object)stackB.func_77978_p())) && stackA.areCapsCompatible((CapabilityProvider)stackB);
        }
        return false;
    }

    public static class FluidHandler
    extends FluidTank
    implements INBTSerializable<CompoundNBT> {
        public FluidHandler(int capacity) {
            super(capacity);
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT nbt = new CompoundNBT();
            this.fluid.writeToNBT(nbt);
            return nbt;
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.fluid = FluidStack.loadFluidStackFromNBT((CompoundNBT)nbt);
        }
    }

    public static class UpgradeHandler
    extends ItemHandler {
        public UpgradeHandler(int size, TileEntity tileEntity) {
            super(size, tileEntity);
        }

        @Override
        public boolean isInsertableSlot(int slot) {
            return false;
        }

        @Override
        public boolean isInputSlotItem(int slot, Item item) {
            return item instanceof UpgradeItem;
        }
    }

    public static class ItemHandler
    extends ItemStackHandler {
        protected TileEntity tileEntity;

        public ItemHandler(int size, TileEntity tileEntity) {
            super(size);
            this.tileEntity = tileEntity;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (this.tileEntity != null) {
                this.tileEntity.func_70296_d();
            }
        }

        public boolean isInputSlot(int slot) {
            return slot == 0 || slot == 1;
        }

        public boolean isInsertableSlot(int slot) {
            return slot != 0 && slot != 1 && slot != 11;
        }

        public boolean isBottleItem(Item item) {
            return item == Items.field_151069_bo;
        }

        public boolean isInputSlotItem(int slot, Item item) {
            return slot == 0 && this.isBottleItem(item) || slot == 11 && !this.isBottleItem(item);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return this.isItemValid(slot, stack, true);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack, boolean fromAutomation) {
            if (this.isInputSlotItem(slot, stack.func_77973_b())) {
                return true;
            }
            return !fromAutomation && this.isInsertableSlot(slot);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.extractItem(slot, amount, simulate, true);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate, boolean fromAutomation) {
            if (fromAutomation && this.isInputSlot(slot)) {
                return ItemStack.field_190927_a;
            }
            return super.extractItem(slot, amount, simulate);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return this.insertItem(slot, stack, simulate, true);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate, boolean fromAutomation) {
            return super.insertItem(slot, stack, simulate);
        }

        public boolean addOutput(@Nonnull ItemStack stack) {
            int slot = InventoryHandlerHelper.getAvailableOutputSlot((IItemHandler)this, stack);
            if (slot > 0) {
                ItemStack existingStack = this.getStackInSlot(slot);
                if (existingStack.func_190926_b()) {
                    this.setStackInSlot(slot, stack.func_77946_l());
                } else {
                    existingStack.func_190917_f(stack.func_190916_E());
                }
                this.onContentsChanged(slot);
                return true;
            }
            return false;
        }

        public boolean canFitStacks(List<ItemStack> stacks) {
            ArrayList usedSlots = new ArrayList();
            for (ItemStack stack : stacks) {
                int slot = InventoryHandlerHelper.getAvailableOutputSlot((IItemHandler)this, stack, usedSlots);
                if (slot != 0) continue;
                return false;
            }
            return true;
        }

        public void deserializeNBT(CompoundNBT nbt) {
            int size;
            int n = size = nbt.func_150297_b("Size", 3) ? nbt.func_74762_e("Size") : this.stacks.size();
            if (size < this.stacks.size()) {
                nbt.func_74768_a("Size", this.stacks.size());
            }
            super.deserializeNBT(nbt);
        }
    }
}

