/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.tileentity;

import cy.jdkdigital.productivebees.common.block.SolitaryNest;
import cy.jdkdigital.productivebees.common.tileentity.AdvancedBeehiveTileEntityAbstract;
import cy.jdkdigital.productivebees.init.ModEntities;
import cy.jdkdigital.productivebees.init.ModTileEntityTypes;
import cy.jdkdigital.productivebees.recipe.BeeSpawningRecipe;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.BeehiveTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;

public class SolitaryNestTileEntity
extends AdvancedBeehiveTileEntityAbstract {
    private int nestTickTimer = -1;

    public SolitaryNestTileEntity(TileEntityType<?> tileEntityType) {
        super(tileEntityType);
        this.MAX_BEES = 1;
    }

    public SolitaryNestTileEntity() {
        this((TileEntityType)ModTileEntityTypes.SOLITARY_NEST.get());
    }

    @Override
    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.nestTickTimer > 0) {
            BeeEntity newBee;
            Block block = this.func_195044_w().func_177230_c();
            if (--this.nestTickTimer <= 0 && this.canRepopulate() && block instanceof SolitaryNest && (newBee = ((SolitaryNest)block).getNestingBeeType(this.field_145850_b, this.field_145850_b.func_226691_t_(this.field_174879_c))) != null) {
                newBee.func_70606_j(newBee.func_110138_aP());
                newBee.field_226369_bI_ = this.field_174879_c;
                Direction direction = (Direction)this.func_195044_w().func_177229_b((IProperty)BlockStateProperties.field_208155_H);
                SolitaryNestTileEntity.spawnBeeInWorldAtPosition(this.field_145850_b, newBee, this.field_174879_c.func_177972_a(direction), direction, null);
            }
            this.func_70296_d();
        }
        super.func_73660_a();
    }

    public boolean canRepopulate() {
        SolitaryNest nest = (SolitaryNest)this.func_195044_w().func_177230_c();
        boolean blockConditionsMet = nest.canRepopulateIn(this.field_145850_b, this.field_145850_b.func_226691_t_(this.func_174877_v()));
        return this.func_226969_f_() && blockConditionsMet;
    }

    public int getRepopulationCooldown(Block block) {
        IRecipe recipe = this.field_145850_b.func_199532_z().func_215367_a(new ResourceLocation("productivebees", "bee_spawning/" + block.getRegistryName().func_110623_a())).orElse(null);
        if (recipe instanceof BeeSpawningRecipe) {
            return ((BeeSpawningRecipe)recipe).repopulationCooldown;
        }
        return 24000;
    }

    public void setNestCooldown(int cooldown) {
        this.nestTickTimer = cooldown;
    }

    public int getNestTickCooldown() {
        return this.nestTickTimer;
    }

    @Override
    protected void beeReleasePostAction(BeeEntity beeEntity, BlockState state, BeehiveTileEntity.State beeState) {
        super.beeReleasePostAction(beeEntity, state, beeState);
        if (!beeEntity.func_70631_g_() && beeState == BeehiveTileEntity.State.HONEY_DELIVERED && this.field_145850_b.field_73012_v.nextFloat() <= 0.1f) {
            BeeEntity offspring = null;
            switch (beeEntity.func_70022_Q()) {
                case "productivebees:blue_banded_bee": {
                    offspring = (BeeEntity)((EntityType)ModEntities.NEON_CUCKOO_BEE.get()).func_200721_a(this.field_145850_b);
                    break;
                }
                case "productivebees:ashy_mining_bee": {
                    offspring = (BeeEntity)((EntityType)ModEntities.NOMAD_BEE.get()).func_200721_a(this.field_145850_b);
                }
            }
            if (offspring != null) {
                offspring.func_70873_a(-24000);
                offspring.func_70012_b(beeEntity.func_226277_ct_(), beeEntity.func_226278_cu_(), beeEntity.func_226281_cx_(), 0.0f, 0.0f);
                this.field_145850_b.func_217376_c((Entity)offspring);
            }
        }
        this.nestTickTimer = -1;
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("nestTickTimer")) {
            this.setNestCooldown(tag.func_74762_e("nestTickTimer"));
        }
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("nestTickTimer", this.nestTickTimer);
        return tag;
    }
}

