/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.container;

import cy.jdkdigital.productivebees.common.block.Feeder;
import cy.jdkdigital.productivebees.common.tileentity.FeederTileEntity;
import cy.jdkdigital.productivebees.container.AbstractContainer;
import cy.jdkdigital.productivebees.init.ModContainerTypes;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class FeederContainer
extends AbstractContainer {
    public final FeederTileEntity tileEntity;
    private final IWorldPosCallable canInteractWithCallable;

    public FeederContainer(int windowId, PlayerInventory playerInventory, PacketBuffer data) {
        this(windowId, playerInventory, FeederContainer.getTileEntity(playerInventory, data));
    }

    public FeederContainer(int windowId, PlayerInventory playerInventory, FeederTileEntity tileEntity) {
        super((ContainerType)ModContainerTypes.FEEDER.get(), windowId);
        this.tileEntity = tileEntity;
        this.canInteractWithCallable = IWorldPosCallable.func_221488_a((World)tileEntity.func_145831_w(), (BlockPos)tileEntity.func_174877_v());
        this.tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(inv -> this.addSlotBox((IItemHandler)inv, 0, 61, 34, 3, 18, 1, 18));
        this.layoutPlayerInventorySlots(playerInventory, 0, 8, 84);
    }

    private static FeederTileEntity getTileEntity(PlayerInventory playerInventory, PacketBuffer data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        TileEntity tileAtPos = playerInventory.field_70458_d.field_70170_p.func_175625_s(data.func_179259_c());
        if (tileAtPos instanceof FeederTileEntity) {
            return (FeederTileEntity)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct! " + tileAtPos);
    }

    public boolean func_75145_c(@Nonnull PlayerEntity player) {
        return (Boolean)this.canInteractWithCallable.func_221485_a((world, pos) -> world.func_180495_p(pos).func_177230_c() instanceof Feeder && player.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) <= 64.0, (Object)true);
    }

    @Override
    protected TileEntity getTileEntity() {
        return this.tileEntity;
    }
}

