/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.container.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import cy.jdkdigital.productivebees.client.render.ingredient.BeeRenderer;
import cy.jdkdigital.productivebees.common.block.AdvancedBeehive;
import cy.jdkdigital.productivebees.common.tileentity.AdvancedBeehiveTileEntityAbstract;
import cy.jdkdigital.productivebees.common.tileentity.DragonEggHiveTileEntity;
import cy.jdkdigital.productivebees.container.AdvancedBeehiveContainer;
import cy.jdkdigital.productivebees.handler.bee.CapabilityBee;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredientFactory;
import cy.jdkdigital.productivebees.state.properties.VerticalHive;
import cy.jdkdigital.productivebees.util.BeeHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.ModList;

public class AdvancedBeehiveScreen
extends ContainerScreen<AdvancedBeehiveContainer> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("productivebees", "textures/gui/container/advanced_beehive.png");
    private static final ResourceLocation GUI_TEXTURE_EXPANDED = new ResourceLocation("productivebees", "textures/gui/container/advanced_beehive_expanded.png");

    public AdvancedBeehiveScreen(AdvancedBeehiveContainer screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)screenContainer, inv, titleIn);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        boolean expanded = ((AdvancedBeehiveContainer)this.field_147002_h).tileEntity.func_195044_w().func_177229_b(AdvancedBeehive.EXPANDED) != VerticalHive.NONE;
        this.font.func_211126_b(this.title.func_150254_d(), expanded ? -5.0f : 8.0f, 6.0f, 0x404040);
        this.font.func_211126_b(this.field_213127_e.func_145748_c_().func_150254_d(), expanded ? -5.0f : 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
        assert (this.minecraft != null);
        HashMap<Integer, List<Integer>> positions = expanded ? AdvancedBeehiveContainer.BEE_POSITIONS_EXPANDED : AdvancedBeehiveContainer.BEE_POSITIONS;
        ((AdvancedBeehiveContainer)this.field_147002_h).tileEntity.getCapability(CapabilityBee.BEE).ifPresent(inhabitantHandler -> {
            int j = 0;
            for (AdvancedBeehiveTileEntityAbstract.Inhabitant inhabitant : inhabitantHandler.getInhabitants()) {
                BeeIngredient beeIngredient;
                BeeEntity bee = null;
                String type = inhabitant.nbt.func_74779_i("type");
                if (type.isEmpty()) {
                    type = inhabitant.nbt.func_74779_i("id");
                }
                if ((beeIngredient = BeeIngredientFactory.getIngredient(type).get()) != null) {
                    bee = beeIngredient.getCachedEntity((World)this.minecraft.field_71441_e);
                }
                if (bee != null && positions.containsKey(j) && this.func_195359_a((Integer)((List)positions.get(j)).get(0) - (expanded ? 13 : 0), (Integer)((List)positions.get(j)).get(1), 16, 16, mouseX, mouseY)) {
                    CompoundNBT tag = inhabitant.nbt.func_74737_b();
                    ArrayList<String> tooltipList = new ArrayList<String>();
                    tooltipList.add(bee.func_200200_C_().func_150254_d());
                    if (Screen.hasShiftDown()) {
                        String modId = new ResourceLocation(bee.func_70022_Q()).func_110624_b();
                        if (modId.equals("productivebees")) {
                            tag.func_74757_a("isProductiveBee", true);
                        }
                        List<ITextComponent> list = BeeHelper.populateBeeInfoFromTag(tag, null);
                        for (ITextComponent textComponent : list) {
                            tooltipList.add(textComponent.func_150254_d());
                        }
                        if (!tag.func_74767_n("isProductiveBee")) {
                            String modName = ModList.get().getModObjectById(modId).get().getClass().getSimpleName();
                            if (modId.equals("minecraft")) {
                                modName = "Minecraft";
                            }
                            tooltipList.add(new StringTextComponent(modName).func_211708_a(TextFormatting.ITALIC).func_211708_a(TextFormatting.BLUE).func_150254_d());
                        }
                    } else {
                        tooltipList.add(new TranslationTextComponent("productivebees.information.hold_shift", new Object[0]).func_211708_a(TextFormatting.WHITE).func_150254_d());
                    }
                    this.renderTooltip(tooltipList, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
                }
                ++j;
            }
        });
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean expanded = ((AdvancedBeehiveContainer)this.field_147002_h).tileEntity.func_195044_w().func_177229_b(AdvancedBeehive.EXPANDED) != VerticalHive.NONE;
        int honeyLevel = (Integer)((AdvancedBeehiveContainer)this.field_147002_h).tileEntity.func_195044_w().func_177229_b((IProperty)BeehiveBlock.field_226873_c_);
        assert (this.minecraft != null);
        this.minecraft.func_110434_K().func_110577_a(expanded ? GUI_TEXTURE_EXPANDED : GUI_TEXTURE);
        HashMap<Integer, List<Integer>> positions = expanded ? AdvancedBeehiveContainer.BEE_POSITIONS_EXPANDED : AdvancedBeehiveContainer.BEE_POSITIONS;
        this.blit(this.getGuiLeft() - (expanded ? 13 : 0), this.getGuiTop(), 0, 0, this.field_146999_f + (expanded ? 26 : 0), this.field_147000_g);
        int yOffset = ((AdvancedBeehiveContainer)this.field_147002_h).tileEntity instanceof DragonEggHiveTileEntity ? 17 : 0;
        int progress = honeyLevel == 0 ? 0 : 5 * honeyLevel;
        this.blit(this.getGuiLeft() + 82 - (expanded ? 13 : 0), this.getGuiTop() + 35, 176 + (expanded ? 26 : 0), 94 + yOffset, progress, 16);
        ((AdvancedBeehiveContainer)this.field_147002_h).tileEntity.getCapability(CapabilityBee.BEE).ifPresent(inhabitantHandler -> {
            int i = 0;
            for (AdvancedBeehiveTileEntityAbstract.Inhabitant inhabitant : inhabitantHandler.getInhabitants()) {
                if (this.minecraft.field_71439_g != null && positions.containsKey(i)) {
                    BeeIngredient beeIngredient;
                    String type = inhabitant.nbt.func_74779_i("type");
                    if (type.isEmpty()) {
                        type = inhabitant.nbt.func_74779_i("id");
                    }
                    if ((beeIngredient = BeeIngredientFactory.getIngredient(type).get()) != null) {
                        BeeRenderer.render(this.getGuiLeft() + (Integer)((List)positions.get(i)).get(0) - (expanded ? 13 : 0), this.getGuiTop() + (Integer)((List)positions.get(i)).get(1), beeIngredient, this.minecraft);
                    }
                }
                ++i;
            }
        });
    }
}

