/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.container.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import cy.jdkdigital.productivebees.container.CentrifugeContainer;
import cy.jdkdigital.productivebees.container.gui.FluidContainerUtil;
import java.util.ArrayList;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class CentrifugeScreen
extends ContainerScreen<CentrifugeContainer> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("productivebees", "textures/gui/container/centrifuge.png");
    private static final ResourceLocation GUI_TEXTURE_POWERED = new ResourceLocation("productivebees", "textures/gui/container/powered_centrifuge.png");

    public CentrifugeScreen(CentrifugeContainer container, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)container, inv, titleIn);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.font.func_211126_b(this.title.func_150254_d(), -5.0f, 6.0f, 0x404040);
        this.font.func_211126_b(this.field_213127_e.func_145748_c_().func_150254_d(), -5.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
        ((CentrifugeContainer)this.field_147002_h).tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).ifPresent(handler -> {
            FluidStack fluidStack = handler.getFluidInTank(0);
            if (this.func_195359_a(129, 16, 6, 54, mouseX, mouseY)) {
                ArrayList<String> tooltipList = new ArrayList<String>();
                if (fluidStack.getAmount() > 0) {
                    tooltipList.add(new TranslationTextComponent(fluidStack.getTranslationKey(), new Object[0]).getString() + ": " + fluidStack.getAmount() + "mb");
                } else {
                    tooltipList.add(new TranslationTextComponent("productivebees.hive.tooltip.empty", new Object[0]).getString());
                }
                this.renderTooltip(tooltipList, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
            }
        });
        ((CentrifugeContainer)this.field_147002_h).tileEntity.getCapability(CapabilityEnergy.ENERGY).ifPresent(handler -> {
            int energyAmount = handler.getEnergyStored();
            if (this.func_195359_a(-5, 16, 6, 54, mouseX, mouseY)) {
                ArrayList<String> tooltipList = new ArrayList<String>();
                tooltipList.add("Energy: " + energyAmount + "FE");
                this.renderTooltip(tooltipList, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
            }
        });
        ((CentrifugeContainer)this.field_147002_h).tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
            if (handler.getStackInSlot(0).func_190926_b() && this.func_195359_a(138, 16, 18, 18, mouseX, mouseY)) {
                ArrayList<String> tooltipList = new ArrayList<String>();
                tooltipList.add(new TranslationTextComponent("productivebees.centrifuge.tooltip.input_item", new Object[0]).getString());
                this.renderTooltip(tooltipList, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
            }
        });
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        assert (this.minecraft != null);
        if (((CentrifugeContainer)this.field_147002_h).tileEntity.getCapability(CapabilityEnergy.ENERGY).isPresent()) {
            this.minecraft.func_110434_K().func_110577_a(GUI_TEXTURE_POWERED);
        } else {
            this.minecraft.func_110434_K().func_110577_a(GUI_TEXTURE);
        }
        this.blit(this.field_147003_i - 13, this.field_147009_r, 0, 0, this.field_146999_f + 26, this.field_147000_g);
        int progress = (int)((float)((CentrifugeContainer)this.field_147002_h).tileEntity.recipeProgress * (24.0f / (float)((CentrifugeContainer)this.field_147002_h).tileEntity.getProcessingTime()));
        this.blit(this.field_147003_i + 35, this.field_147009_r + 35, 202, 52, progress + 1, 16);
        ((CentrifugeContainer)this.field_147002_h).tileEntity.getCapability(CapabilityEnergy.ENERGY).ifPresent(handler -> {
            int energyAmount = handler.getEnergyStored();
            int energyLevel = (int)((float)energyAmount * 0.0052f);
            this.blit(this.field_147003_i - 5, this.field_147009_r + 69, 206, 52, 4, -1 * energyLevel);
        });
        ((CentrifugeContainer)this.field_147002_h).tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).ifPresent(handler -> {
            FluidStack fluidStack = handler.getFluidInTank(0);
            if (fluidStack.getAmount() > 0) {
                int fluidLevel = (int)((float)fluidStack.getAmount() * 0.0052f);
                FluidContainerUtil.setColors(fluidStack);
                FluidContainerUtil.drawTiledSprite(this.field_147003_i + 127, this.field_147009_r + 69, 0, 4, fluidLevel, FluidContainerUtil.getSprite(fluidStack.getFluid().getAttributes().getStillTexture()), 16, 16, this.getBlitOffset());
                FluidContainerUtil.resetColor();
            }
        });
    }
}

