/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.datagen.provider;

import cy.jdkdigital.productivebees.common.block.AdvancedBeehive;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.state.properties.VerticalHive;
import java.util.function.Function;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.data.DataGenerator;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ExistingFileHelper;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.fml.RegistryObject;

public class BlockStates
extends BlockStateProvider {
    public BlockStates(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "productivebees", exFileHelper);
    }

    protected void registerStatesAndModels() {
        for (RegistryObject registryObject : ModBlocks.BLOCKS.getEntries()) {
            Block block = (Block)registryObject.get();
            ResourceLocation name = block.getRegistryName();
            assert (name != null);
            if (name.func_110623_a().contains("comb_")) {
                this.registerCombBlock(block, name);
                continue;
            }
            if (name.func_110623_a().contains("advanced_")) {
                this.registerAdvancedHive(block, name);
                continue;
            }
            if (name.func_110623_a().contains("expansion_box_")) {
                this.registerExpansionBox(block, name);
                continue;
            }
            if (name.func_110623_a().contains("_wood_nest")) {
                this.registerWoodNest(block, name);
                continue;
            }
            if (name.func_110623_a().equals("slimy_nest")) {
                this.registerSlimyNest(block, name);
                continue;
            }
            if (name.func_110623_a().contains("_nest")) {
                this.registerSolitaryNest(block, name);
                continue;
            }
            if (name.func_110623_a().contains("inactive_dragon_egg")) {
                this.simpleBlock(block, (ModelFile)this.models().getExistingFile(new ResourceLocation("block/dragon_egg")));
                continue;
            }
            if (name.func_110623_a().contains("dragon_egg_hive")) {
                this.simpleBlock(block, (ModelFile)this.models().getExistingFile(new ResourceLocation("productivebees", "block/dragon_egg_hive")));
                continue;
            }
            if (name.func_110623_a().equals("honey")) {
                this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().getBuilder("honey")).texture("particle", new ResourceLocation("productivebees", "block/honey/still")));
                continue;
            }
            if (!name.func_110623_a().equals("bamboo_hive")) continue;
            this.registerBambooHive(block, name);
        }
    }

    private void registerSlimyNest(Block block, ResourceLocation name) {
        this.simpleBlock(block, (ModelFile)this.models().getExistingFile(new ResourceLocation("productivebees", "block/nest/slimy_nest")));
    }

    private void registerCombBlock(Block block, ResourceLocation name) {
        this.simpleBlock(block, (ModelFile)this.models().cubeAll("block/comb/" + name.func_110623_a(), new ResourceLocation(name.func_110624_b(), "block/" + name.func_110623_a().replace("_", "/"))));
    }

    private void registerAdvancedHive(Block block, ResourceLocation name) {
        String simpleName = name.func_110623_a().replace("advanced_", "");
        ResourceLocation side = new ResourceLocation("buzzierbees", "block/" + simpleName + "_side");
        ResourceLocation top = new ResourceLocation("buzzierbees", "block/" + simpleName + "_end");
        ResourceLocation side_up = new ResourceLocation("productivebees", "block/advanced_beehive/" + simpleName + "_side");
        ResourceLocation front_up = new ResourceLocation("productivebees", "block/advanced_beehive/" + simpleName + "_front");
        ResourceLocation front_honey_up = new ResourceLocation("productivebees", "block/advanced_beehive/" + simpleName + "_front_honey");
        ResourceLocation top_left = new ResourceLocation("productivebees", "block/advanced_beehive/horizontal/" + simpleName + "_end_left");
        ResourceLocation side_left = new ResourceLocation("productivebees", "block/advanced_beehive/horizontal/" + simpleName + "_side_left");
        ResourceLocation front_left = new ResourceLocation("productivebees", "block/advanced_beehive/horizontal/" + simpleName + "_front_right");
        ResourceLocation front_honey_left = new ResourceLocation("productivebees", "block/advanced_beehive/horizontal/" + simpleName + "_front_right_honey");
        ResourceLocation top_right = new ResourceLocation("productivebees", "block/advanced_beehive/horizontal/" + simpleName + "_end_right");
        ResourceLocation side_right = new ResourceLocation("productivebees", "block/advanced_beehive/horizontal/" + simpleName + "_side_right");
        ResourceLocation front_right = new ResourceLocation("productivebees", "block/advanced_beehive/horizontal/" + simpleName + "_front_left");
        ResourceLocation front_honey_right = new ResourceLocation("productivebees", "block/advanced_beehive/horizontal/" + simpleName + "_front_left_honey");
        ResourceLocation parent = new ResourceLocation("productivebees", "block/advanced_hive");
        BlockModelBuilder modelLeft = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/advanced_beehive/" + simpleName + "_left", parent)).texture("particle", side)).texture("bottom", top_left)).texture("top", top_left)).texture("side", side)).texture("front", front_left)).texture("back", side_left);
        BlockModelBuilder modelLeftHoney = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/advanced_beehive/" + simpleName + "_left_honey", parent)).texture("particle", side)).texture("bottom", top_left)).texture("top", top_left)).texture("side", side)).texture("front", front_honey_left)).texture("back", side_left);
        BlockModelBuilder modelRight = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/advanced_beehive/" + simpleName + "_right", parent)).texture("particle", side)).texture("bottom", top_right)).texture("top", top_right)).texture("side", side)).texture("front", front_right)).texture("back", side_right);
        BlockModelBuilder modelrighthoney = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/advanced_beehive/" + simpleName + "_right_honey", parent)).texture("particle", side)).texture("bottom", top_right)).texture("top", top_right)).texture("side", side)).texture("front", front_honey_right)).texture("back", side_right);
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/advanced_beehive/" + simpleName, parent)).texture("particle", side)).texture("bottom", top)).texture("top", top)).texture("side", side_up)).texture("front", front_up)).texture("back", side_up);
        BlockModelBuilder modelHoney = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/advanced_beehive/" + simpleName + "_honey", parent)).texture("particle", side)).texture("bottom", top)).texture("top", top)).texture("side", side_up)).texture("front", front_honey_up)).texture("back", side_up);
        ModelFile.UncheckedModelFile smallModel = new ModelFile.UncheckedModelFile("productivebees:block/advanced_beehive/small/" + simpleName);
        ModelFile.UncheckedModelFile smallModelHoney = new ModelFile.UncheckedModelFile("productivebees:block/advanced_beehive/small/" + simpleName + "_honey");
        if (simpleName.equals("oak_beehive")) {
            smallModel = new ModelFile.UncheckedModelFile("block/beehive");
            smallModelHoney = new ModelFile.UncheckedModelFile("block/beehive_honey");
        }
        ModelFile.UncheckedModelFile finalSmallModelHoney = smallModelHoney;
        ModelFile.UncheckedModelFile finalSmallModel = smallModel;
        this.horizontalFaceBlock(block, state -> {
            if (state.func_177229_b(AdvancedBeehive.EXPANDED) == VerticalHive.UP) {
                if ((Integer)state.func_177229_b((IProperty)BeehiveBlock.field_226873_c_) == 5) {
                    return modelHoney;
                }
                return model;
            }
            if (state.func_177229_b(AdvancedBeehive.EXPANDED) == VerticalHive.LEFT) {
                if ((Integer)state.func_177229_b((IProperty)BeehiveBlock.field_226873_c_) == 5) {
                    return modelLeftHoney;
                }
                return modelLeft;
            }
            if (state.func_177229_b(AdvancedBeehive.EXPANDED) == VerticalHive.RIGHT) {
                if ((Integer)state.func_177229_b((IProperty)BeehiveBlock.field_226873_c_) == 5) {
                    return modelrighthoney;
                }
                return modelRight;
            }
            if ((Integer)state.func_177229_b((IProperty)BeehiveBlock.field_226873_c_) == 5) {
                return finalSmallModelHoney;
            }
            return finalSmallModel;
        });
    }

    private void registerExpansionBox(Block block, ResourceLocation name) {
        String simpleName = name.func_110623_a().replace("expansion_box_", "") + "_beehive";
        boolean isOak = simpleName.equals("oak_beehive");
        ResourceLocation sideUp = new ResourceLocation("productivebees", "block/advanced_beehive/" + simpleName + "_side_top");
        ResourceLocation sideSmall = new ResourceLocation("buzzierbees", "block/" + simpleName + "_side");
        ResourceLocation top = new ResourceLocation("buzzierbees", "block/" + simpleName + "_end");
        ResourceLocation sideVanilla = new ResourceLocation("block/beehive_side");
        ResourceLocation topVanilla = new ResourceLocation("block/beehive_end");
        ResourceLocation top_left = new ResourceLocation("productivebees", "block/advanced_beehive/horizontal/" + simpleName + "_end_left");
        ResourceLocation side_left = new ResourceLocation("productivebees", "block/advanced_beehive/horizontal/" + simpleName + "_side_left");
        ResourceLocation top_right = new ResourceLocation("productivebees", "block/advanced_beehive/horizontal/" + simpleName + "_end_right");
        ResourceLocation side_right = new ResourceLocation("productivebees", "block/advanced_beehive/horizontal/" + simpleName + "_side_right");
        ResourceLocation parent = new ResourceLocation("productivebees", "block/expansion_box");
        BlockModelBuilder modelLeft = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/expansion_box/" + simpleName + "_left", parent)).texture("particle", isOak ? sideVanilla : sideSmall)).texture("bottom", top_right)).texture("top", top_right)).texture("side", isOak ? sideVanilla : sideSmall)).texture("front", side_left)).texture("back", side_right);
        BlockModelBuilder modelRight = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/expansion_box/" + simpleName + "_right", parent)).texture("particle", isOak ? sideVanilla : sideSmall)).texture("bottom", top_left)).texture("top", top_left)).texture("side", isOak ? sideVanilla : sideSmall)).texture("front", side_right)).texture("back", side_left);
        BlockModelBuilder modelUp = (BlockModelBuilder)this.models().orientableWithBottom("block/expansion_box/" + simpleName, sideUp, sideUp, top, top);
        BlockModelBuilder modelSmall = (BlockModelBuilder)this.models().orientableWithBottom("block/expansion_box/" + simpleName + "_small", sideSmall, sideUp, top, top);
        if (isOak) {
            modelUp = (BlockModelBuilder)this.models().orientableWithBottom("block/expansion_box/" + simpleName, sideUp, sideUp, topVanilla, topVanilla);
            modelSmall = (BlockModelBuilder)this.models().orientableWithBottom("block/expansion_box/" + simpleName + "_small", sideVanilla, sideVanilla, topVanilla, topVanilla);
        }
        BlockModelBuilder finalModelSmall = modelSmall;
        BlockModelBuilder finalModelUp = modelUp;
        this.horizontalFaceBlock(block, state -> {
            if (state.func_177229_b(AdvancedBeehive.EXPANDED) == VerticalHive.UP) {
                return finalModelUp;
            }
            if (state.func_177229_b(AdvancedBeehive.EXPANDED) == VerticalHive.LEFT) {
                return modelLeft;
            }
            if (state.func_177229_b(AdvancedBeehive.EXPANDED) == VerticalHive.RIGHT) {
                return modelRight;
            }
            return finalModelSmall;
        });
    }

    private void registerWoodNest(Block block, ResourceLocation name) {
        String woodName = name.func_110623_a().replace("_wood_nest", "");
        ResourceLocation end = new ResourceLocation("block/" + woodName + "_log_top");
        ResourceLocation side = new ResourceLocation("block/" + woodName + "_log");
        ResourceLocation front = new ResourceLocation("productivebees", "block/nest/wood/" + woodName);
        Function<BlockState, ModelFile> modelFunc = blockState -> ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/nest/" + name.func_110623_a(), "productivebees:block/nest/wood_nest")).texture("end", end)).texture("front", front)).texture("side", side);
        this.getVariantBuilder(block).forAllStates(state -> {
            Direction dir = (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208155_H);
            return ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationX(dir == Direction.DOWN ? 180 : (dir.func_176740_k().func_176722_c() ? 90 : 0)).rotationY(dir.func_176740_k().func_200128_b() ? 0 : ((int)dir.func_185119_l() + 180) % 360).build();
        });
    }

    private void registerSolitaryNest(Block block, ResourceLocation name) {
        String simpleName = name.func_110623_a().replace("_nest", "").replace("nether_quartz", "nether_quartz_ore").replace("nether_brick", "nether_bricks");
        ResourceLocation side = new ResourceLocation("block/" + simpleName);
        ResourceLocation front = new ResourceLocation("productivebees", "block/nest/" + simpleName);
        BlockModelBuilder model = (BlockModelBuilder)this.models().orientable("block/nest/" + name.func_110623_a(), side, front, side);
        BlockModelBuilder modelVertical = (BlockModelBuilder)this.models().orientableVertical("block/nest/" + name.func_110623_a() + "_vertical", side, front);
        this.directionalBlock(block, state -> {
            if (state.func_177229_b((IProperty)BlockStateProperties.field_208155_H) == Direction.UP || state.func_177229_b((IProperty)BlockStateProperties.field_208155_H) == Direction.DOWN) {
                return modelVertical;
            }
            return model;
        });
    }

    private void registerBambooHive(Block block, ResourceLocation name) {
        ResourceLocation side = new ResourceLocation("productivebees", "block/bamboo_hive/side");
        ResourceLocation end = new ResourceLocation("productivebees", "block/bamboo_hive/front");
        BlockModelBuilder model = (BlockModelBuilder)this.models().cubeColumn(name.func_110623_a(), side, end);
        this.directionalBlock(block, blockState -> model);
    }

    private void registerCentrifuge(Block block, ResourceLocation name) {
        BlockModelBuilder dimCellFrame = (BlockModelBuilder)this.models().getBuilder("block/complex/main");
        BlockStates.floatingCube(dimCellFrame, 0.0f, 3.0f, 0.0f, 0.5f, 16.0f, 16.0f, "#side", "#top", "#inside");
        BlockStates.floatingCube(dimCellFrame, 0.5f, 3.0f, 0.0f, 1.0f, 16.0f, 16.0f, "#side_inner", "#top", "#inside");
        BlockStates.floatingCube(dimCellFrame, 1.0f, 3.0f, 1.0f, 15.0f, 4.0f, 15.0f, "", "#inside", "#inside");
        BlockStates.floatingCube(dimCellFrame, 15.5f, 3.0f, 0.0f, 16.0f, 16.0f, 16.0f, "#side", "#top", "#inside");
        BlockStates.floatingCube(dimCellFrame, 15.0f, 3.0f, 0.0f, 15.5f, 16.0f, 16.0f, "#side_inner", "#top", "#inside");
        BlockStates.floatingCube(dimCellFrame, 1.0f, 3.0f, 0.0f, 15.0f, 16.0f, 0.5f, "#side", "#top", "#inside");
        BlockStates.floatingCube(dimCellFrame, 1.0f, 3.0f, 0.5f, 15.0f, 16.0f, 1.0f, "#side_inner", "#top", "#inside");
        BlockStates.floatingCube(dimCellFrame, 1.0f, 3.0f, 15.5f, 15.0f, 16.0f, 16.0f, "#side", "#top", "#inside");
        BlockStates.floatingCube(dimCellFrame, 1.0f, 3.0f, 15.0f, 15.0f, 16.0f, 15.5f, "#side", "#top", "#inside");
        BlockStates.floatingCube(dimCellFrame, 0.0f, 0.0f, 0.0f, 3.0f, 3.0f, 1.0f, "#side", "#top", "#bottom");
        BlockStates.floatingCube(dimCellFrame, 0.0f, 0.0f, 1.0f, 1.0f, 3.0f, 3.0f, "#side", "#top", "#bottom");
        BlockStates.floatingCube(dimCellFrame, 0.0f, 0.0f, 1.0f, 1.0f, 3.0f, 3.0f, "#side", "#top", "#bottom");
        BlockStates.floatingCube(dimCellFrame, 13.0f, 0.0f, 0.0f, 16.0f, 3.0f, 1.0f, "#side", "#top", "#bottom");
        BlockStates.floatingCube(dimCellFrame, 15.0f, 0.0f, 1.0f, 16.0f, 3.0f, 3.0f, "#side", "#top", "#bottom");
        BlockStates.floatingCube(dimCellFrame, 0.0f, 0.0f, 15.0f, 3.0f, 3.0f, 16.0f, "#side", "#top", "#bottom");
        BlockStates.floatingCube(dimCellFrame, 0.0f, 0.0f, 13.0f, 1.0f, 3.0f, 15.0f, "#side", "#top", "#bottom");
        BlockStates.floatingCube(dimCellFrame, 13.0f, 0.0f, 15.0f, 16.0f, 3.0f, 16.0f, "#side", "#top", "#bottom");
        BlockStates.floatingCube(dimCellFrame, 15.0f, 0.0f, 13.0f, 16.0f, 3.0f, 15.0f, "#side", "#top", "#bottom");
        dimCellFrame.element().from(2.0f, 4.0f, 2.0f).to(14.0f, 8.0f, 14.0f).faces((direction, faceBuilder) -> {
            if (!direction.equals((Object)Direction.DOWN)) {
                if (direction.equals((Object)Direction.UP)) {
                    faceBuilder.texture("#grindstone_side").cullface(direction).uvs(0.0f, 0.0f, 12.0f, 12.0f);
                } else {
                    faceBuilder.texture("#grindstone_round").cullface(direction).uvs(0.0f, 0.0f, 12.0f, 4.0f);
                }
            }
        }).end();
        dimCellFrame.element().from(6.0f, 8.0f, 6.0f).to(10.0f, 9.0f, 10.0f).faces((direction, faceBuilder) -> {
            if (!direction.equals((Object)Direction.DOWN)) {
                if (direction.equals((Object)Direction.UP)) {
                    faceBuilder.texture("#grindstone_pivot").cullface(direction).uvs(0.0f, 0.0f, 4.0f, 4.0f);
                } else {
                    faceBuilder.texture("#grindstone_pivot").cullface(direction).uvs(0.0f, 0.0f, 4.0f, 1.0f);
                }
            }
        }).end();
        dimCellFrame.texture("top", this.modLoc("block/centrifuge/top"));
        dimCellFrame.texture("bottom", this.modLoc("block/centrifuge/bottom"));
        dimCellFrame.texture("particle", this.modLoc("block/centrifuge/side"));
        dimCellFrame.texture("side", this.modLoc("block/centrifuge/side"));
        dimCellFrame.texture("side_inner", this.modLoc("block/centrifuge/side"));
        dimCellFrame.texture("inside", this.modLoc("block/centrifuge/inner"));
        dimCellFrame.texture("grindstone_round", "block/grindstone_round");
        dimCellFrame.texture("grindstone_side", "block/grindstone_side");
        dimCellFrame.texture("grindstone_pivot", "block/grindstone_pivot");
        this.createCentrifugeCellModel(block, dimCellFrame);
    }

    private static void floatingCube(BlockModelBuilder builder, float fx, float fy, float fz, float tx, float ty, float tz, String defTex, String upTex, String downTex) {
        builder.element().from(fx, fy, fz).to(tx, ty, tz).faces((direction, faceBuilder) -> {
            if (direction.equals((Object)Direction.UP)) {
                faceBuilder.texture(upTex).cullface(direction);
            } else if (direction.equals((Object)Direction.DOWN)) {
                faceBuilder.texture(downTex);
            } else if (!defTex.isEmpty()) {
                faceBuilder.texture(defTex).cullface(direction);
            }
        }).end();
    }

    private void createCentrifugeCellModel(Block block, BlockModelBuilder dimCellFrame) {
        BlockModelBuilder idle = (BlockModelBuilder)this.models().withExistingParent("idle", "block");
        BlockModelBuilder running = (BlockModelBuilder)this.models().withExistingParent("running", new ResourceLocation("productivebees", "block/centrifuge/idle"));
    }
}

