/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.event;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBeeEntity;
import cy.jdkdigital.productivebees.init.ModEntities;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.network.PacketHandler;
import cy.jdkdigital.productivebees.network.packets.Messages;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import cy.jdkdigital.productivebees.util.BeeHelper;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.block.CocoaBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.ItemLootEntry;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="productivebees")
public class EventHandler {
    @SubscribeEvent
    public static void entityRightClicked(PlayerInteractEvent.EntityInteract entityInteract) {
        ItemStack itemStack = entityInteract.getItemStack();
        Entity entity = entityInteract.getTarget();
        if (!itemStack.func_190926_b() && entity instanceof BeeEntity) {
            World world = entityInteract.getWorld();
            PlayerEntity player = entityInteract.getPlayer();
            BlockPos pos = entity.func_180425_c();
            Hand hand = entityInteract.getHand();
            BeeEntity newBee = BeeHelper.itemInteract((BeeEntity)entity, itemStack, world, entity.serializeNBT(), player, hand, entity.func_174811_aO());
            if (newBee != null) {
                world.func_195594_a((IParticleData)ParticleTypes.field_197598_I, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), 0.2, 0.1, 0.2);
                world.func_184148_a(player, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_226134_ai_, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                world.func_217376_c((Entity)newBee);
                entity.func_70106_y();
            }
        }
    }

    @SubscribeEvent
    public static void onUseItemFinish(LivingEntityUseItemEvent.Finish event) {
        ItemStack stack = event.getResultStack();
        if (stack.func_77973_b().equals(Items.field_226638_pX_)) {
            LivingEntity entity = event.getEntityLiving();
            if (!entity.func_130014_f_().field_72995_K && entity.func_130014_f_().field_73012_v.nextBoolean()) {
                entity.curePotionEffects(stack);
            }
        }
    }

    @SubscribeEvent
    public static void cocoaBreakSpawn(BlockEvent.BreakEvent event) {
        if (event.getState().func_177230_c().equals(Blocks.field_150375_by) && (Integer)event.getState().func_177229_b((IProperty)CocoaBlock.field_176501_a) == 2) {
            PlayerEntity player = event.getPlayer();
            World world = event.getWorld().func_201672_e();
            if (player instanceof ServerPlayerEntity && !world.field_72995_K && (double)ProductiveBees.rand.nextFloat() < 0.05) {
                ConfigurableBeeEntity bee = (ConfigurableBeeEntity)((EntityType)ModEntities.CONFIGURABLE_BEE.get()).func_200721_a(world);
                BlockPos pos = event.getPos();
                if (bee != null) {
                    bee.setBeeType("productivebees:sugarbag");
                    bee.setAttributes();
                    BeeHelper.prepareBeeSpawn(bee, pos, Direction.func_176741_a((Random)ProductiveBees.rand), 0);
                    world.func_195594_a((IParticleData)ParticleTypes.field_197598_I, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), 0.2, 0.1, 0.2);
                    world.func_184148_a(player, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_226134_ai_, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                    world.func_217376_c((Entity)bee);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerJoinServer(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player instanceof ServerPlayerEntity) {
            PacketHandler.sendToPlayer(new Messages.BeesMessage(BeeReloadListener.INSTANCE.getData()), (ServerPlayerEntity)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ConfigurableBeeEntity) {
            CompoundNBT tag = new CompoundNBT();
            entity.func_70039_c(tag);
            if (!tag.func_74764_b("type") || tag.func_74779_i("type").isEmpty()) {
                Map<String, CompoundNBT> data = BeeReloadListener.INSTANCE.getData();
                ArrayList<String> beeTypes = new ArrayList<String>(data.keySet());
                if (!beeTypes.isEmpty()) {
                    ((ConfigurableBeeEntity)entity).setBeeType((String)beeTypes.get(ProductiveBees.rand.nextInt(beeTypes.size())));
                }
            } else if (tag.func_74779_i("type").equals("productivebees:ghostly") && ProductiveBees.rand.nextFloat() < 0.02f) {
                entity.func_200203_b((ITextComponent)new StringTextComponent("BooBee"));
            }
        }
    }

    @SubscribeEvent
    public static void onLootSetup(LootTableLoadEvent event) {
        if (event.getName().toString().contains("chests/village")) {
            event.getTable().getPool((String)"main").field_186453_a.add(ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.STURDY_BEE_CAGE.get())).func_216086_a(4).func_216081_b());
        }
    }
}

