/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.handler.attributes;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.handler.attributes.IBeeAttributes;
import cy.jdkdigital.productivebees.util.BeeAttribute;
import cy.jdkdigital.productivebees.util.BeeAttributes;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;

public class BeeAttributesHandler
implements IBeeAttributes {
    protected Map<BeeAttribute<?>, Object> beeAttributes = new HashMap();

    @Override
    public void setDefaults() {
        this.beeAttributes.put(BeeAttributes.PRODUCTIVITY, 1);
        this.beeAttributes.put(BeeAttributes.TEMPER, 1);
        this.beeAttributes.put(BeeAttributes.ENDURANCE, 1);
        this.beeAttributes.put(BeeAttributes.BEHAVIOR, 0);
        this.beeAttributes.put(BeeAttributes.WEATHER_TOLERANCE, 0);
        this.beeAttributes.put(BeeAttributes.TYPE, "hive");
        this.beeAttributes.put(BeeAttributes.APHRODISIACS, ItemTags.field_226159_I_);
    }

    @Override
    public <T> T getAttributeValue(BeeAttribute<T> attribute) {
        return (T)this.beeAttributes.get(attribute);
    }

    @Override
    public void setAttributeValue(BeeAttribute<?> attribute, int value) {
        this.beeAttributes.put(attribute, value);
    }

    @Override
    public void setAttributeValue(BeeAttribute<?> attribute, String value) {
        this.beeAttributes.put(attribute, value);
    }

    @Override
    public Map<BeeAttribute<?>, Object> getAttributes() {
        return this.beeAttributes;
    }

    @Override
    @Nonnull
    public INBT getAsNBT() {
        ProductiveBees.LOGGER.info("getAsNBT");
        for (Map.Entry<BeeAttribute<?>, Object> entry : this.getAttributes().entrySet()) {
            ProductiveBees.LOGGER.info(entry.getKey() + " - " + entry.getValue());
        }
        ProductiveBees.LOGGER.info("Productivity: " + this.getAttributeValue(BeeAttributes.PRODUCTIVITY));
        ProductiveBees.LOGGER.info("Endurance: " + this.getAttributeValue(BeeAttributes.ENDURANCE));
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a("bee_productivity", this.getAttributeValue(BeeAttributes.PRODUCTIVITY).intValue());
        tag.func_74768_a("bee_endurance", this.getAttributeValue(BeeAttributes.ENDURANCE).intValue());
        tag.func_74768_a("bee_temper", this.getAttributeValue(BeeAttributes.TEMPER).intValue());
        tag.func_74768_a("bee_behavior", this.getAttributeValue(BeeAttributes.BEHAVIOR).intValue());
        tag.func_74768_a("bee_weather_tolerance", this.getAttributeValue(BeeAttributes.WEATHER_TOLERANCE).intValue());
        tag.func_74778_a("bee_type", this.getAttributeValue(BeeAttributes.TYPE));
        tag.func_74778_a("bee_aphrodisiac", this.getAttributeValue(BeeAttributes.APHRODISIACS).func_199886_b().toString());
        return tag;
    }

    @Override
    public void readFromNBT(INBT tag) {
        ProductiveBees.LOGGER.info("readFromNBT " + (tag instanceof CompoundNBT));
        if (tag instanceof CompoundNBT) {
            CompoundNBT nbt = (CompoundNBT)tag;
            this.beeAttributes.put(BeeAttributes.PRODUCTIVITY, nbt.func_74762_e("bee_productivity"));
            this.beeAttributes.put(BeeAttributes.ENDURANCE, nbt.func_74764_b("bee_endurance"));
            this.beeAttributes.put(BeeAttributes.TEMPER, nbt.func_74762_e("bee_temper"));
            this.beeAttributes.put(BeeAttributes.BEHAVIOR, nbt.func_74762_e("bee_behavior"));
            this.beeAttributes.put(BeeAttributes.WEATHER_TOLERANCE, nbt.func_74762_e("bee_weather_tolerance"));
            this.beeAttributes.put(BeeAttributes.TYPE, nbt.func_74779_i("bee_type"));
            this.beeAttributes.put(BeeAttributes.APHRODISIACS, new ItemTags.Wrapper(new ResourceLocation(nbt.func_74779_i("bee_aphrodisiac"))));
            for (Map.Entry<BeeAttribute<?>, Object> entry : this.getAttributes().entrySet()) {
                ProductiveBees.LOGGER.info(entry.getKey() + " - " + entry.getValue());
            }
        }
    }
}

