/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.init;

import cy.jdkdigital.productivebees.common.entity.BeeBombEntity;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBeeEntity;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBeeEntity;
import cy.jdkdigital.productivebees.common.entity.bee.SolitaryBeeEntity;
import cy.jdkdigital.productivebees.common.entity.bee.hive.CreeperBeeEntity;
import cy.jdkdigital.productivebees.common.entity.bee.hive.CupidBeeEntity;
import cy.jdkdigital.productivebees.common.entity.bee.hive.FarmerBeeEntity;
import cy.jdkdigital.productivebees.common.entity.bee.hive.HoarderBeeEntity;
import cy.jdkdigital.productivebees.common.entity.bee.hive.LumberBeeEntity;
import cy.jdkdigital.productivebees.common.entity.bee.hive.QuarryBeeEntity;
import cy.jdkdigital.productivebees.common.entity.bee.hive.RancherBeeEntity;
import cy.jdkdigital.productivebees.common.entity.bee.solitary.BlueBandedBeeEntity;
import cy.jdkdigital.productivebees.common.entity.bee.solitary.BumbleBeeEntity;
import cy.jdkdigital.productivebees.common.entity.bee.solitary.DiggerBeeEntity;
import cy.jdkdigital.productivebees.common.entity.bee.solitary.GreenCarpenterBeeEntity;
import cy.jdkdigital.productivebees.common.entity.bee.solitary.MasonBeeEntity;
import cy.jdkdigital.productivebees.common.entity.bee.solitary.MiningBeeEntity;
import cy.jdkdigital.productivebees.common.entity.bee.solitary.NeonCuckooBeeEntity;
import cy.jdkdigital.productivebees.common.entity.bee.solitary.NomadBeeEntity;
import cy.jdkdigital.productivebees.common.entity.bee.solitary.ReedBeeEntity;
import cy.jdkdigital.productivebees.common.entity.bee.solitary.ResinBeeEntity;
import cy.jdkdigital.productivebees.common.entity.bee.solitary.SweatyBeeEntity;
import cy.jdkdigital.productivebees.common.entity.bee.solitary.YellowBlackCarpenterBeeEntity;
import cy.jdkdigital.productivebees.common.item.SpawnEgg;
import cy.jdkdigital.productivebees.init.ModItemGroups;
import cy.jdkdigital.productivebees.init.ModItems;
import java.awt.Color;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="productivebees", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModEntities {
    public static final DeferredRegister<EntityType<?>> ENTITIES = new DeferredRegister(ForgeRegistries.ENTITIES, "productivebees");
    public static final DeferredRegister<EntityType<?>> HIVE_BEES = new DeferredRegister(ForgeRegistries.ENTITIES, "productivebees");
    public static final DeferredRegister<EntityType<?>> SOLITARY_BEES = new DeferredRegister(ForgeRegistries.ENTITIES, "productivebees");
    public static RegistryObject<EntityType<ProjectileItemEntity>> BEE_BOMB = ModEntities.createEntity("bee_bomb", BeeBombEntity::new);
    public static RegistryObject<EntityType<BeeEntity>> DYE_BEE = ModEntities.createHiveBee("dye_bee", ProductiveBeeEntity::new, 16768648, 6238757, ModItemGroups.PRODUCTIVE_BEES);
    public static RegistryObject<EntityType<BeeEntity>> LUMBER_BEE = ModEntities.createHiveBee("lumber_bee", LumberBeeEntity::new, 8306542, 6238757, ModItemGroups.PRODUCTIVE_BEES);
    public static RegistryObject<EntityType<BeeEntity>> QUARRY_BEE = ModEntities.createHiveBee("quarry_bee", QuarryBeeEntity::new, 0x737373, 6238757, ModItemGroups.PRODUCTIVE_BEES);
    public static RegistryObject<EntityType<BeeEntity>> RANCHER_BEE = ModEntities.createHiveBee("rancher_bee", RancherBeeEntity::new, 9615358, 6238757, ModItemGroups.PRODUCTIVE_BEES);
    public static RegistryObject<EntityType<BeeEntity>> HOARDER_BEE = ModEntities.createHiveBee("hoarder_bee", HoarderBeeEntity::new, 8306149, 6238757, ModItemGroups.PRODUCTIVE_BEES);
    public static RegistryObject<EntityType<BeeEntity>> FARMER_BEE = ModEntities.createHiveBee("farmer_bee", FarmerBeeEntity::new, 9615358, 6238757, ModItemGroups.PRODUCTIVE_BEES);
    public static RegistryObject<EntityType<BeeEntity>> CREEPER_BEE = ModEntities.createHiveBee("creeper_bee", CreeperBeeEntity::new, 894731, 6238757, ModItemGroups.PRODUCTIVE_BEES);
    public static RegistryObject<EntityType<BeeEntity>> CUPID_BEE = ModEntities.createHiveBee("cupid_bee", CupidBeeEntity::new, 894731, 6238757, ModItemGroups.PRODUCTIVE_BEES);
    public static RegistryObject<EntityType<BeeEntity>> ASHY_MINING_BEE = ModEntities.createSolitaryBee("ashy_mining_bee", MiningBeeEntity::new, 11709345, 6238757);
    public static RegistryObject<EntityType<BeeEntity>> BLUE_BANDED_BEE = ModEntities.createSolitaryBee("blue_banded_bee", BlueBandedBeeEntity::new, 9615358, 6238757);
    public static RegistryObject<EntityType<BeeEntity>> GREEN_CARPENTER_BEE = ModEntities.createSolitaryBee("green_carpenter_bee", GreenCarpenterBeeEntity::new, 9615358, 6238757);
    public static RegistryObject<EntityType<BeeEntity>> YELLOW_BLACK_CARPENTER_BEE = ModEntities.createSolitaryBee("yellow_black_carpenter_bee", YellowBlackCarpenterBeeEntity::new, 15582019, 6238757);
    public static RegistryObject<EntityType<BeeEntity>> CHOCOLATE_MINING_BEE = ModEntities.createSolitaryBee("chocolate_mining_bee", MiningBeeEntity::new, 11709345, 6238757);
    public static RegistryObject<EntityType<BeeEntity>> DIGGER_BEE = ModEntities.createSolitaryBee("digger_bee", DiggerBeeEntity::new, 8875079, 6238757);
    public static RegistryObject<EntityType<BeeEntity>> LEAFCUTTER_BEE = ModEntities.createSolitaryBee("leafcutter_bee", SolitaryBeeEntity::new, 2057258, 6238757);
    public static RegistryObject<EntityType<BeeEntity>> MASON_BEE = ModEntities.createSolitaryBee("mason_bee", MasonBeeEntity::new, 2226382, 6238757);
    public static RegistryObject<EntityType<BeeEntity>> NEON_CUCKOO_BEE = ModEntities.createSolitaryBee("neon_cuckoo_bee", NeonCuckooBeeEntity::new, 9615358, 6238757);
    public static RegistryObject<EntityType<BeeEntity>> NOMAD_BEE = ModEntities.createSolitaryBee("nomad_bee", NomadBeeEntity::new, 14529911, 6238757);
    public static RegistryObject<EntityType<BeeEntity>> REED_BEE = ModEntities.createSolitaryBee("reed_bee", ReedBeeEntity::new, 13806336, 6238757);
    public static RegistryObject<EntityType<BeeEntity>> RESIN_BEE = ModEntities.createSolitaryBee("resin_bee", ResinBeeEntity::new, 13939231, 6238757);
    public static RegistryObject<EntityType<BeeEntity>> SWEATY_BEE = ModEntities.createSolitaryBee("sweaty_bee", SweatyBeeEntity::new, 9748939, 6238757);
    public static RegistryObject<EntityType<BeeEntity>> BUMBLE = ModEntities.createSolitaryBee("bumble_bee", BumbleBeeEntity::new, 9748939, 6238757);
    public static RegistryObject<EntityType<ConfigurableBeeEntity>> CONFIGURABLE_BEE = ModEntities.createColoredHiveBee("configurable_bee", ConfigurableBeeEntity::new, "#73ffb9", "#0f5c7a", ModItemGroups.PRODUCTIVE_BEES);

    public static <E extends BeeEntity> RegistryObject<EntityType<E>> createColoredHiveBee(String name, EntityType.IFactory<E> supplier, String primaryColor, String secondaryColor, ItemGroup itemGroup) {
        Color primary = Color.decode(primaryColor);
        Color secondary = Color.decode(secondaryColor);
        return ModEntities.createHiveBee(name, (entityType, world) -> {
            ProductiveBeeEntity bee = (ProductiveBeeEntity)supplier.create(entityType, world);
            bee.setColor(primary, secondary);
            return bee;
        }, primary.getRGB(), secondary.getRGB(), itemGroup);
    }

    public static <E extends BeeEntity> RegistryObject<EntityType<E>> createHiveBee(String name, EntityType.IFactory<E> supplier, int primaryColor, int secondaryColor, ItemGroup itemGroup) {
        return ModEntities.createBee(HIVE_BEES, name, supplier, primaryColor, secondaryColor, itemGroup);
    }

    public static <E extends BeeEntity> RegistryObject<EntityType<E>> createSolitaryBee(String name, EntityType.IFactory<E> supplier, int primaryColor, int secondaryColor) {
        return ModEntities.createBee(SOLITARY_BEES, name, supplier, primaryColor, secondaryColor, ModItemGroups.PRODUCTIVE_BEES);
    }

    public static <E extends BeeEntity> RegistryObject<EntityType<E>> createBee(DeferredRegister<EntityType<?>> registry, String name, EntityType.IFactory<E> supplier, int primaryColor, int secondaryColor, ItemGroup itemGroup) {
        EntityType.Builder builder = EntityType.Builder.func_220322_a(supplier, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.7f, 0.6f);
        if (name.equals("magmatic_bee")) {
            builder.func_220320_c();
        }
        RegistryObject entity = registry.register(name, () -> builder.func_206830_a("productivebees:" + name));
        if (itemGroup != null) {
            RegistryObject spawnEgg = ModItems.ITEMS.register("spawn_egg_" + name, () -> new SpawnEgg(() -> ((RegistryObject)entity).get(), secondaryColor, primaryColor, new Item.Properties().func_200916_a(itemGroup)));
            if (name.equals("configurable_bee")) {
                ModItems.CONFIGURABLE_SPAWN_EGG = spawnEgg;
            }
            ModItems.SPAWN_EGGS.add((RegistryObject<Item>)spawnEgg);
        }
        return entity;
    }

    public static <E extends Entity> RegistryObject<EntityType<E>> createEntity(String name, EntityType.IFactory<E> supplier) {
        EntityType.Builder builder = EntityType.Builder.func_220322_a(supplier, (EntityClassification)EntityClassification.MISC).func_220321_a(0.25f, 0.25f);
        RegistryObject entity = ENTITIES.register(name, () -> builder.func_206830_a("productivebees:" + name));
        return entity;
    }
}

