/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.init;

import cy.jdkdigital.productivebees.init.ModBlocks;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.village.PointOfInterestType;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="productivebees", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ModPointOfInterestTypes {
    private static Method blockStatesInjector;
    public static final DeferredRegister<PointOfInterestType> POINT_OF_INTEREST_TYPES;
    public static final RegistryObject<PointOfInterestType> SOLITARY_HIVE;
    public static final RegistryObject<PointOfInterestType> SOLITARY_NEST;
    public static final RegistryObject<PointOfInterestType> DRACONIC_NEST;
    public static final RegistryObject<PointOfInterestType> SUGARBAG_NEST;
    public static final RegistryObject<PointOfInterestType> BUMBLE_BEE_NEST;

    private static RegistryObject<PointOfInterestType> register(String name, RegistryObject<Block> block, int maxFreeTickets) {
        ArrayList<RegistryObject<Block>> blocks = new ArrayList<RegistryObject<Block>>();
        blocks.add(block);
        return ModPointOfInterestTypes.register(name, blocks, maxFreeTickets);
    }

    private static RegistryObject<PointOfInterestType> register(String name, Supplier<List<RegistryObject<Block>>> supplier, int maxFreeTickets) {
        return ModPointOfInterestTypes.register(name, supplier.get(), maxFreeTickets);
    }

    private static RegistryObject<PointOfInterestType> register(String name, List<RegistryObject<Block>> blocks, int maxFreeTickets) {
        return ModPointOfInterestTypes.register(name, () -> {
            HashSet blockStates = new HashSet();
            for (RegistryObject block : blocks) {
                blockStates.addAll(PointOfInterestType.func_221042_a((Block)((Block)block.get())));
            }
            return new PointOfInterestType(name, blockStates, maxFreeTickets, 1);
        });
    }

    private static RegistryObject<PointOfInterestType> register(String name, Supplier<PointOfInterestType> supplier) {
        return POINT_OF_INTEREST_TYPES.register(name, supplier);
    }

    public static void fixPOITypeBlockStates(PointOfInterestType poiType) {
        try {
            blockStatesInjector.invoke(null, poiType);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    static {
        POINT_OF_INTEREST_TYPES = new DeferredRegister(ForgeRegistries.POI_TYPES, "productivebees");
        SOLITARY_HIVE = ModPointOfInterestTypes.register("solitary_hive", ModBlocks.BAMBOO_HIVE, 1);
        SOLITARY_NEST = ModPointOfInterestTypes.register("solitary_nest", () -> {
            ArrayList<RegistryObject<Block>> blocks = new ArrayList<RegistryObject<Block>>();
            blocks.add(ModBlocks.STONE_NEST);
            blocks.add(ModBlocks.SAND_NEST);
            blocks.add(ModBlocks.SNOW_NEST);
            blocks.add(ModBlocks.COARSE_DIRT_NEST);
            blocks.add(ModBlocks.GRAVEL_NEST);
            blocks.add(ModBlocks.SLIMY_NEST);
            blocks.add(ModBlocks.NETHER_BRICK_NEST);
            blocks.add(ModBlocks.NETHER_QUARTZ_NEST);
            blocks.add(ModBlocks.GLOWSTONE_NEST);
            blocks.add(ModBlocks.SOUL_SAND_NEST);
            blocks.add(ModBlocks.SUGAR_CANE_NEST);
            blocks.add(ModBlocks.END_NEST);
            blocks.add(ModBlocks.OAK_WOOD_NEST);
            blocks.add(ModBlocks.BIRCH_WOOD_NEST);
            blocks.add(ModBlocks.SPRUCE_WOOD_NEST);
            blocks.add(ModBlocks.DARK_OAK_WOOD_NEST);
            blocks.add(ModBlocks.ACACIA_WOOD_NEST);
            return blocks;
        }, 1);
        DRACONIC_NEST = ModPointOfInterestTypes.register("draconic_nest", () -> {
            ArrayList<RegistryObject<Block>> blocks = new ArrayList<RegistryObject<Block>>();
            blocks.add(ModBlocks.DRAGON_EGG_HIVE);
            blocks.add(ModBlocks.OBSIDIAN_PILLAR_NEST);
            return blocks;
        }, 1);
        SUGARBAG_NEST = ModPointOfInterestTypes.register("sugarbag_nest", () -> {
            ArrayList<RegistryObject<Block>> blocks = new ArrayList<RegistryObject<Block>>();
            blocks.add(ModBlocks.SUGARBAG_NEST);
            return blocks;
        }, 1);
        BUMBLE_BEE_NEST = ModPointOfInterestTypes.register("bumble_bee_nest", () -> {
            ArrayList<RegistryObject<Block>> blocks = new ArrayList<RegistryObject<Block>>();
            blocks.add(ModBlocks.BUMBLEBEE_NEST);
            return blocks;
        }, 1);
        blockStatesInjector = ObfuscationReflectionHelper.findMethod(PointOfInterestType.class, (String)"func_221052_a", (Class[])new Class[]{PointOfInterestType.class});
    }
}

