/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.integrations.hwyla;

import cy.jdkdigital.productivebees.common.tileentity.AdvancedBeehiveTileEntityAbstract;
import cy.jdkdigital.productivebees.common.tileentity.SolitaryNestTileEntity;
import java.util.List;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class HUDHandlerSolitaryNest
implements IComponentProvider {
    static final HUDHandlerSolitaryNest INSTANCE = new HUDHandlerSolitaryNest();

    public void appendBody(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
        if (!(accessor.getTileEntity() instanceof SolitaryNestTileEntity)) {
            return;
        }
        SolitaryNestTileEntity tileEntity = (SolitaryNestTileEntity)accessor.getTileEntity();
        List<AdvancedBeehiveTileEntityAbstract.Inhabitant> bees = tileEntity.getBeeList();
        if (!bees.isEmpty()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("productivebees.top.solitary.bee", new Object[]{bees.get((int)0).localizedName}));
        } else {
            int cooldown = tileEntity.getNestTickCooldown();
            if (cooldown > 0) {
                tooltip.add((ITextComponent)new TranslationTextComponent("productivebees.top.solitary.repopulation_countdown", new Object[]{Math.round((float)cooldown / 20.0f) + "s"}));
            } else {
                tooltip.add((ITextComponent)new TranslationTextComponent("productivebees.top.solitary.repopulation_countdown_inactive", new Object[0]));
                if (tileEntity.canRepopulate()) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("productivebees.top.solitary.can_repopulate_true", new Object[0]));
                } else {
                    tooltip.add((ITextComponent)new TranslationTextComponent("productivebees.top.solitary.can_repopulate_false", new Object[0]));
                }
            }
        }
    }
}

