/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.integrations.jei;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.integrations.jei.ProductiveBeesJeiPlugin;
import cy.jdkdigital.productivebees.recipe.CentrifugeRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;

public class CentrifugeRecipeCategory
implements IRecipeCategory<CentrifugeRecipe> {
    private final IDrawable background;
    private final IDrawable icon;

    public CentrifugeRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("productivebees", "textures/gui/jei/centrifuge_recipe.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 126, 70);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModBlocks.CENTRIFUGE.get()));
    }

    @Nonnull
    public ResourceLocation getUid() {
        return ProductiveBeesJeiPlugin.CATEGORY_CENTRIFUGE_UID;
    }

    @Nonnull
    public Class<? extends CentrifugeRecipe> getRecipeClass() {
        return CentrifugeRecipe.class;
    }

    @Nonnull
    public String getTitle() {
        return I18n.func_135052_a((String)"jei.productivebees.centrifuge", (Object[])new Object[0]);
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(@Nonnull CentrifugeRecipe recipe, @Nonnull IIngredients ingredients) {
        ingredients.setInputIngredients((List)Lists.newArrayList((Object[])new Ingredient[]{recipe.ingredient}));
        ArrayList outputList = new ArrayList();
        recipe.getRecipeOutputs().forEach((stack, value) -> {
            ArrayList innerList = new ArrayList();
            IntStream.range(value.get(0).func_150287_d(), value.get(1).func_150287_d() + 1).forEach(i -> {
                ItemStack newStack = stack.func_77946_l();
                newStack.func_190920_e(i);
                innerList.add(newStack);
            });
            outputList.add(innerList);
        });
        ingredients.setOutputLists(VanillaTypes.ITEM, outputList);
        Pair<Fluid, Integer> fluid = recipe.getFluidOutputs();
        if (fluid != null && (Integer)fluid.getSecond() > 0) {
            ingredients.setOutput(VanillaTypes.FLUID, (Object)new FluidStack((Fluid)fluid.getFirst(), ((Integer)fluid.getSecond()).intValue()));
        }
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull CentrifugeRecipe recipe, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup fluidStacks = recipeLayout.getFluidStacks();
        itemStacks.init(0, true, 4, 26);
        int startX = 68;
        int startY = 26;
        int offset = ingredients.getInputs(VanillaTypes.ITEM).size();
        List itemOutputs = ingredients.getOutputs(VanillaTypes.ITEM);
        if (itemOutputs.size() > 0) {
            IntStream.range(0, itemOutputs.size()).forEach(i -> itemStacks.init(i + offset, false, startX + i * 18, startY + (int)Math.floor((float)i / 3.0f) * 18));
        }
        itemStacks.set(ingredients);
        List fluidOutputs = ingredients.getOutputs(VanillaTypes.FLUID);
        if (fluidOutputs.size() > 0) {
            IntStream.range(itemOutputs.size(), itemOutputs.size() + fluidOutputs.size()).forEach(i -> fluidStacks.init(i + offset, false, startX + i * 18 + 1, startY + (int)Math.floor((float)i / 3.0f) * 18 + 1));
        }
        fluidStacks.set(ingredients);
        ArrayList<StringTextComponent> chances = new ArrayList<StringTextComponent>();
        ArrayList<TranslationTextComponent> amounts = new ArrayList<TranslationTextComponent>();
        recipe.getRecipeOutputs().forEach((stack, value) -> {
            int chance = value.get(2).func_150287_d();
            if (chance < 100) {
                chances.add((StringTextComponent)new TranslationTextComponent("productivebees.centrifuge.tooltip.chance", new Object[]{chance < 1 ? "<1%" : chance + "%"}));
            } else {
                chances.add(new StringTextComponent(""));
            }
            if (value.get(0) != value.get(1)) {
                amounts.add(new TranslationTextComponent("productivebees.centrifuge.tooltip.amount", new Object[]{value.get(0).func_150287_d() + " - " + value.get(1).func_150287_d()}));
            } else {
                amounts.add((TranslationTextComponent)new StringTextComponent(""));
            }
        });
        Pair<Fluid, Integer> fluid = recipe.getFluidOutputs();
        if (fluid != null) {
            chances.add(new StringTextComponent(""));
            amounts.add(new TranslationTextComponent("productivebees.centrifuge.tooltip.amount", new Object[]{fluid.getSecond() + "mb"}));
        }
        itemStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (!input) {
                if (!chances.isEmpty() && chances.size() >= slotIndex && !((ITextComponent)chances.get(slotIndex - 1)).getString().isEmpty()) {
                    tooltip.add(((ITextComponent)chances.get(slotIndex - 1)).getString());
                }
                if (!amounts.isEmpty() && amounts.size() >= slotIndex && !((ITextComponent)amounts.get(slotIndex - 1)).getString().isEmpty()) {
                    tooltip.add(((ITextComponent)amounts.get(slotIndex - 1)).getString());
                }
            }
        });
        fluidStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (!chances.toString().isEmpty() && chances.size() >= slotIndex && !((ITextComponent)chances.get(slotIndex - 1)).getString().isEmpty()) {
                tooltip.add(((ITextComponent)chances.get(slotIndex - 1)).getString());
            }
            if (!amounts.toString().isEmpty() && amounts.size() >= slotIndex && !((ITextComponent)amounts.get(slotIndex - 1)).getString().isEmpty()) {
                tooltip.add(((ITextComponent)amounts.get(slotIndex - 1)).getString());
            }
        });
    }
}

