/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.integrations.jei;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.item.BeeCage;
import cy.jdkdigital.productivebees.common.item.HoneyTreat;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModItemGroups;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.integrations.jei.ProductiveBeesJeiPlugin;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.recipe.IncubationRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.NBTIngredient;

public class IncubationRecipeCategory
implements IRecipeCategory<IncubationRecipe> {
    private final IDrawable background;
    private final IDrawable icon;

    public IncubationRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("productivebees", "textures/gui/jei/incubator.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 126, 70);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModBlocks.INCUBATOR.get()));
    }

    @Nonnull
    public ResourceLocation getUid() {
        return ProductiveBeesJeiPlugin.CATEGORY_INCUBATION_UID;
    }

    @Nonnull
    public Class<? extends IncubationRecipe> getRecipeClass() {
        return IncubationRecipe.class;
    }

    @Nonnull
    public String getTitle() {
        return I18n.func_135052_a((String)"jei.productivebees.incubation", (Object[])new Object[0]);
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(IncubationRecipe recipe, IIngredients ingredients) {
        List<ItemStack> inputs = Arrays.asList(recipe.input.func_193365_a());
        List<ItemStack> catalyst = Arrays.asList(recipe.catalyst.func_193365_a());
        ingredients.setInputLists(VanillaTypes.ITEM, Arrays.asList(inputs, catalyst));
        ingredients.setOutputs(VanillaTypes.ITEM, Arrays.asList(recipe.result.func_193365_a()));
    }

    public void setRecipe(IRecipeLayout recipeLayout, IncubationRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, true, 8, 8);
        itemStacks.init(1, true, 36, 26);
        itemStacks.init(2, false, 64, 8);
        itemStacks.set(ingredients);
    }

    public static List<IncubationRecipe> getRecipes(Map<String, BeeIngredient> beeList) {
        ArrayList<IncubationRecipe> recipes = new ArrayList<IncubationRecipe>();
        BeeEntity bee = (BeeEntity)EntityType.field_226289_e_.func_200721_a(ProductiveBees.proxy.getClientWorld());
        BeeEntity baBee = (BeeEntity)EntityType.field_226289_e_.func_200721_a(ProductiveBees.proxy.getClientWorld());
        if (bee != null && baBee != null) {
            ItemStack cage = new ItemStack((IItemProvider)ModItems.BEE_CAGE.get());
            ItemStack babeeCage = cage.func_77946_l();
            baBee.func_70873_a(-24000);
            BeeCage.captureEntity(bee, cage);
            BeeCage.captureEntity(baBee, babeeCage);
            ItemStack treats = new ItemStack((IItemProvider)ModItems.HONEY_TREAT.get(), ((Integer)ProductiveBeesConfig.GENERAL.incubatorTreatUse.get()).intValue());
            recipes.add(new IncubationRecipe(new ResourceLocation("productivebees", "cage_incubation"), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{babeeCage}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{treats}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{cage})));
        }
        for (Map.Entry<String, BeeIngredient> entry : beeList.entrySet()) {
            Ingredient spawnEgg = NBTIngredient.func_193369_a((ItemStack[])new ItemStack[]{ModItemGroups.ModItemGroup.getSpawnEgg(entry.getKey())});
            Ingredient treat = NBTIngredient.func_193369_a((ItemStack[])new ItemStack[]{HoneyTreat.getTypeStack(entry.getKey(), 100)});
            recipes.add(new IncubationRecipe(new ResourceLocation(entry.getKey() + "_incubation"), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151110_aK}), treat, spawnEgg));
        }
        return recipes;
    }
}

