/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.integrations.jei;

import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModItemGroups;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.integrations.jei.AdvancedBeehiveRecipeCategory;
import cy.jdkdigital.productivebees.integrations.jei.BeeBreedingRecipeCategory;
import cy.jdkdigital.productivebees.integrations.jei.BeeConversionRecipeCategory;
import cy.jdkdigital.productivebees.integrations.jei.BeeFloweringRecipeCategory;
import cy.jdkdigital.productivebees.integrations.jei.BeeSpawningRecipeBigCategory;
import cy.jdkdigital.productivebees.integrations.jei.BeeSpawningRecipeCategory;
import cy.jdkdigital.productivebees.integrations.jei.CentrifugeRecipeCategory;
import cy.jdkdigital.productivebees.integrations.jei.IncubationRecipeCategory;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredientFactory;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredientHelper;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredientRenderer;
import cy.jdkdigital.productivebees.recipe.AdvancedBeehiveRecipe;
import cy.jdkdigital.productivebees.recipe.BeeBreedingRecipe;
import cy.jdkdigital.productivebees.recipe.BeeConversionRecipe;
import cy.jdkdigital.productivebees.recipe.BeeSpawningBigRecipe;
import cy.jdkdigital.productivebees.recipe.BeeSpawningRecipe;
import cy.jdkdigital.productivebees.recipe.CentrifugeRecipe;
import cy.jdkdigital.productivebees.recipe.ConfigurableHoneycombRecipe;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

@JeiPlugin
public class ProductiveBeesJeiPlugin
implements IModPlugin {
    private static final ResourceLocation pluginId = new ResourceLocation("productivebees", "productivebees");
    public static final ResourceLocation CATEGORY_ADVANCED_BEEHIVE_UID = new ResourceLocation("productivebees", "advanced_beehive");
    public static final ResourceLocation CATEGORY_BEE_BREEDING_UID = new ResourceLocation("productivebees", "bee_breeding");
    public static final ResourceLocation CATEGORY_BEE_CONVERSION_UID = new ResourceLocation("productivebees", "bee_conversion");
    public static final ResourceLocation CATEGORY_BEE_SPAWNING_UID = new ResourceLocation("productivebees", "bee_spawning");
    public static final ResourceLocation CATEGORY_BEE_SPAWNING_BIG_UID = new ResourceLocation("productivebees", "bee_spawning_big");
    public static final ResourceLocation CATEGORY_CENTRIFUGE_UID = new ResourceLocation("productivebees", "centrifuge");
    public static final ResourceLocation CATEGORY_BEE_FLOWERING_UID = new ResourceLocation("productivebees", "bee_flowering");
    public static final ResourceLocation CATEGORY_INCUBATION_UID = new ResourceLocation("productivebees", "incubation");
    public static final IIngredientType<BeeIngredient> BEE_INGREDIENT = () -> BeeIngredient.class;

    public ProductiveBeesJeiPlugin() {
        BeeIngredientFactory.createList();
    }

    @Nonnull
    public ResourceLocation getPluginUid() {
        return pluginId;
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.ADVANCED_OAK_BEEHIVE.get()), new ResourceLocation[]{CATEGORY_ADVANCED_BEEHIVE_UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.CENTRIFUGE.get()), new ResourceLocation[]{CATEGORY_CENTRIFUGE_UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.POWERED_CENTRIFUGE.get()), new ResourceLocation[]{CATEGORY_CENTRIFUGE_UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.COARSE_DIRT_NEST.get()), new ResourceLocation[]{CATEGORY_BEE_SPAWNING_UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.OAK_WOOD_NEST.get()), new ResourceLocation[]{CATEGORY_BEE_SPAWNING_BIG_UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.INCUBATOR.get()), new ResourceLocation[]{CATEGORY_INCUBATION_UID});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new AdvancedBeehiveRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BeeBreedingRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BeeConversionRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new CentrifugeRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BeeSpawningRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BeeSpawningRecipeBigCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BeeFloweringRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new IncubationRecipeCategory(guiHelper)});
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        Collection<BeeIngredient> ingredients = BeeIngredientFactory.getOrCreateList(true).values();
        registration.register(BEE_INGREDIENT, new ArrayList<BeeIngredient>(ingredients), (IIngredientHelper)new BeeIngredientHelper(), (IIngredientRenderer)new BeeIngredientRenderer());
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.useNbtForSubtypes(new Item[]{(Item)ModItems.WOOD_CHIP.get()});
        registration.useNbtForSubtypes(new Item[]{(Item)ModItems.STONE_CHIP.get()});
        registration.useNbtForSubtypes(new Item[]{(Item)ModItems.CONFIGURABLE_HONEYCOMB.get()});
        registration.useNbtForSubtypes(new Item[]{(Item)ModItems.CONFIGURABLE_SPAWN_EGG.get()});
        registration.useNbtForSubtypes(new Item[]{(Item)ModItems.CONFIGURABLE_COMB_BLOCK.get()});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager recipeManager = Minecraft.func_71410_x().field_71441_e.func_199532_z();
        Map advancedBeehiveRecipesMap = recipeManager.func_215366_a(AdvancedBeehiveRecipe.ADVANCED_BEEHIVE);
        registration.addRecipes(advancedBeehiveRecipesMap.values(), CATEGORY_ADVANCED_BEEHIVE_UID);
        Map centrifugeRecipesMap = recipeManager.func_215366_a(CentrifugeRecipe.CENTRIFUGE);
        registration.addRecipes(centrifugeRecipesMap.values(), CATEGORY_CENTRIFUGE_UID);
        Map beeSpawningRecipesMap = recipeManager.func_215366_a(BeeSpawningRecipe.BEE_SPAWNING);
        registration.addRecipes(beeSpawningRecipesMap.values(), CATEGORY_BEE_SPAWNING_UID);
        Map beeSpawningRecipesBigMap = recipeManager.func_215366_a(BeeSpawningBigRecipe.BEE_SPAWNING);
        registration.addRecipes(beeSpawningRecipesBigMap.values(), CATEGORY_BEE_SPAWNING_BIG_UID);
        Map beeBreedingRecipeMap = recipeManager.func_215366_a(BeeBreedingRecipe.BEE_BREEDING);
        registration.addRecipes(beeBreedingRecipeMap.values(), CATEGORY_BEE_BREEDING_UID);
        Map beeConversionRecipeMap = recipeManager.func_215366_a(BeeConversionRecipe.BEE_CONVERSION);
        registration.addRecipes(beeConversionRecipeMap.values(), CATEGORY_BEE_CONVERSION_UID);
        List<String> notInfoBees = Arrays.asList("minecraft:bee", "configurable_bee");
        Map<String, BeeIngredient> beeList = BeeIngredientFactory.getOrCreateList();
        for (Map.Entry<String, BeeIngredient> entry : beeList.entrySet()) {
            String beeId = entry.getKey().replace("productivebees:", "");
            if (notInfoBees.contains(beeId)) continue;
            if (entry.getValue().isConfigurable()) {
                CompoundNBT nbt = BeeReloadListener.INSTANCE.getData(entry.getKey());
                if (!nbt.func_74764_b("description")) continue;
                registration.addIngredientInfo((Object)entry.getValue(), BEE_INGREDIENT, new String[]{nbt.func_74779_i("description")});
                continue;
            }
            registration.addIngredientInfo((Object)entry.getValue(), BEE_INGREDIENT, new String[]{"productivebees.ingredient.description." + beeId});
        }
        registration.addRecipes(BeeFloweringRecipeCategory.getFlowersRecipes(beeList), CATEGORY_BEE_FLOWERING_UID);
        registration.addRecipes(IncubationRecipeCategory.getRecipes(beeList), CATEGORY_INCUBATION_UID);
        List<String> itemInfos = Arrays.asList("inactive_dragon_egg", "stone_nest", "sand_nest", "snow_nest", "gravel_nest", "coarse_dirt_nest", "oak_wood_nest", "spruce_wood_nest", "acacia_wood_nest", "dark_oak_wood_nest", "jungle_wood_nest", "birch_wood_nest", "end_stone_nest", "obsidian_nest", "glowstone_nest", "nether_brick_nest", "nether_quartz_nest");
        for (String itemName : itemInfos) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("productivebees", itemName));
            registration.addIngredientInfo((Object)new ItemStack((IItemProvider)item), VanillaTypes.ITEM, new String[]{"productivebees.ingredient.description." + itemName});
        }
        Optional honeycombRecipe = recipeManager.func_215367_a(new ResourceLocation("productivebees", "comb_block/configurable_honeycomb"));
        int count = 4;
        if (honeycombRecipe.isPresent()) {
            count = ((ConfigurableHoneycombRecipe)honeycombRecipe.get()).count;
        }
        HashMap<ResourceLocation, ShapelessRecipe> recipes = new HashMap<ResourceLocation, ShapelessRecipe>();
        for (Map.Entry<String, CompoundNBT> entry : BeeReloadListener.INSTANCE.getData().entrySet()) {
            String beeType = entry.getKey();
            ResourceLocation idComb = new ResourceLocation(beeType + "_honeycomb");
            ResourceLocation idCombBlock = new ResourceLocation(beeType + "_comb");
            ItemStack comb = new ItemStack((IItemProvider)ModItems.CONFIGURABLE_HONEYCOMB.get());
            ModItemGroups.ModItemGroup.setTag(beeType, comb);
            NonNullList combInput = NonNullList.func_191196_a();
            for (int i = 0; i < count; ++i) {
                combInput.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{comb}));
            }
            ItemStack combBlock = new ItemStack((IItemProvider)ModItems.CONFIGURABLE_COMB_BLOCK.get());
            ModItemGroups.ModItemGroup.setTag(beeType, combBlock);
            NonNullList combBlockInput = NonNullList.func_191196_a();
            combBlockInput.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{combBlock}));
            recipes.put(idComb, new ShapelessRecipe(idComb, "", combBlock, combInput));
            ItemStack combOutput = comb.func_77946_l();
            combOutput.func_190920_e(count);
            recipes.put(idCombBlock, new ShapelessRecipe(idCombBlock, "", combOutput, combBlockInput));
        }
        registration.addRecipes(recipes.values(), VanillaRecipeCategoryUid.CRAFTING);
    }
}

