/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.integrations.jei.ingredients;

import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBeeEntity;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class BeeIngredient {
    private static Map<BeeIngredient, BeeEntity> cache = new HashMap<BeeIngredient, BeeEntity>();
    private EntityType<? extends BeeEntity> bee;
    private ResourceLocation beeType;
    private int renderType = 0;
    private boolean configurable = false;

    public BeeIngredient(EntityType<? extends BeeEntity> bee, int renderType) {
        this.bee = bee;
        this.renderType = renderType;
    }

    public BeeIngredient(EntityType<? extends BeeEntity> bee, ResourceLocation beeType, int renderType) {
        this(bee, renderType);
        this.beeType = beeType;
    }

    public BeeIngredient(EntityType<? extends BeeEntity> bee, ResourceLocation beeType, int renderType, boolean isConfigurable) {
        this(bee, renderType);
        this.beeType = beeType;
        this.configurable = isConfigurable;
    }

    public EntityType<? extends BeeEntity> getBeeEntity() {
        return this.bee;
    }

    public BeeEntity getCachedEntity(World world) {
        if (!cache.containsKey(this)) {
            BeeEntity newBee = (BeeEntity)this.getBeeEntity().func_200721_a(world);
            if (newBee instanceof ConfigurableBeeEntity) {
                ((ConfigurableBeeEntity)newBee).setBeeType(this.getBeeType().toString());
                ((ConfigurableBeeEntity)newBee).setAttributes();
            }
            cache.put(this, newBee);
        }
        return cache.get(this);
    }

    public ResourceLocation getBeeType() {
        return this.beeType != null ? this.beeType : this.bee.getRegistryName();
    }

    public int getRenderType() {
        return this.renderType;
    }

    public static BeeIngredient read(PacketBuffer buffer) {
        String beeName = buffer.func_218666_n();
        return new BeeIngredient((EntityType<? extends BeeEntity>)((EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(beeName))), buffer.func_192575_l(), buffer.readInt(), buffer.readBoolean());
    }

    public final void write(PacketBuffer buffer) {
        buffer.func_180714_a("" + this.bee.getRegistryName());
        buffer.func_192572_a(this.getBeeType());
        buffer.writeInt(this.renderType);
        buffer.writeBoolean(this.configurable);
    }

    public String toString() {
        return "BeeIngredient{bee=" + this.bee + ", beeType=" + this.beeType + ", renderType=" + this.renderType + '}';
    }

    public boolean isConfigurable() {
        return this.configurable;
    }
}

