/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.integrations.jei.ingredients;

import cy.jdkdigital.productivebees.init.ModEntities;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;

public class BeeIngredientFactory {
    private static Map<String, BeeIngredient> ingredientList = new HashMap<String, BeeIngredient>();

    public static Map<String, BeeIngredient> getOrCreateList(boolean removeDeprecated) {
        HashMap<String, BeeIngredient> list = new HashMap();
        if (removeDeprecated) {
            for (Map.Entry<String, BeeIngredient> entry : BeeIngredientFactory.createList().entrySet()) {
                String beeId = entry.getKey().replace("productivebees:", "");
                if (beeId.equals("configurable_bee")) continue;
                list.put(entry.getKey(), entry.getValue());
            }
        } else {
            list = BeeIngredientFactory.createList();
        }
        return list;
    }

    public static Map<String, BeeIngredient> getOrCreateList() {
        return BeeIngredientFactory.createList();
    }

    public static Supplier<BeeIngredient> getIngredient(String name) {
        return () -> BeeIngredientFactory.getOrCreateList().get(name);
    }

    public static Map<String, BeeIngredient> createList() {
        if (ingredientList.isEmpty()) {
            EntityType bee;
            ingredientList.put(EntityType.field_226289_e_.getRegistryName() + "", new BeeIngredient((EntityType<? extends BeeEntity>)EntityType.field_226289_e_, 0));
            for (RegistryObject registryObject : ModEntities.HIVE_BEES.getEntries()) {
                bee = (EntityType)registryObject.get();
                BeeIngredientFactory.addBee(bee.getRegistryName().toString(), new BeeIngredient((EntityType<? extends BeeEntity>)bee, 0));
            }
            for (RegistryObject registryObject : ModEntities.SOLITARY_BEES.getEntries()) {
                bee = (EntityType)registryObject.get();
                BeeIngredientFactory.addBee(bee.getRegistryName().toString(), new BeeIngredient((EntityType<? extends BeeEntity>)bee, 1));
            }
        }
        for (Map.Entry<String, CompoundNBT> entry : BeeReloadListener.INSTANCE.getData().entrySet()) {
            String beeType = entry.getKey();
            EntityType bee = (EntityType)ModEntities.CONFIGURABLE_BEE.get();
            BeeIngredientFactory.addBee(beeType, new BeeIngredient((EntityType<? extends BeeEntity>)bee, new ResourceLocation(beeType), 0, true));
        }
        return ingredientList;
    }

    public static void addBee(String name, BeeIngredient bee) {
        ingredientList.put(name, bee);
    }
}

