/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.network.packets;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.network.NetworkEvent;

public class Messages {

    public static class BeesMessage {
        public Map<String, CompoundNBT> data;

        public BeesMessage(Map<String, CompoundNBT> data) {
            this.data = data;
        }

        public static void encode(BeesMessage message, PacketBuffer buffer) {
            buffer.writeInt(message.data.size());
            for (Map.Entry<String, CompoundNBT> entry : message.data.entrySet()) {
                buffer.func_180714_a(entry.getKey());
                buffer.func_150786_a(entry.getValue());
            }
        }

        public static BeesMessage decode(PacketBuffer buffer) {
            HashMap<String, CompoundNBT> data = new HashMap<String, CompoundNBT>();
            IntStream.range(0, buffer.readInt()).forEach(i -> data.put(buffer.func_218666_n(), buffer.func_150793_b()));
            return new BeesMessage(data);
        }

        public static void handle(BeesMessage message, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                BeeReloadListener.INSTANCE.setData(message.data);
                ProductiveBees.LOGGER.info("trigger recipe reload");
                RecipeManager manager = ProductiveBees.proxy.getClientWorld().func_199532_z();
                ForgeHooksClient.onRecipesUpdated((RecipeManager)manager);
            });
            context.get().setPacketHandled(true);
        }
    }
}

