/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredientFactory;
import cy.jdkdigital.productivebees.util.BeeHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class BeeBreedingRecipe
implements IRecipe<IInventory> {
    public static final IRecipeType<BeeBreedingRecipe> BEE_BREEDING = IRecipeType.func_222147_a((String)"productivebees:bee_breeding");
    public final ResourceLocation id;
    public final List<Lazy<BeeIngredient>> ingredients;
    public final Map<Lazy<BeeIngredient>, Integer> offspring;

    public BeeBreedingRecipe(ResourceLocation id, List<Lazy<BeeIngredient>> ingredients, Map<Lazy<BeeIngredient>, Integer> offspring) {
        this.id = id;
        this.ingredients = ingredients;
        this.offspring = offspring;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        if (inv instanceof BeeHelper.IdentifierInventory) {
            String beeName1 = ((BeeHelper.IdentifierInventory)inv).getIdentifier(0);
            String beeName2 = ((BeeHelper.IdentifierInventory)inv).getIdentifier(1);
            for (Lazy<BeeIngredient> parent : this.ingredients) {
                if (parent.get() != null) {
                    String parentName = ((BeeIngredient)parent.get()).getBeeType().toString();
                    if (parentName.equals(beeName1) || parentName.equals(beeName2)) continue;
                    return false;
                }
                ProductiveBees.LOGGER.warn("Bee not found in breeding recipe " + parent);
                return false;
            }
            return true;
        }
        return false;
    }

    @Nonnull
    public ItemStack func_77572_b(IInventory inv) {
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipeTypes.BEE_BREEDING.get();
    }

    @Nonnull
    public IRecipeType<?> func_222127_g() {
        return BEE_BREEDING;
    }

    public static class Serializer<T extends BeeBreedingRecipe>
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<T> {
        final IRecipeFactory<T> factory;

        public Serializer(IRecipeFactory<T> factory) {
            this.factory = factory;
        }

        @Nonnull
        public T read(ResourceLocation id, JsonObject json) {
            String parentName1 = JSONUtils.func_151200_h((JsonObject)json, (String)"parent1");
            String parentName2 = JSONUtils.func_151200_h((JsonObject)json, (String)"parent2");
            LinkedHashMap<Lazy<BeeIngredient>, Integer> children = new LinkedHashMap<Lazy<BeeIngredient>, Integer>();
            JsonArray offspring = JSONUtils.func_151214_t((JsonObject)json, (String)"offspring");
            offspring.forEach(el -> {
                if (el.isJsonObject()) {
                    String child = JSONUtils.func_151206_a((JsonElement)el, (String)"offspring");
                    children.put(Lazy.of(BeeIngredientFactory.getIngredient(child)), JSONUtils.func_151215_f((JsonElement)el, (String)"weight"));
                } else {
                    String child = el.getAsString();
                    children.put(Lazy.of(BeeIngredientFactory.getIngredient(child)), 1);
                }
            });
            Lazy beeIngredientParent1 = Lazy.of(BeeIngredientFactory.getIngredient(parentName1));
            Lazy beeIngredientParent2 = Lazy.of(BeeIngredientFactory.getIngredient(parentName2));
            return this.factory.create(id, Arrays.asList(beeIngredientParent1, beeIngredientParent2), children);
        }

        public T read(@Nonnull ResourceLocation id, @Nonnull PacketBuffer buffer) {
            try {
                ArrayList<Lazy<BeeIngredient>> ingredients = new ArrayList<Lazy<BeeIngredient>>();
                BeeIngredient ing1 = BeeIngredient.read(buffer);
                BeeIngredient ing2 = BeeIngredient.read(buffer);
                ingredients.add(Lazy.of(() -> ing1));
                ingredients.add(Lazy.of(() -> ing2));
                LinkedHashMap<Lazy<BeeIngredient>, Integer> offspring = new LinkedHashMap<Lazy<BeeIngredient>, Integer>();
                IntStream.range(0, buffer.readInt()).forEach(i -> {
                    BeeIngredient result = BeeIngredient.read(buffer);
                    offspring.put(Lazy.of(() -> result), buffer.readInt());
                });
                return this.factory.create(id, ingredients, offspring);
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading bee breeding recipe from packet. " + id, (Throwable)e);
                throw e;
            }
        }

        public void write(@Nonnull PacketBuffer buffer, T recipe) {
            try {
                for (Lazy<BeeIngredient> ingredient : ((BeeBreedingRecipe)recipe).ingredients) {
                    if (ingredient.get() != null) {
                        ((BeeIngredient)ingredient.get()).write(buffer);
                        continue;
                    }
                    ProductiveBees.LOGGER.error("Bee breeding recipe ingredient missing " + ((BeeBreedingRecipe)recipe).func_199560_c() + " - " + ingredient);
                }
                buffer.writeInt(((BeeBreedingRecipe)recipe).offspring.size());
                ((BeeBreedingRecipe)recipe).offspring.forEach((child, weight) -> {
                    if (child.get() != null) {
                        ((BeeIngredient)child.get()).write(buffer);
                        buffer.writeInt(weight.intValue());
                    } else {
                        ProductiveBees.LOGGER.error("Bee breeding recipe child missing " + recipe.func_199560_c() + " - " + child);
                    }
                });
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing bee breeding recipe to packet. " + ((BeeBreedingRecipe)recipe).func_199560_c(), (Throwable)e);
                throw e;
            }
        }

        public static interface IRecipeFactory<T extends BeeBreedingRecipe> {
            public T create(ResourceLocation var1, List<Lazy<BeeIngredient>> var2, Map<Lazy<BeeIngredient>, Integer> var3);
        }
    }
}

