/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredientFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class BeeSpawningRecipe
implements IRecipe<IInventory> {
    public static final IRecipeType<BeeSpawningRecipe> BEE_SPAWNING = IRecipeType.func_222147_a((String)"productivebees:bee_spawning");
    public final ResourceLocation id;
    public final Ingredient ingredient;
    public final List<Lazy<BeeIngredient>> output;
    public final List<String> biomes;
    public final String temperature;
    public final int repopulationCooldown;

    public BeeSpawningRecipe(ResourceLocation id, Ingredient ingredient, List<Lazy<BeeIngredient>> output, List<String> biomes, String temperature, int repopulationCooldown) {
        this.id = id;
        this.ingredient = ingredient;
        this.output = output;
        this.biomes = biomes;
        this.temperature = temperature;
        this.repopulationCooldown = repopulationCooldown;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        ItemStack inventoryItem = null;
        for (int j = 0; j < inv.func_70302_i_(); ++j) {
            ItemStack itemstack = inv.func_70301_a(j);
            if (itemstack.func_190926_b()) continue;
            if (inventoryItem != null) {
                return false;
            }
            inventoryItem = itemstack;
        }
        return this.matches(inventoryItem);
    }

    public boolean matches(ItemStack nest) {
        return this.ingredient.test(nest);
    }

    @Nonnull
    public ItemStack func_77572_b(IInventory inv) {
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipeTypes.BEE_SPAWNING.get();
    }

    @Nonnull
    public IRecipeType<?> func_222127_g() {
        return BEE_SPAWNING;
    }

    public static class Serializer<T extends BeeSpawningRecipe>
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<T> {
        final IRecipeFactory<T> factory;

        public Serializer(IRecipeFactory<T> factory) {
            this.factory = factory;
        }

        @Nonnull
        public T read(ResourceLocation id, JsonObject json) {
            Ingredient ingredient = JSONUtils.func_151202_d((JsonObject)json, (String)"ingredient") ? Ingredient.func_199802_a((JsonElement)JSONUtils.func_151214_t((JsonObject)json, (String)"ingredient")) : Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient"));
            JsonArray jsonArray = JSONUtils.func_151214_t((JsonObject)json, (String)"results");
            ArrayList<Lazy<BeeIngredient>> output = new ArrayList<Lazy<BeeIngredient>>();
            jsonArray.forEach(el -> {
                JsonObject jsonObject = el.getAsJsonObject();
                String beeName = JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"bee");
                Lazy beeIngredient = Lazy.of(BeeIngredientFactory.getIngredient(beeName));
                output.add(beeIngredient);
            });
            ArrayList<String> biomes = new ArrayList<String>();
            if (json.has("biomes")) {
                JSONUtils.func_151214_t((JsonObject)json, (String)"biomes").forEach(jsonElement -> biomes.add(jsonElement.getAsString()));
            }
            String temperature = json.has("temperature") ? json.get("temperature").getAsString() : "any";
            int repopulationCooldown = JSONUtils.func_151208_a((JsonObject)json, (String)"repopulation_cooldown", (int)36000);
            return this.factory.create(id, ingredient, output, biomes, temperature, repopulationCooldown);
        }

        public T read(@Nonnull ResourceLocation id, @Nonnull PacketBuffer buffer) {
            try {
                Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
                ArrayList<Lazy<BeeIngredient>> output = new ArrayList<Lazy<BeeIngredient>>();
                IntStream.range(0, buffer.readInt()).forEach(i -> {
                    BeeIngredient ing = BeeIngredient.read(buffer);
                    output.add(Lazy.of(() -> ing));
                });
                ArrayList<String> biomes = new ArrayList<String>();
                IntStream.range(0, buffer.readInt()).forEach(i -> biomes.add(buffer.func_218666_n()));
                String temperature = buffer.func_218666_n();
                int repopulationCooldown = buffer.readInt();
                return this.factory.create(id, ingredient, output, biomes, temperature, repopulationCooldown);
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading bee spawning recipe from packet. " + id, (Throwable)e);
                throw e;
            }
        }

        public void write(@Nonnull PacketBuffer buffer, T recipe) {
            try {
                ((BeeSpawningRecipe)recipe).ingredient.func_199564_a(buffer);
                buffer.writeInt(((BeeSpawningRecipe)recipe).output.size());
                for (Lazy<BeeIngredient> beeOutput : ((BeeSpawningRecipe)recipe).output) {
                    if (beeOutput.get() != null) {
                        ((BeeIngredient)beeOutput.get()).write(buffer);
                        continue;
                    }
                    ProductiveBees.LOGGER.error("Bee spawning recipe output missing " + ((BeeSpawningRecipe)recipe).func_199560_c() + " - " + beeOutput);
                }
                buffer.writeInt(((BeeSpawningRecipe)recipe).biomes.size());
                ((BeeSpawningRecipe)recipe).biomes.forEach(arg_0 -> ((PacketBuffer)buffer).func_180714_a(arg_0));
                buffer.func_180714_a(((BeeSpawningRecipe)recipe).temperature);
                buffer.writeInt(((BeeSpawningRecipe)recipe).repopulationCooldown);
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing bee spawning recipe to packet. " + ((BeeSpawningRecipe)recipe).func_199560_c(), (Throwable)e);
                throw e;
            }
        }

        public static interface IRecipeFactory<T extends BeeSpawningRecipe> {
            public T create(ResourceLocation var1, Ingredient var2, List<Lazy<BeeIngredient>> var3, List<String> var4, String var5, int var6);
        }
    }
}

