/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class IncubationRecipe
implements IRecipe<IInventory> {
    public static final IRecipeType<IncubationRecipe> BEE_CONVERSION = IRecipeType.func_222147_a((String)"productivebees:incubation");
    public final ResourceLocation id;
    public final Ingredient input;
    public final Ingredient catalyst;
    public final Ingredient result;

    public IncubationRecipe(ResourceLocation id, Ingredient input, Ingredient catalyst, Ingredient result) {
        this.id = id;
        this.input = input;
        this.catalyst = catalyst;
        this.result = result;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return false;
    }

    @Nonnull
    public ItemStack func_77572_b(IInventory inv) {
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipeTypes.BEE_CONVERSION.get();
    }

    @Nonnull
    public IRecipeType<?> func_222127_g() {
        return BEE_CONVERSION;
    }

    public static class Serializer<T extends IncubationRecipe>
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<T> {
        final IRecipeFactory<T> factory;

        public Serializer(IRecipeFactory<T> factory) {
            this.factory = factory;
        }

        @Nonnull
        public T read(ResourceLocation id, JsonObject json) {
            Ingredient input = JSONUtils.func_151202_d((JsonObject)json, (String)"input") ? Ingredient.func_199802_a((JsonElement)JSONUtils.func_151214_t((JsonObject)json, (String)"input")) : Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"input"));
            Ingredient catalyst = JSONUtils.func_151202_d((JsonObject)json, (String)"catalyst") ? Ingredient.func_199802_a((JsonElement)JSONUtils.func_151214_t((JsonObject)json, (String)"catalyst")) : Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"catalyst"));
            Ingredient output = JSONUtils.func_151202_d((JsonObject)json, (String)"output") ? Ingredient.func_199802_a((JsonElement)JSONUtils.func_151214_t((JsonObject)json, (String)"output")) : Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"output"));
            return this.factory.create(id, input, catalyst, output);
        }

        public T read(@Nonnull ResourceLocation id, @Nonnull PacketBuffer buffer) {
            try {
                return this.factory.create(id, Ingredient.func_199566_b((PacketBuffer)buffer), Ingredient.func_199566_b((PacketBuffer)buffer), Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading bee incubation recipe from packet. " + id, (Throwable)e);
                throw e;
            }
        }

        public void write(@Nonnull PacketBuffer buffer, T recipe) {
            try {
                ((IncubationRecipe)recipe).input.func_199564_a(buffer);
                ((IncubationRecipe)recipe).catalyst.func_199564_a(buffer);
                ((IncubationRecipe)recipe).result.func_199564_a(buffer);
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing bee incubation recipe to packet. " + ((IncubationRecipe)recipe).func_199560_c(), (Throwable)e);
                throw e;
            }
        }

        public static interface IRecipeFactory<T extends IncubationRecipe> {
            public T create(ResourceLocation var1, Ingredient var2, Ingredient var3, Ingredient var4);
        }
    }
}

