/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.recipe;

import com.google.gson.JsonObject;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.common.item.StoneChip;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class StoneChipRecipe
implements ICraftingRecipe {
    public final ResourceLocation id;
    public final Integer count;

    public StoneChipRecipe(ResourceLocation id, Integer count) {
        this.id = id;
        this.count = count;
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        Block chipBlock = null;
        int matchingStacks = 0;
        for (int j = 0; j < inv.func_70302_i_(); ++j) {
            ItemStack itemstack = inv.func_70301_a(j);
            if (itemstack.func_190926_b()) continue;
            if (chipBlock == null && itemstack.func_77973_b().equals(ModItems.STONE_CHIP.get())) {
                chipBlock = StoneChip.getBlock(itemstack);
            }
            if (itemstack.func_77973_b().equals(ModItems.STONE_CHIP.get()) && StoneChip.getBlock(itemstack).equals(chipBlock)) {
                ++matchingStacks;
                continue;
            }
            return false;
        }
        return matchingStacks == this.count;
    }

    @Nonnull
    public ItemStack getCraftingResult(CraftingInventory inv) {
        ItemStack stack = inv.func_70301_a(0);
        return new ItemStack((IItemProvider)StoneChip.getBlock(stack));
    }

    public boolean func_194133_a(int width, int height) {
        int min = this.count > 4 ? 3 : 2;
        return width >= min && height >= min;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return new ItemStack((IItemProvider)Items.field_221574_b);
    }

    @Nonnull
    public NonNullList<Ingredient> func_192400_c() {
        NonNullList list = NonNullList.func_191196_a();
        for (int i = 0; i < this.count; ++i) {
            list.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{StoneChip.getStack(Blocks.field_150348_b)}));
        }
        return list;
    }

    @Nonnull
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipeTypes.STONE_CHIP.get();
    }

    public static class Serializer<T extends StoneChipRecipe>
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<T> {
        final IRecipeFactory<T> factory;

        public Serializer(IRecipeFactory<T> factory) {
            this.factory = factory;
        }

        public T read(ResourceLocation id, JsonObject json) {
            Integer count = JSONUtils.func_151208_a((JsonObject)json, (String)"count", (int)9);
            return this.factory.create(id, count);
        }

        public T read(@Nonnull ResourceLocation id, @Nonnull PacketBuffer buffer) {
            try {
                return this.factory.create(id, buffer.readInt());
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading stone chip recipe from packet. " + id, (Throwable)e);
                throw e;
            }
        }

        public void write(@Nonnull PacketBuffer buffer, T recipe) {
            try {
                buffer.writeInt(((StoneChipRecipe)recipe).count.intValue());
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing stone chip recipe to packet. " + ((StoneChipRecipe)recipe).func_199560_c(), (Throwable)e);
                throw e;
            }
        }

        public static interface IRecipeFactory<T extends StoneChipRecipe> {
            public T create(ResourceLocation var1, Integer var2);
        }
    }
}

