/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.recipe;

import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class TagOutputRecipe {
    public final Map<Ingredient, IntArrayNBT> itemOutput;
    public final Map<ItemStack, IntArrayNBT> calculatedItemOutput = new LinkedHashMap<ItemStack, IntArrayNBT>();
    public static Map<String, Integer> modPreference = new HashMap<String, Integer>();

    public TagOutputRecipe(Ingredient itemOutput) {
        this.itemOutput = new LinkedHashMap<Ingredient, IntArrayNBT>();
        this.itemOutput.put(itemOutput, new IntArrayNBT(new int[]{1, 1, 100}));
    }

    public TagOutputRecipe(Map<Ingredient, IntArrayNBT> itemOutput) {
        this.itemOutput = itemOutput;
    }

    public Map<ItemStack, IntArrayNBT> getRecipeOutputs() {
        if (this.calculatedItemOutput.isEmpty() && !this.itemOutput.isEmpty()) {
            this.itemOutput.forEach((ingredient, intNBTS) -> {
                ItemStack preferredItem = TagOutputRecipe.getPreferredItemByMod(ingredient);
                if (preferredItem != null && !preferredItem.func_77973_b().equals(Items.field_221803_eL)) {
                    this.calculatedItemOutput.put(preferredItem.func_77946_l(), intNBTS.func_74737_b());
                }
            });
        }
        return this.calculatedItemOutput;
    }

    private static ItemStack getPreferredItemByMod(Ingredient ingredient) {
        List<ItemStack> stacks = Arrays.asList(ingredient.func_193365_a());
        return TagOutputRecipe.getPreferredItemByMod(stacks);
    }

    private static ItemStack getPreferredItemByMod(List<ItemStack> list) {
        ItemStack preferredItem = null;
        int currBest = TagOutputRecipe.getModPreference().size();
        for (ItemStack item : list) {
            ResourceLocation rl = item.func_77973_b().getRegistryName();
            if (rl == null) continue;
            String modId = rl.func_110624_b();
            int priority = 100;
            if (TagOutputRecipe.getModPreference().containsKey(modId)) {
                priority = TagOutputRecipe.getModPreference().get(modId);
            }
            if (preferredItem != null && (priority < 0 || priority >= currBest)) continue;
            preferredItem = item;
            currBest = priority;
        }
        return preferredItem;
    }

    public static Fluid getPreferredFluidByMod(String fluidName) {
        Fluid preferredFluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidName));
        if (preferredFluid == null || preferredFluid.equals(Fluids.field_204541_a)) {
            try {
                Tag fluidTag = FluidTags.func_226157_a_().func_199910_a(new ResourceLocation(fluidName));
                if (fluidTag != null && fluidTag.func_199885_a().size() > 0) {
                    int currBest = TagOutputRecipe.getModPreference().size();
                    for (Fluid fluid : fluidTag.func_199885_a()) {
                        ResourceLocation rl;
                        if (fluid instanceof FlowingFluid) {
                            fluid = ((FlowingFluid)fluid).func_210198_f();
                        }
                        if ((rl = fluid.getRegistryName()) == null) continue;
                        String modId = rl.func_110624_b();
                        int priority = 100;
                        if (TagOutputRecipe.getModPreference().containsKey(modId)) {
                            priority = TagOutputRecipe.getModPreference().get(modId);
                        }
                        if (preferredFluid != null && (priority < 0 || priority >= currBest)) continue;
                        preferredFluid = fluid;
                        currBest = priority;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return preferredFluid;
    }

    private static Map<String, Integer> getModPreference() {
        if (modPreference.size() > 0) {
            return modPreference;
        }
        int priority = 0;
        for (String modId : (List)ProductiveBeesConfig.GENERAL.preferredTagSource.get()) {
            if (!ModList.get().isLoaded(modId)) continue;
            modPreference.put(modId, ++priority);
        }
        return modPreference;
    }
}

