/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.setup;

import cy.jdkdigital.productivebees.client.particle.FallingNectarParticle;
import cy.jdkdigital.productivebees.client.particle.LavaNectarParticle;
import cy.jdkdigital.productivebees.client.particle.PoppingNectarParticle;
import cy.jdkdigital.productivebees.client.particle.PortalNectarParticle;
import cy.jdkdigital.productivebees.client.render.block.BottlerTileEntityRenderer;
import cy.jdkdigital.productivebees.client.render.block.CentrifugeTileEntityRenderer;
import cy.jdkdigital.productivebees.client.render.block.FeederTileEntityRenderer;
import cy.jdkdigital.productivebees.client.render.block.JarTileEntityRenderer;
import cy.jdkdigital.productivebees.client.render.entity.DyeBeeRenderer;
import cy.jdkdigital.productivebees.client.render.entity.HoarderBeeRenderer;
import cy.jdkdigital.productivebees.client.render.entity.ProductiveBeeRenderer;
import cy.jdkdigital.productivebees.client.render.entity.RancherBeeRenderer;
import cy.jdkdigital.productivebees.common.block.CombBlock;
import cy.jdkdigital.productivebees.common.item.Honeycomb;
import cy.jdkdigital.productivebees.common.item.SpawnEgg;
import cy.jdkdigital.productivebees.container.gui.AdvancedBeehiveScreen;
import cy.jdkdigital.productivebees.container.gui.BottlerScreen;
import cy.jdkdigital.productivebees.container.gui.CatcherScreen;
import cy.jdkdigital.productivebees.container.gui.CentrifugeScreen;
import cy.jdkdigital.productivebees.container.gui.FeederScreen;
import cy.jdkdigital.productivebees.container.gui.HoneyGeneratorScreen;
import cy.jdkdigital.productivebees.container.gui.IncubatorScreen;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModContainerTypes;
import cy.jdkdigital.productivebees.init.ModEntities;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModParticles;
import cy.jdkdigital.productivebees.init.ModTileEntityTypes;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.entity.SpriteRenderer;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.particles.ParticleType;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GrassColors;
import net.minecraft.world.ILightReader;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="productivebees", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientSetup {
    public static void init(FMLClientSetupEvent event) {
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainerTypes.ADVANCED_BEEHIVE.get()), AdvancedBeehiveScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainerTypes.CENTRIFUGE.get()), CentrifugeScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainerTypes.POWERED_CENTRIFUGE.get()), CentrifugeScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainerTypes.BOTTLER.get()), BottlerScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainerTypes.FEEDER.get()), FeederScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainerTypes.INCUBATOR.get()), IncubatorScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainerTypes.CATCHER.get()), CatcherScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainerTypes.HONEY_GENERATOR.get()), HoneyGeneratorScreen::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ModTileEntityTypes.CENTRIFUGE.get()), CentrifugeTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ModTileEntityTypes.POWERED_CENTRIFUGE.get()), CentrifugeTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ModTileEntityTypes.BOTTLER.get()), BottlerTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ModTileEntityTypes.FEEDER.get()), FeederTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ModTileEntityTypes.JAR.get()), JarTileEntityRenderer::new);
        ClientSetup.registerEntityRendering();
        ClientSetup.registerBlockRendering();
    }

    public static void registerItemColors(ColorHandlerEvent.Item event) {
        Item item;
        ItemColors colors = event.getItemColors();
        BlockColors blockColors = event.getBlockColors();
        for (RegistryObject<Item> eggItem : ModItems.SPAWN_EGGS) {
            if (ObfuscationReflectionHelper.getPrivateValue(RegistryObject.class, eggItem, (String)"value") == null || !((item = (Item)eggItem.get()) instanceof SpawnEgg)) continue;
            colors.func_199877_a((stack, tintIndex) -> ((SpawnEgg)item).getColor(tintIndex, stack), new IItemProvider[]{item});
        }
        for (RegistryObject registryItem : ModItems.ITEMS.getEntries()) {
            Block block;
            item = (Item)registryItem.get();
            if (item instanceof Honeycomb) {
                colors.func_199877_a((stack, tintIndex) -> ((Honeycomb)item).getColor(stack), new IItemProvider[]{item});
                continue;
            }
            if (!(item instanceof BlockItem) || !((block = ((BlockItem)item).func_179223_d()) instanceof CombBlock)) continue;
            colors.func_199877_a((stack, tintIndex) -> ((CombBlock)block).getColor(stack), new IItemProvider[]{item});
        }
        colors.func_199877_a((stack, tintIndex) -> {
            BlockState blockstate = ((BlockItem)stack.func_77973_b()).func_179223_d().func_176223_P();
            return blockColors.func_228054_a_(blockstate, null, null, tintIndex);
        }, new IItemProvider[]{(IItemProvider)ModBlocks.BUMBLEBEE_NEST.get()});
    }

    public static void registerBlockColors(ColorHandlerEvent.Block event) {
        BlockColors colors = event.getBlockColors();
        colors.func_186722_a((blockState, lightReader, pos, tintIndex) -> lightReader != null && pos != null ? BiomeColors.func_228358_a_((ILightReader)lightReader, (BlockPos)pos) : -1, new Block[]{(Block)ModBlocks.SUGAR_CANE_NEST.get()});
        colors.func_186722_a((blockState, lightReader, pos, tintIndex) -> lightReader != null && pos != null ? BiomeColors.func_228358_a_((ILightReader)lightReader, (BlockPos)pos) : GrassColors.func_77480_a((double)0.5, (double)1.0), new Block[]{(Block)ModBlocks.BUMBLEBEE_NEST.get()});
        for (RegistryObject registryBlock : ModBlocks.BLOCKS.getEntries()) {
            Block block = (Block)registryBlock.get();
            if (!(block instanceof CombBlock)) continue;
            colors.func_186722_a((blockState, lightReader, pos, tintIndex) -> ((CombBlock)block).getColor(lightReader, pos), new Block[]{block});
        }
    }

    public static void registerParticles(ParticleFactoryRegisterEvent event) {
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ModParticles.COLORED_FALLING_NECTAR.get(), FallingNectarParticle.FallingNectarFactory::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ModParticles.COLORED_POPPING_NECTAR.get(), PoppingNectarParticle.PoppingNectarFactory::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ModParticles.COLORED_LAVA_NECTAR.get(), LavaNectarParticle.LavaNectarFactory::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ModParticles.COLORED_PORTAL_NECTAR.get(), PortalNectarParticle.PortalNectarFactory::new);
    }

    private static void registerEntityRendering() {
        for (RegistryObject registryObject : ModEntities.HIVE_BEES.getEntries()) {
            EntityType bee = (EntityType)registryObject.get();
            String key = bee.func_210760_d();
            if (key.contains("dye_bee")) {
                RenderingRegistry.registerEntityRenderingHandler((EntityType)bee, DyeBeeRenderer::new);
                continue;
            }
            if (key.contains("rancher_bee") || key.contains("farmer_bee")) {
                RenderingRegistry.registerEntityRenderingHandler((EntityType)bee, RancherBeeRenderer::new);
                continue;
            }
            if (key.contains("hoarder_bee")) {
                RenderingRegistry.registerEntityRenderingHandler((EntityType)bee, HoarderBeeRenderer::new);
                continue;
            }
            RenderingRegistry.registerEntityRenderingHandler((EntityType)bee, ProductiveBeeRenderer::new);
        }
        for (RegistryObject registryObject : ModEntities.SOLITARY_BEES.getEntries()) {
            RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)registryObject.get()), ProductiveBeeRenderer::new);
        }
        ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.BEE_BOMB.get()), entity -> new SpriteRenderer(entity, itemRenderer));
    }

    private static void registerBlockRendering() {
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.COMB_GHOSTLY.get()), (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.SLIMY_NEST.get()), (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.BUMBLEBEE_NEST.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.SUGAR_CANE_NEST.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.JAR.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.INVISIBLE_REDSTONE_BLOCK.get()), (RenderType)RenderType.func_228643_e_());
    }
}

